package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.gui.GuiBook;

import org.jetbrains.annotations.Nullable;

public class GuiButtonCategory extends class_4185 {

	private static final int ANIM_TIME = 5;

	private final GuiBook parent;
	@Nullable private BookCategory category;
	private final BookIcon icon;
	private final class_2561 name;
	private final int u, v;
	private float timeHovered;

	public GuiButtonCategory(GuiBook parent, int x, int y, BookCategory category, class_4185.class_4241 onPress) {
		this(parent, x, y, category.getIcon(), category.getName(), onPress);
		this.category = category;
	}

	public GuiButtonCategory(GuiBook parent, int x, int y, BookIcon icon, class_2561 name, class_4185.class_4241 onPress) {
		super(parent.bookLeft + x, parent.bookTop + y, 20, 20, name, onPress, field_40754);
		this.parent = parent;
		this.u = x;
		this.v = y;
		this.icon = icon;
		this.name = name;
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
		if (field_22763) {
			if (method_25367()) {
				timeHovered = Math.min(ANIM_TIME, timeHovered + ClientTicker.delta);
			} else {
				timeHovered = Math.max(0, timeHovered - ClientTicker.delta);
			}

			float time = Math.max(0, Math.min(ANIM_TIME, timeHovered + (method_25367() ? partialTicks : -partialTicks)));
			float transparency = 0.5F - (time / ANIM_TIME) * 0.5F;
			boolean locked = category != null && category.isLocked();

			if (locked) {
				RenderSystem.setShaderColor(1F, 1F, 1F, 0.7F);
				GuiBook.drawLock(graphics, parent.book, method_46426() + 2, method_46427() + 2);
			} else {
				icon.render(graphics, method_46426() + 2, method_46427() + 2);
			}

			graphics.method_51448().method_22903();
			RenderSystem.enableBlend();
			RenderSystem.setShaderColor(1F, 1F, 1F, transparency);
			graphics.method_51448().method_46416(0, 0, 200);
			GuiBook.drawFromTexture(graphics, parent.book, method_46426(), method_46427(), u, v, field_22758, field_22759);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);

			if (category != null && !category.isLocked()) {
				GuiBook.drawMarking(graphics, parent.book, method_46426(), method_46427(), 0, category.getReadState());
			}
			graphics.method_51448().method_22909();

			if (method_25367()) {
				parent.setTooltip(locked
						? class_2561.method_43471("patchouli.gui.lexicon.locked").method_27692(class_124.field_1080)
						: name);
			}
		}
	}

	@Override
	public void method_25354(class_1144 soundHandlerIn) {
		if (category != null && !category.isLocked()) {
			GuiBook.playBookFlipSound(parent.book);
		}
	}

	public BookCategory getCategory() {
		return category;
	}

}
