package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

/**
 * BookContentLoader that directly queries the Resource Pack system when queried
 */
public final class BookContentResourceDirectLoader implements BookContentLoader {
	public static final BookContentResourceDirectLoader INSTANCE = new BookContentResourceDirectLoader();

	private BookContentResourceDirectLoader() {}

	@Override
	public void findFiles(Book book, String dir, List<class_2960> list) {
		String prefix = String.format("%s/%s/%s/%s", BookRegistry.BOOKS_LOCATION, book.id.method_12832(), BookContentsBuilder.DEFAULT_LANG, dir);
		Collection<class_2960> files = class_310.method_1551().method_1478().method_14488(prefix, p -> p.method_12832().endsWith(".json")).keySet();

		files.stream()
				.distinct()
				.filter(file -> file.method_12836().equals(book.id.method_12836()))
				.map(file -> {
					// caller expects list to contain logical id's, not file paths.
					// we end up going from path -> id -> back to path, but it's okay as a transitional measure
					Preconditions.checkArgument(file.method_12832().startsWith(prefix));
					Preconditions.checkArgument(file.method_12832().endsWith(".json"));
					String newPath = file.method_12832().substring(prefix.length(), file.method_12832().length() - ".json".length());
					// Vanilla expects `prefix` above to not have a trailing slash, so we
					// have to remove it ourselves from the path
					if (newPath.startsWith("/")) {
						newPath = newPath.substring(1);
					}
					return new class_2960(file.method_12836(), newPath);
				})
				.forEach(list::add);
	}

	@Nullable
	@Override
	public LoadResult loadJson(Book book, class_2960 file) {
		PatchouliAPI.LOGGER.debug("Loading {}", file);
		class_3300 manager = class_310.method_1551().method_1478();
		try {
			var resourceOpt = manager.method_14486(file);
			if (resourceOpt.isPresent()) {
				class_3298 resource = resourceOpt.get();
				return new LoadResult(
						BookContentLoader.streamToJson(resource.method_14482()),
						computeAddedByText(resource.method_14480(), book)
				);
			} else {
				return null;
			}
		} catch (IOException ex) {
			throw new UncheckedIOException(ex);
		}
	}

	@Nullable
	private static String computeAddedByText(String sourcePackId, Book book) {
		// Resource packs are named by "file/<packname>"
		if (sourcePackId.startsWith("file/")) {
			sourcePackId = sourcePackId.substring(5);
		}

		// Forge and Fabric lump all mod resources into one dummy pack.
		// Unsure how to handle them for now. TODO: Fix this
		// We'd like to show only those packs that are not in the one that originally
		// declared the book.
		if (sourcePackId.equals("mod_resources") || sourcePackId.equals("fabric")) {
			return null;
		}

		return sourcePackId;
	}
}
