/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.forge.common;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.command.OpenBookCommand;
import vazkii.patchouli.common.handler.LecternEventHandler;
import vazkii.patchouli.common.handler.ReloadContentsHandler;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.forge.common.ForgePatchouliConfig;
import vazkii.patchouli.forge.network.ForgeNetworkHandler;
import vazkii.patchouli.forge.xplat.ForgeXplatImpl;
import vazkii.patchouli.xplat.XplatAbstractions;

@Mod.EventBusSubscriber(modid="patchouli", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="patchouli")
public class ForgeModInitializer {
    public ForgeModInitializer() {
        XplatAbstractions.setInstance(new ForgeXplatImpl());
        ForgePatchouliConfig.setup();
    }

    @SubscribeEvent
    public static void registerSound(RegistryEvent.Register<SoundEvent> evt) {
        PatchouliSounds.submitRegistrations((id, e) -> evt.getRegistry().register((IForgeRegistryEntry)((SoundEvent)e.setRegistryName(id))));
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> evt) {
        PatchouliItems.submitItemRegistrations((id, e) -> evt.getRegistry().register((IForgeRegistryEntry)((Item)e.setRegistryName(id))));
    }

    @SubscribeEvent
    public static void registerRecipeSerializer(RegistryEvent.Register<RecipeSerializer<?>> evt) {
        PatchouliItems.submitRecipeSerializerRegistrations((id, e) -> evt.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)e.setRegistryName(id))));
    }

    @SubscribeEvent
    public static void onInitialize(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addListener(e -> OpenBookCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternEventHandler.rightClick(e.getPlayer(), e.getWorld(), e.getHand(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        ForgeNetworkHandler.registerMessages();
        BookRegistry.INSTANCE.init();
        MinecraftForge.EVENT_BUS.addListener(e -> ReloadContentsHandler.dataReloaded(e.getServer(), e.getServer().getServerResources(), true));
    }
}

