/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;

public final class ItemStackUtil {
    private static final Gson GSON = new GsonBuilder().create();

    private ItemStackUtil() {
    }

    public static String serializeStack(ItemStack stack) {
        StringBuilder builder = new StringBuilder();
        builder.append(Registry.f_122827_.m_7981_((Object)stack.m_41720_()));
        int count = stack.m_41613_();
        if (count > 1) {
            builder.append("#");
            builder.append(count);
        }
        if (stack.m_41782_()) {
            Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stack.m_41783_());
            JsonElement j = (JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue();
            builder.append(GSON.toJson(j));
        }
        return builder.toString();
    }

    public static ItemStack loadStackFromString(String res) {
        String[] tokens;
        String nbt = "";
        int nbtStart = res.indexOf("{");
        if (nbtStart > 0) {
            nbt = res.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            res = res.substring(0, nbtStart);
        }
        String[] upper = res.split("#");
        String count = "1";
        if (upper.length > 1) {
            res = upper[0];
            count = upper[1];
        }
        if ((tokens = res.split(":")).length < 2) {
            return ItemStack.f_41583_;
        }
        int countn = Integer.parseInt(count);
        ResourceLocation key = new ResourceLocation(tokens[0], tokens[1]);
        Optional maybeItem = Registry.f_122827_.m_6612_(key);
        if (maybeItem.isEmpty()) {
            throw new RuntimeException("Unknown item ID: " + key);
        }
        Item item = (Item)maybeItem.get();
        ItemStack stack = new ItemStack((ItemLike)item, countn);
        if (!nbt.isEmpty()) {
            try {
                stack.m_41751_(TagParser.m_129359_((String)nbt));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Failed to parse ItemStack JSON", e);
            }
        }
        return stack;
    }

    public static String serializeIngredient(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.m_43908_();
        CharSequence[] stacksSerialized = new String[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacksSerialized[i] = ItemStackUtil.serializeStack(stacks[i]);
        }
        return String.join((CharSequence)",", stacksSerialized);
    }

    public static Ingredient loadIngredientFromString(String ingredientString) {
        return Ingredient.m_43927_((ItemStack[])ItemStackUtil.loadStackListFromString(ingredientString).toArray(new ItemStack[0]));
    }

    public static String serializeStackList(List<ItemStack> stacks) {
        StringJoiner joiner = new StringJoiner(",");
        for (ItemStack stack : stacks) {
            joiner.add(ItemStackUtil.serializeStack(stack));
        }
        return joiner.toString();
    }

    public static List<ItemStack> loadStackListFromString(String ingredientString) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String s : stacksSerialized) {
            if (s.startsWith("tag:")) {
                Tag tag = ItemTags.m_13193_().m_13404_(new ResourceLocation(s.substring(4)));
                if (tag == null) continue;
                for (Item item : tag.m_6497_()) {
                    stacks.add(new ItemStack((ItemLike)item));
                }
                continue;
            }
            stacks.add(ItemStackUtil.loadStackFromString(s));
        }
        return stacks;
    }

    public static StackWrapper wrapStack(ItemStack stack) {
        return stack.m_41619_() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    @Nullable
    public static Book getBookFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!b.getBookItem().m_41726_(stack)) continue;
            return b;
        }
        return null;
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        Character insideString = null;
        block7: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block7;
                    ++braces;
                    continue block7;
                }
                case '}': {
                    if (insideString != null) continue block7;
                    --braces;
                    continue block7;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block7;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block7;
                }
                case ',': {
                    if (braces > 0) continue block7;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[0]);
    }

    public static ItemStack loadStackFromJson(JsonObject json) {
        String itemName = json.get("item").getAsString();
        Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(itemName)).orElseThrow(() -> new IllegalArgumentException("Unknown item '" + itemName + "'"));
        ItemStack stack = new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundTag nbt = element.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(element)) : TagParser.m_129359_((String)element.getAsString());
                stack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Invalid NBT Entry: " + e, e);
            }
        }
        return stack;
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(ItemStack.f_41583_);
        public final ItemStack stack;

        public StackWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && ItemStack.m_41758_((ItemStack)this.stack, (ItemStack)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.m_41720_().hashCode();
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

