/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import java.io.File;
import java.io.FileInputStream;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.xplat.XplatAbstractions;
import vazkii.patchouli.xplat.XplatModContainer;

public class BookFolderLoader {
    public static File loadDir;

    private static void setup() {
        loadDir = new File("patchouli_books");
        if (!loadDir.exists()) {
            loadDir.mkdir();
        } else if (!loadDir.isDirectory()) {
            throw new RuntimeException(loadDir.getAbsolutePath() + " is a file, not a folder, aborting. Please delete this file or move it elsewhere if it has important contents.");
        }
    }

    public static void findBooks() {
        if (loadDir == null) {
            BookFolderLoader.setup();
        }
        XplatModContainer self = XplatAbstractions.getInstance().getModContainer("patchouli");
        File[] subdirs = loadDir.listFiles(File::isDirectory);
        if (subdirs == null) {
            PatchouliAPI.LOGGER.warn("Failed to list external books in {}, not loading external books", (Object)loadDir.getAbsolutePath());
            return;
        }
        for (File dir : subdirs) {
            ResourceLocation res;
            try {
                res = new ResourceLocation("patchouli", dir.getName());
            }
            catch (ResourceLocationException ex) {
                PatchouliAPI.LOGGER.error("Invalid external book folder name {}, skipping", (Object)dir.getName(), (Object)ex);
                continue;
            }
            File bookJson = new File(dir, "book.json");
            try (FileInputStream stream = new FileInputStream(bookJson);){
                BookRegistry.INSTANCE.loadBook(self, res, stream, true);
            }
            catch (Exception e) {
                PatchouliAPI.LOGGER.error("Failed to load external book json from {}, skipping", (Object)bookJson, (Object)e);
            }
        }
    }
}

