/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.recipe;

import com.google.common.base.Preconditions;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.recipe.BookRecipeSerializer;

public class ShapelessBookRecipe
extends ShapelessRecipe {
    public static final RecipeSerializer<ShapelessBookRecipe> SERIALIZER = new BookRecipeSerializer<ShapelessRecipe, ShapelessBookRecipe>(RecipeSerializer.SHAPELESS_RECIPE, ShapelessBookRecipe::new);

    public ShapelessBookRecipe(ShapelessRecipe compose, @Nullable ResourceLocation outputBook) {
        super(compose.getId(), compose.getGroup(), CraftingBookCategory.MISC, ShapelessBookRecipe.getOutputBook(compose, outputBook), compose.getIngredients());
    }

    private static ItemStack getOutputBook(ShapelessRecipe compose, @Nullable ResourceLocation outputBook) {
        Preconditions.checkArgument((compose.getClass() == ShapelessRecipe.class ? 1 : 0) != 0, (Object)"Must be exactly ShapelessRecipe");
        if (outputBook != null) {
            return PatchouliAPI.get().getBookStack(outputBook);
        }
        return compose.getResultItem((RegistryAccess)RegistryAccess.EMPTY);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

