/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

public record BookRecipeSerializer<T extends Recipe<?>, U extends T>(RecipeSerializer<T> compose, BiFunction<T, @Nullable ResourceLocation, U> converter) implements RecipeSerializer<U>
{
    @NotNull
    public U fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        if (!json.has("result")) {
            JsonObject object = new JsonObject();
            object.addProperty("item", PatchouliItems.BOOK_ID.toString());
            json.add("result", (JsonElement)object);
        }
        Recipe recipe = this.compose().fromJson(id, json);
        ResourceLocation outputBook = new ResourceLocation(GsonHelper.getAsString((JsonObject)json, (String)"book"));
        if (!BookRegistry.INSTANCE.books.containsKey(outputBook)) {
            PatchouliAPI.LOGGER.warn("Book {} in recipe {} does not exist!", (Object)outputBook, (Object)id);
        }
        return (U)((Recipe)this.converter().apply(recipe, outputBook));
    }

    @NotNull
    public U fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        Recipe recipe = this.compose().fromNetwork(id, buf);
        return (U)((Recipe)this.converter().apply(recipe, null));
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull U recipe) {
        this.compose().toNetwork(buf, recipe);
    }
}

