/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class TooltipHandler {
    private static float lexiconLookupTime = 0.0f;

    public static void onTooltip(GuiGraphics graphics, ItemStack stack, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        int tooltipX = mouseX;
        int tooltipY = mouseY - 4;
        if (mc.player != null && !(mc.screen instanceof GuiBook)) {
            int lexSlot = -1;
            ItemStack lexiconStack = ItemStack.EMPTY;
            Pair<BookEntry, Integer> lexiconEntry = null;
            for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
                Pair<BookEntry, Integer> entry;
                Book book;
                ItemStack stackAt = mc.player.getInventory().getItem(i);
                if (stackAt.isEmpty() || (book = ItemStackUtil.getBookFromStack(stackAt)) == null || (entry = book.getContents().getEntryForStack(stack)) == null || ((BookEntry)entry.getFirst()).isLocked()) continue;
                lexiconStack = stackAt;
                lexSlot = i;
                lexiconEntry = entry;
                break;
            }
            if (lexSlot > -1) {
                int x = tooltipX - 34;
                RenderSystem.disableDepthTest();
                graphics.fill(x - 4, tooltipY - 4, x + 20, tooltipY + 26, 0x44000000);
                graphics.fill(x - 6, tooltipY - 6, x + 22, tooltipY + 28, 0x44000000);
                if (PatchouliConfig.get().useShiftForQuickLookup() ? Screen.hasShiftDown() : Screen.hasControlDown()) {
                    int cx = x + 8;
                    int cy = tooltipY + 8;
                    float r = 12.0f;
                    float requiredTime = PatchouliConfig.get().quickLookupTime();
                    float angles = (lexiconLookupTime += ClientTicker.delta) / requiredTime * 360.0f;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    BufferBuilder buf = Tesselator.getInstance().getBuilder();
                    buf.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                    float a = 0.5f + 0.2f * ((float)Math.cos(ClientTicker.total / 10.0f) * 0.5f + 0.5f);
                    buf.vertex((double)cx, (double)cy, 0.0).color(0.0f, 0.5f, 0.0f, a).endVertex();
                    for (float i = angles; i > 0.0f; i -= 1.0f) {
                        double rad = (double)((i - 90.0f) / 180.0f) * Math.PI;
                        buf.vertex((double)cx + Math.cos(rad) * (double)r, (double)cy + Math.sin(rad) * (double)r, 0.0).color(0.0f, 1.0f, 0.0f, 1.0f).endVertex();
                    }
                    buf.vertex((double)cx, (double)cy, 0.0).color(0.0f, 1.0f, 0.0f, 0.0f).endVertex();
                    Tesselator.getInstance().end();
                    RenderSystem.disableBlend();
                    if (lexiconLookupTime >= requiredTime) {
                        mc.player.getInventory().selected = lexSlot;
                        int spread = (Integer)lexiconEntry.getSecond();
                        ClientBookRegistry.INSTANCE.displayBookGui(((BookEntry)lexiconEntry.getFirst()).getBook().id, ((BookEntry)lexiconEntry.getFirst()).getId(), spread * 2);
                    }
                } else {
                    lexiconLookupTime = 0.0f;
                }
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 300.0f);
                graphics.renderItem(lexiconStack, x, tooltipY);
                graphics.renderItemDecorations(mc.font, lexiconStack, x, tooltipY);
                graphics.pose().popPose();
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 500.0f);
                graphics.drawString(mc.font, "?", x + 10, tooltipY + 8, -1, true);
                graphics.pose().scale(0.5f, 0.5f, 1.0f);
                boolean mac = Minecraft.ON_OSX;
                MutableComponent key = Component.literal((String)(PatchouliConfig.get().useShiftForQuickLookup() ? "Shift" : (mac ? "Cmd" : "Ctrl"))).withStyle(ChatFormatting.BOLD);
                graphics.drawString(mc.font, (Component)key, (x + 10) * 2 - 16, (tooltipY + 8) * 2 + 20, -1, true);
                graphics.pose().popPose();
                RenderSystem.enableDepthTest();
            } else {
                lexiconLookupTime = 0.0f;
            }
        } else {
            lexiconLookupTime = 0.0f;
        }
    }
}

