/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookRightClickHandler {
    public static void onRenderHUD(GuiGraphics graphics, float partialTicks) {
        BookEntry entry;
        Pair<BookEntry, Integer> hover;
        Book book;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ItemStack bookStack = player.getMainHandItem();
        if (mc.screen == null && (book = ItemStackUtil.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null && !(entry = (BookEntry)hover.getFirst()).isLocked()) {
            Window window = mc.getWindow();
            int x = window.getGuiScaledWidth() / 2 + 3;
            int y = window.getGuiScaledHeight() / 2 + 3;
            entry.getIcon().render(graphics, x, y);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 10.0f);
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            graphics.renderItem(bookStack, (x + 8) * 2, (y + 8) * 2);
            graphics.renderItemDecorations(mc.font, bookStack, (x + 8) * 2, (y + 8) * 2);
            graphics.pose().popPose();
            graphics.drawString(mc.font, (Component)entry.getName(), x + 18, y + 3, 0xFFFFFF, false);
            graphics.pose().pushPose();
            graphics.pose().scale(0.75f, 0.75f, 1.0f);
            MutableComponent s = Component.translatable((String)("patchouli.gui.lexicon." + (player.isShiftKeyDown() ? "view" : "sneak"))).withStyle(ChatFormatting.ITALIC);
            graphics.drawString(mc.font, (Component)s, (int)((float)(x + 18) / 0.75f), (int)((float)(y + 14) / 0.75f), 0xBBBBBB, false);
            graphics.pose().popPose();
        }
    }

    public static InteractionResult onRightClick(Player player, Level world, InteractionHand hand, BlockHitResult hit) {
        Pair<BookEntry, Integer> hover;
        Book book;
        ItemStack bookStack = player.getMainHandItem();
        if (world.isClientSide && player.isShiftKeyDown() && (book = ItemStackUtil.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null) {
            int page = (Integer)hover.getSecond() * 2;
            book.getContents().setTopEntry(((BookEntry)hover.getFirst()).getId(), page);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static Pair<BookEntry, Integer> getHoveredEntry(Book book) {
        BlockHitResult hit;
        BlockPos pos;
        BlockState state;
        Block block;
        ItemStack picked;
        Minecraft mc = Minecraft.getInstance();
        HitResult res = mc.hitResult;
        if (mc.level != null && res instanceof BlockHitResult && !(picked = (block = (state = mc.level.getBlockState(pos = (hit = (BlockHitResult)res).getBlockPos())).getBlock()).getCloneItemStack((BlockGetter)mc.level, pos, state)).isEmpty()) {
            return book.getContents().getEntryForStack(picked);
        }
        return null;
    }
}

