/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBookEntryList
extends GuiBook {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    private BookTextRenderer text;
    protected final List<Button> entryButtons = new ArrayList<Button>();
    private List<BookEntry> allEntries;
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private EditBox searchField;

    public GuiBookEntryList(Book book, Component title) {
        super(book, title);
    }

    @Override
    public void init() {
        super.init();
        this.text = new BookTextRenderer(this, (Component)Component.literal((String)this.getDescriptionText()), 15, 40);
        this.allEntries = new ArrayList<BookEntry>(this.getEntries());
        this.allEntries.removeIf(BookEntry::shouldHide);
        if (this.shouldSortEntryList()) {
            Collections.sort(this.allEntries);
        }
        this.searchField = this.createSearchBar();
        this.buildEntryButtons();
    }

    protected EditBox createSearchBar() {
        EditBox field = new EditBox(this.font, 160, 170, 90, 12, (Component)Component.empty());
        field.setMaxLength(32);
        field.setBordered(false);
        field.setCanLoseFocus(false);
        field.setFocused(true);
        return field;
    }

    protected abstract String getDescriptionText();

    protected abstract Collection<BookEntry> getEntries();

    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return true;
    }

    protected boolean shouldDrawProgressBar() {
        return true;
    }

    protected boolean shouldSortEntryList() {
        return true;
    }

    protected void addSubcategoryButtons() {
    }

    @Override
    void drawForegroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        if (this.spread == 0) {
            this.drawCenteredStringNoShadow(graphics, this.getTitle().getVisualOrderText(), 73, 18, this.book.headerColor);
            this.drawCenteredStringNoShadow(graphics, this.getChapterListTitle(), 199, 18, this.book.headerColor);
            GuiBookEntryList.drawSeparator(graphics, this.book, 15, 30);
            GuiBookEntryList.drawSeparator(graphics, this.book, 141, 30);
            this.text.render(graphics, mouseX, mouseY);
            if (this.shouldDrawProgressBar()) {
                this.drawProgressBar(graphics, this.book, mouseX, mouseY, this::doesEntryCountForProgress);
            }
        } else if (this.spread % 2 == 1 && this.spread == this.maxSpreads - 1 && this.entryButtons.size() <= 13) {
            GuiBookEntryList.drawPageFiller(graphics, this.book);
        }
        if (!this.searchField.getValue().isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookEntryList.drawFromTexture(graphics, this.book, this.searchField.getX() - 8, this.searchField.getY(), 140, 183, 99, 14);
            MutableComponent toDraw = Component.literal((String)this.searchField.getValue()).setStyle(this.book.getFontStyle());
            graphics.drawString(this.font, (Component)toDraw, this.searchField.getX() + 7, this.searchField.getY() + 1, this.book.textColor, false);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.getValue().isEmpty()) {
                this.drawCenteredStringNoShadow(graphics, I18n.get((String)"patchouli.gui.lexicon.no_results", (Object[])new Object[0]), 199, 80, 0x333333);
                graphics.pose().scale(2.0f, 2.0f, 2.0f);
                this.drawCenteredStringNoShadow(graphics, I18n.get((String)"patchouli.gui.lexicon.sad", (Object[])new Object[0]), 99, 47, 0x999999);
                graphics.pose().scale(0.5f, 0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(graphics, this.getNoEntryMessage(), 199, 80, 0x333333);
            }
        }
    }

    protected String getChapterListTitle() {
        return I18n.get((String)"patchouli.gui.lexicon.chapters", (Object[])new Object[0]);
    }

    protected String getNoEntryMessage() {
        return I18n.get((String)"patchouli.gui.lexicon.no_entries", (Object[])new Object[0]);
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text.click(mouseX, mouseY, mouseButton) || this.searchField.mouseClicked(mouseX - (double)this.bookLeft, mouseY - (double)this.bookTop, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public boolean charTyped(char c, int i) {
        String currQuery = this.searchField.getValue();
        if (this.searchField.charTyped(c, i)) {
            if (!this.searchField.getValue().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.charTyped(c, i);
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.getValue();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                this.displayLexiconGui(new GuiBookEntry(this.book, this.visibleEntries.get(0)), true);
                return true;
            }
        } else if (this.searchField.keyPressed(key, scanCode, modifiers)) {
            if (!this.searchField.getValue().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public void handleButtonCategory(Button button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    public void handleButtonEntry(Button button) {
        GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    void buildEntryButtons() {
        this.removeDrawablesIn(this.entryButtons);
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.getValue().toLowerCase();
        this.allEntries.stream().filter(e -> e.isFoundByQuery(query)).forEach(this.visibleEntries::add);
        this.maxSpreads = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxSpreads += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.spread;
        }
        if (this.spread == 0) {
            this.addEntryButtons(141, 38, 0, 11);
            this.addSubcategoryButtons();
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(15, 18, start, 13);
            this.addEntryButtons(141, 18, start + 13, 13);
        }
    }

    int getEntryCountStart() {
        if (this.spread == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.spread - 1);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.visibleEntries.get(start + i), this::handleButtonEntry);
            this.addRenderableWidget(button);
            this.entryButtons.add(button);
        }
    }

    public String getSearchQuery() {
        return this.searchField.getValue();
    }
}

