/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

import vazkii.botania.common.block.block_entity.CellularBlockEntity;

public class CellularBlock extends BotaniaBlock implements EntityBlock {

	public CellularBlock(Properties builder) {
		super(builder);
	}

	@Override
	public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
		if (level.getBlockEntity(pos) instanceof CellularBlockEntity cell) {
			cell.update(level);
		}

	}

	@Override
	public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
		return new CellularBlockEntity(pos, state);
	}

}
