/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.FlowerPouchItem;
import vazkii.botania.test.TestingUtil;

public class FlowerPouchTest {
    @GameTest(template="fabric-gametest-api-v1:empty")
    public void testNoShinyFlowers(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.CREATIVE);
        ItemStack bag = new ItemStack((ItemLike)BotaniaItems.flowerBag);
        player.getInventory().setItem(1, bag);
        ItemEntity flower = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)BotaniaBlocks.blackShinyFlower, 64));
        TestingUtil.assertThat(!FlowerPouchItem.onPickupItem(flower, player), () -> "Should not pick up glimmering flowers");
        TestingUtil.assertEquals(flower.getItem().getItem(), BotaniaBlocks.blackShinyFlower.asItem());
        TestingUtil.assertEquals(flower.getItem().getCount(), 64);
        SimpleContainer inv = FlowerPouchItem.getInventory(bag);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            TestingUtil.assertThat(inv.getItem(i).isEmpty(), () -> "Bag should be empty");
        }
        helper.succeed();
    }

    @GameTest(template="fabric-gametest-api-v1:empty")
    public void testPickupBasic(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.CREATIVE);
        ItemStack bag = new ItemStack((ItemLike)BotaniaItems.flowerBag);
        player.getInventory().setItem(1, bag);
        ItemEntity flower = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)BotaniaBlocks.blackFlower, 64));
        TestingUtil.assertThat(FlowerPouchItem.onPickupItem(flower, player), () -> "Pickup should succeed since the bag has room");
        TestingUtil.assertThat(flower.getItem().isEmpty(), () -> "Should have consumed everything");
        ItemStack flowerInBag = FlowerPouchItem.getInventory(bag).getItem(DyeColor.BLACK.getId());
        TestingUtil.assertThat(!flowerInBag.isEmpty(), () -> "Bag should have an item in black slot");
        TestingUtil.assertEquals(flowerInBag.getItem(), BotaniaBlocks.blackFlower.asItem());
        TestingUtil.assertEquals(flowerInBag.getCount(), 64);
        helper.succeed();
    }
}

