/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import java.util.Objects;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.item.AstrolabeItem;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.test.TestingUtil;
import vazkii.botania.xplat.XplatAbstractions;

public class AstrolabeTest {
    private static final String TEMPLATE_CANDLES = "botania:item/astrolabe_candles";
    private static final Block BLOCK_CANDLES = Blocks.YELLOW_CANDLE;
    private static final BlockPos POS_WATER_SLAB = new BlockPos(2, 2, 3);
    private static final BlockPos POS_SEAGRASS = new BlockPos(2, 2, 1);
    private static final BlockPos POS_SUPPORTED_CANDLE = new BlockPos(2, 4, 1);
    private static final BlockPos POS_FLOATING_CANDLE = new BlockPos(2, 4, 3);
    private static final Vec3 POS_PLAYER_CANDLES = new Vec3(0.9, 3.0, 2.5);
    private static final Vec3 LOOK_TARGET_CANDLES_HORIZONTAL = new Vec3(2.9, 2.0, 2.5);
    private static final Vec3 LOOK_TARGET_CANDLES_VERTICAL = new Vec3(3.5, 2.0, 2.5);
    private static final int EXPECTED_REMAINING_CANDLES_HORIZONTAL_3X3 = 56;
    private static final int EXPECTED_REMAINING_CANDLES_VERTICAL_3X3 = 60;
    private static final int EXPECTED_REMAINING_CANDLES_VERTICAL_5X5 = 58;
    private static final int SLOT_FIRST_PROVIDER = 2;
    private static final int SLOT_SECOND_PROVIDER = 3;
    private static final String TEMPLATE_DIRECTIONAL = "botania:item/astrolabe_directional";
    private static final Block BLOCK_LOG = Blocks.OAK_LOG;
    private static final Block BLOCK_PISTON = Blocks.PISTON;
    private static final Vec3 POS_PLAYER_DIRECTIONAL = new Vec3(1.0, 2.0, 0.5);
    private static final Vec3 LOOK_TARGET_DIRECTIONAL_X = new Vec3(2.5, 2.0, 3.0);
    private static final Vec3 LOOK_TARGET_DIRECTIONAL_Y = new Vec3(2.1, 2.0, 2.5);
    private static final Vec3 LOOK_TARGET_DIRECTIONAL_Z = new Vec3(2.5, 2.0, 2.5);
    private static final String TEMPLATE_MANA = "botania:item/astrolabe_mana";
    private static final Vec3 POS_PLAYER_MANA = new Vec3(6.5, 2.0, 6.5);
    private static final int SIZE_ASTROLABE = 11;
    private static final int COST_ASTROLABE = 3520;
    private static final int MANA_NOT_ENOUGH = 15000;
    private static final int MANA_BARELY_ENOUGH = 19910;
    private static final int SLOT_TABLET = 1;

    @GameTest(template="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3(GameTestHelper helper) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        player.addItem(new ItemStack((ItemLike)BLOCK_CANDLES.asItem(), 64));
        ItemStack stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        this.checkWaterSlabAndSeaGrass(helper);
        helper.assertBlockState(POS_WATER_SLAB.above(), BlockBehaviour.BlockStateBase::isAir, () -> "Expected air above water slab, but found " + String.valueOf(helper.getBlockState(POS_WATER_SLAB.above())));
        helper.assertBlockState(POS_SEAGRASS.above(), state -> state.is(Blocks.SMOOTH_STONE_SLAB), () -> "Expected slab above sea grass, but found " + String.valueOf(helper.getBlockState(POS_SEAGRASS.above())));
        for (BlockPos pos : BlockPos.betweenClosed((int)1, (int)2, (int)1, (int)3, (int)2, (int)3)) {
            if (pos.equals((Object)POS_WATER_SLAB)) continue;
            helper.assertBlockState(pos, block -> block.is(BLOCK_CANDLES), () -> "Missing candle, found " + String.valueOf(helper.getBlockState(pos)));
            helper.assertBlockProperty(pos, (Property)CandleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        this.checkRemainingCandles(player, 56, 2);
        this.checkRemainingMana(player, 499040);
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3Offhand(GameTestHelper helper) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        player.addItem(new ItemStack((ItemLike)BLOCK_CANDLES.asItem(), 64));
        ItemStack stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        player.setItemInHand(InteractionHand.OFF_HAND, stack);
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        this.useAstrolabe(player, stack, InteractionHand.OFF_HAND);
        this.checkRemainingCandles(player, 56, 2);
        this.checkRemainingMana(player, 499040);
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3MultipleSourcesTalismanLast(GameTestHelper helper) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        player.addItem(new ItemStack((ItemLike)BLOCK_CANDLES.asItem(), 5));
        ItemStack blackHoleTalisman = new ItemStack((ItemLike)BotaniaItems.blackHoleTalisman);
        BlackHoleTalismanItem.setBlock(blackHoleTalisman, BLOCK_CANDLES);
        BlackHoleTalismanItem.setCount(blackHoleTalisman, 5);
        player.addItem(blackHoleTalisman);
        ItemStack stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        this.checkRemainingCandles(player, 0, 2);
        this.checkRemainingTalismanCandles(player, 2, 3);
        this.checkRemainingMana(player, 499040);
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3MultipleSourcesTalismanFirst(GameTestHelper helper) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        ItemStack blackHoleTalisman = new ItemStack((ItemLike)BotaniaItems.blackHoleTalisman);
        BlackHoleTalismanItem.setBlock(blackHoleTalisman, BLOCK_CANDLES);
        BlackHoleTalismanItem.setCount(blackHoleTalisman, 5);
        player.addItem(blackHoleTalisman);
        player.addItem(new ItemStack((ItemLike)BLOCK_CANDLES.asItem(), 5));
        ItemStack stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        this.checkRemainingCandles(player, 2, 3);
        this.checkRemainingTalismanCandles(player, 0, 2);
        this.checkRemainingMana(player, 499040);
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_candles")
    public void testCandlesVertical3x3(GameTestHelper helper) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_VERTICAL, 500000);
        player.addItem(new ItemStack((ItemLike)BLOCK_CANDLES.asItem(), 64));
        ItemStack stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        this.checkThreeByThreeVerticalCandleArea(helper);
        this.checkRemainingCandles(player, 60, 2);
        this.checkRemainingMana(player, 499040);
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_candles")
    public void testCandlesVertical5x5(GameTestHelper helper) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_VERTICAL, 500000);
        player.addItem(new ItemStack((ItemLike)BLOCK_CANDLES.asItem(), 64));
        ItemStack stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        AstrolabeItem.setSize(stack, 5);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        this.checkThreeByThreeVerticalCandleArea(helper);
        helper.assertBlockState(POS_WATER_SLAB.above().south(), block -> block.is(BLOCK_CANDLES), () -> "Expected candle on rim next to water slab, but found " + String.valueOf(helper.getBlockState(POS_WATER_SLAB.above().south())));
        helper.assertBlockState(POS_SEAGRASS.above().north(), block -> block.is(BLOCK_CANDLES), () -> "Expected candle on rim next to seagrass, but found " + String.valueOf(helper.getBlockState(POS_WATER_SLAB.above().north())));
        this.checkRemainingCandles(player, 58, 2);
        this.checkRemainingMana(player, 498400);
        helper.succeed();
    }

    private void checkRemainingCandles(Player player, int expectedRemaining, int candlesSlot) {
        ItemStack remainingCandles = player.getInventory().getItem(candlesSlot);
        TestingUtil.assertThat(expectedRemaining == 0 || remainingCandles.is(Items.YELLOW_CANDLE), () -> "Unexpected item in candles slot: " + String.valueOf(remainingCandles));
        TestingUtil.assertEquals(expectedRemaining, remainingCandles.getCount(), () -> String.format("Incorrect number of remaining candles in inventory, expected %d, found %d", expectedRemaining, remainingCandles.getCount()));
    }

    private void checkRemainingTalismanCandles(Player player, int expectedRemaining, int talismanSlot) {
        ItemStack remainingTalisman = player.getInventory().getItem(talismanSlot);
        TestingUtil.assertThat(expectedRemaining == 0 || remainingTalisman.is(BotaniaItems.blackHoleTalisman), () -> "Unexpected item in talisman slot: " + String.valueOf(remainingTalisman));
        int count = BlackHoleTalismanItem.getBlockCount(remainingTalisman);
        TestingUtil.assertEquals(expectedRemaining, count, () -> String.format("Incorrect number of remaining candles in talisman, expected %d, found %d", expectedRemaining, count));
    }

    private void checkThreeByThreeVerticalCandleArea(GameTestHelper helper) {
        this.checkWaterSlabAndSeaGrass(helper);
        helper.assertBlockState(POS_WATER_SLAB.above(), block -> block.is(BLOCK_CANDLES), () -> "Expected candle on water slab, but found " + String.valueOf(helper.getBlockState(POS_WATER_SLAB.above())));
        helper.assertBlockProperty(POS_WATER_SLAB.above(), (Property)CandleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        helper.assertBlockState(POS_SEAGRASS.above(), state -> state.is(Blocks.SMOOTH_STONE_SLAB), () -> "Expected slab above sea grass, but found " + String.valueOf(helper.getBlockState(POS_SEAGRASS.above())));
        helper.assertBlockState(POS_FLOATING_CANDLE, block -> block.is(BLOCK_CANDLES), () -> "Floating candle was replaced with " + String.valueOf(helper.getBlockState(POS_FLOATING_CANDLE)));
        helper.assertBlockProperty(POS_FLOATING_CANDLE, (Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(1));
        helper.assertBlockProperty(POS_FLOATING_CANDLE, (Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
        helper.assertBlockProperty(POS_FLOATING_CANDLE, (Property)CandleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        helper.assertBlockState(POS_SUPPORTED_CANDLE, block -> block.is(BLOCK_CANDLES), () -> "Supported candle was replaced with " + String.valueOf(helper.getBlockState(POS_FLOATING_CANDLE)));
        helper.assertBlockProperty(POS_SUPPORTED_CANDLE, (Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2));
        helper.assertBlockProperty(POS_SUPPORTED_CANDLE, (Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
        helper.assertBlockProperty(POS_SUPPORTED_CANDLE, (Property)CandleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        for (BlockPos pos : BlockPos.betweenClosed((int)1, (int)2, (int)1, (int)3, (int)2, (int)3)) {
            if (pos.getX() != 2) {
                helper.assertBlockState(pos, block -> block.is(Blocks.WATER), () -> "Water was replaced with " + String.valueOf(helper.getBlockState(pos)));
                continue;
            }
            if (pos.equals((Object)POS_WATER_SLAB)) continue;
            helper.assertBlockState(pos, block -> block.is(BLOCK_CANDLES), () -> "Missing candle, found " + String.valueOf(helper.getBlockState(pos)));
            helper.assertBlockProperty(pos, (Property)CandleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
    }

    private void checkWaterSlabAndSeaGrass(GameTestHelper helper) {
        helper.assertBlockState(POS_WATER_SLAB, block -> block.is(Blocks.SMOOTH_STONE_SLAB), () -> "Slab was replaced with " + String.valueOf(helper.getBlockState(POS_WATER_SLAB)));
        helper.assertBlockState(POS_SEAGRASS, block -> !block.is(Blocks.SEAGRASS), () -> "Seagrass was not replaced");
    }

    @GameTest(template="botania:item/astrolabe_directional")
    public void testDirectionalLogsAxisX(GameTestHelper helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_X, BLOCK_LOG, BlockStateProperties.AXIS, Direction.Axis.X);
    }

    @GameTest(template="botania:item/astrolabe_directional")
    public void testDirectionalLogsAxisY(GameTestHelper helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Y, BLOCK_LOG, BlockStateProperties.AXIS, Direction.Axis.Y);
    }

    @GameTest(template="botania:item/astrolabe_directional")
    public void testDirectionalLogsAxisZ(GameTestHelper helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Z, BLOCK_LOG, BlockStateProperties.AXIS, Direction.Axis.Z);
    }

    @GameTest(template="botania:item/astrolabe_directional")
    public void testDirectionalPistonAxisX(GameTestHelper helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_X, BLOCK_PISTON, BlockStateProperties.FACING, Direction.NORTH);
    }

    @GameTest(template="botania:item/astrolabe_directional")
    public void testDirectionalPistonAxisY(GameTestHelper helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Y, BLOCK_PISTON, BlockStateProperties.FACING, Direction.NORTH);
    }

    @GameTest(template="botania:item/astrolabe_directional")
    public void testDirectionalPistonAxisZ(GameTestHelper helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Z, BLOCK_PISTON, BlockStateProperties.FACING, Direction.NORTH);
    }

    private <P extends Property<V>, V extends Comparable<V>> void testDirectionalBlockWithProperty(GameTestHelper helper, Vec3 lookTarget, Block block, P property, V value) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_DIRECTIONAL, lookTarget, 500000);
        player.addItem(new ItemStack((ItemLike)block.asItem(), 64));
        ItemStack stack = this.getAstrolabeForBlockType(player, block);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        for (BlockPos pos : BlockPos.betweenClosed((int)1, (int)2, (int)2, (int)3, (int)4, (int)2)) {
            helper.assertBlockState(pos, state -> state.is(block), () -> String.format("Expected %s but found %s", block, helper.getBlockState(pos).getBlock()));
            helper.assertBlockProperty(pos, property, prop -> prop.equals(value), String.format("Expected %s to be %s, but found %s", property.getName(), value, helper.getBlockState(pos).getValue(property)));
        }
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_mana")
    public void testNotEnoughMana(GameTestHelper helper) {
        Player player = this.mockAstrolabeAndUseWithCobbleRod(helper, 15000);
        this.checkRemainingMana(player, 15000);
        helper.forEveryBlockInStructure(blockPos -> helper.assertBlockNotPresent(Blocks.COBBLESTONE, blockPos));
        helper.succeed();
    }

    @GameTest(template="botania:item/astrolabe_mana")
    public void testBarelyNotEnoughMana(GameTestHelper helper) {
        Player player = this.mockAstrolabeAndUseWithCobbleRod(helper, 19910);
        int expectedMana = 40;
        this.checkRemainingMana(player, 40);
        int expectedNumberOfBlocks = 109;
        MutableInt actualNumberOfBlocks = new MutableInt();
        helper.forEveryBlockInStructure(blockPos -> {
            if (helper.getBlockState(blockPos).is(Blocks.COBBLESTONE)) {
                actualNumberOfBlocks.increment();
            }
        });
        TestingUtil.assertEquals(109, actualNumberOfBlocks.intValue(), () -> String.format("Expected %d placed blocks, found %d", 109, actualNumberOfBlocks.intValue()));
        helper.succeed();
    }

    private Player mockAstrolabeAndUseWithCobbleRod(GameTestHelper helper, int mana) {
        Player player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_MANA, POS_PLAYER_MANA, mana);
        player.addItem(new ItemStack((ItemLike)BotaniaItems.cobbleRod));
        ItemStack stack = this.getAstrolabeForBlockType(player, Blocks.COBBLESTONE);
        AstrolabeItem.setSize(stack, 11);
        this.useAstrolabe(player, stack, InteractionHand.MAIN_HAND);
        return player;
    }

    private void useAstrolabe(Player player, ItemStack stack, InteractionHand hand) {
        BlockHitResult hitResult = ToolCommons.raytraceFromEntity((Entity)player, 5.0, true);
        UseOnContext useOnContext = new UseOnContext(player, hand, hitResult);
        stack.useOn(useOnContext);
    }

    private void checkRemainingMana(Player player, int expectedMana) {
        ItemStack tablet = player.getInventory().getItem(1);
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(tablet);
        TestingUtil.assertThat(manaItem != null, () -> "Missing mana tablet");
        TestingUtil.assertEquals(expectedMana, manaItem.getMana(), () -> String.format("Expected %d remaining mana, but found %d", expectedMana, manaItem.getMana()));
    }

    @NotNull
    private Player mockPlayerWithAstrolabe(GameTestHelper helper, Vec3 posPlayer, Vec3 lookTarget, int mana) {
        Player player = helper.makeMockPlayer(GameType.CREATIVE);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)BotaniaItems.astrolabe));
        ItemStack tablet = new ItemStack((ItemLike)BotaniaItems.manaTablet);
        Objects.requireNonNull(XplatAbstractions.INSTANCE.findManaItem(tablet)).addMana(mana);
        player.getInventory().add(tablet);
        player.setPos(helper.absoluteVec(posPlayer));
        Vec3 targetVec = helper.absoluteVec(lookTarget);
        player.lookAt(EntityAnchorArgument.Anchor.EYES, targetVec);
        return player;
    }

    @NotNull
    private ItemStack getAstrolabeForBlockType(Player player, Block block) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        AstrolabeItem.setBlock(stack, block.defaultBlockState());
        return stack;
    }
}

