/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import vazkii.botania.common.block.block_entity.corporea.CorporeaRetainerBlockEntity;

public class InterceptorTest {
    private static final String TEMPLATE = "botania:block/interceptor";
    private static final BlockPos APPLE_BUTTON_JEANS = new BlockPos(6, 6, 4);
    private static final BlockPos BOOTS_WITH_THE_FUR = new BlockPos(4, 6, 4);
    private static final BlockPos WILDCARD_RETAINER = new BlockPos(6, 5, 7);
    private static final BlockPos BOOTS_RETAINER = new BlockPos(4, 5, 7);

    @GameTest(template="botania:block/interceptor")
    public void testAppleRequest(GameTestHelper helper) {
        helper.pressButton(APPLE_BUTTON_JEANS);
        helper.startSequence().thenExecuteAfter(1, () -> {
            InterceptorTest.assertHasPendingRequest(helper, WILDCARD_RETAINER);
            InterceptorTest.assertHasNoPendingRequest(helper, BOOTS_RETAINER);
        }).thenSucceed();
    }

    @GameTest(template="botania:block/interceptor")
    public void testBootsRequest(GameTestHelper helper) {
        helper.pressButton(BOOTS_WITH_THE_FUR);
        helper.startSequence().thenExecuteAfter(1, () -> {
            InterceptorTest.assertHasPendingRequest(helper, WILDCARD_RETAINER);
            InterceptorTest.assertHasPendingRequest(helper, BOOTS_RETAINER);
        }).thenSucceed();
    }

    private static void assertHasPendingRequest(GameTestHelper helper, BlockPos retainerPos) {
        InterceptorTest.assertHasPendingRequest(helper, retainerPos, false);
    }

    private static void assertHasPendingRequest(GameTestHelper helper, BlockPos retainerPos, boolean invert) {
        CorporeaRetainerBlockEntity retainer = (CorporeaRetainerBlockEntity)helper.getBlockEntity(retainerPos);
        if (retainer == null) {
            throw new GameTestAssertPosException("Expected corporea retainer", helper.absolutePos(retainerPos), retainerPos, helper.getTick());
        }
        if (!retainer.hasPendingRequest() ^ invert) {
            throw new GameTestAssertPosException("Expected corporea retainer to " + (invert ? "not " : "") + "have a pending request", helper.absolutePos(retainerPos), retainerPos, helper.getTick());
        }
    }

    private static void assertHasNoPendingRequest(GameTestHelper helper, BlockPos retainerPos) {
        InterceptorTest.assertHasPendingRequest(helper, retainerPos, true);
    }
}

