/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.test.TestingUtil;

public class HopperhockTest {
    private static final String TEMPLATE = "botania:block/hopperhock_furnace";
    private static final BlockPos FLOWER_POS = new BlockPos(2, 3, 2);
    private static final BlockPos SPAWN_ITEM_POS = new BlockPos(2, 3, 1);
    private static final float SPAWN_ITEM_X = SPAWN_ITEM_POS.getX();
    private static final float SPAWN_ITEM_Y = SPAWN_ITEM_POS.getY();
    private static final float SPAWN_ITEM_Z = SPAWN_ITEM_POS.getZ();

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceInsertTop(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.below();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        this.spawnItem(helper, Items.COBBLESTONE);
        helper.succeedWhen(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.COBBLESTONE, 1);
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceInsertSide(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.south();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        this.spawnItem(helper, Items.CHARCOAL);
        helper.succeedWhen(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 1, Items.CHARCOAL, 1);
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceInsertBottom(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.above();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        this.spawnItem(helper, Items.CHARCOAL);
        helper.succeedWhen(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 1, Items.CHARCOAL, 1);
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceInventoryFull(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.below();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        HopperhockTest.getFurnaceBlockEntity(helper, furnacePos).setItem(0, new ItemStack((ItemLike)Items.OAK_LOG, 64));
        this.spawnItem(helper, Items.OAK_LOG);
        helper.startSequence().thenExecuteAfter(61, () -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.OAK_LOG, 64);
            helper.assertItemEntityPresent(Items.OAK_LOG, SPAWN_ITEM_POS, 0.0);
        }).thenSucceed();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceAddToStack(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.below();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        HopperhockTest.getFurnaceBlockEntity(helper, furnacePos).setItem(0, new ItemStack((ItemLike)Items.OAK_LOG, 60));
        ItemEntity itemEntity = this.spawnItem(helper, Items.OAK_LOG);
        itemEntity.getItem().setCount(10);
        helper.succeedWhen(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.OAK_LOG, 64);
            helper.assertItemEntityCountIs(Items.OAK_LOG, SPAWN_ITEM_POS, 0.0, 6);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceWrongItemForSlot(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.above();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        this.spawnItem(helper, Items.BRICKS);
        helper.startSequence().thenExecuteAfter(61, () -> {
            helper.assertContainerEmpty(furnacePos);
            helper.assertItemEntityPresent(Items.BRICKS, SPAWN_ITEM_POS, 0.0);
        }).thenSucceed();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceFilterMatch(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.below();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        HopperhockTest.spawnItemFrame(helper, furnacePos.west(), Direction.WEST, Items.COBBLESTONE);
        this.spawnItem(helper, Items.COBBLESTONE);
        helper.succeedWhen(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.COBBLESTONE, 1);
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFurnaceFilterNoMatch(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.below();
        helper.setBlock(furnacePos, Blocks.FURNACE);
        HopperhockTest.spawnItemFrame(helper, furnacePos.west(), Direction.WEST, Items.OAK_LOG);
        this.spawnItem(helper, Items.COBBLESTONE);
        helper.startSequence().thenExecuteAfter(61, () -> {
            helper.assertContainerEmpty(furnacePos);
            helper.assertItemEntityPresent(Items.COBBLESTONE, SPAWN_ITEM_POS, 0.0);
        }).thenSucceed();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testComposterInsertTop(GameTestHelper helper) {
        BlockPos composterPos = FLOWER_POS.below();
        helper.setBlock(composterPos, Blocks.COMPOSTER);
        this.spawnItem(helper, Items.PUMPKIN_PIE);
        helper.succeedWhen(() -> {
            helper.assertBlockProperty(composterPos, (Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(1));
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testComposterInsertSide(GameTestHelper helper) {
        BlockPos composterPos = FLOWER_POS.south();
        this.spawnItemAndExpectNoPickUp(helper, composterPos, Items.PUMPKIN_PIE);
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testComposterInsertBottom(GameTestHelper helper) {
        BlockPos composterPos = FLOWER_POS.above();
        this.spawnItemAndExpectNoPickUp(helper, composterPos, Items.PUMPKIN_PIE);
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testComposterInsertWrongItem(GameTestHelper helper) {
        BlockPos composterPos = FLOWER_POS.below();
        this.spawnItemAndExpectNoPickUp(helper, composterPos, Items.OAK_LOG);
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testComposterFull(GameTestHelper helper) {
        BlockPos composterPos = FLOWER_POS.below();
        helper.setBlock(composterPos, (BlockState)Blocks.COMPOSTER.defaultBlockState().setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(7)));
        this.spawnItem(helper, Items.PUMPKIN_PIE);
        helper.startSequence().thenExecuteAfter(61, () -> {
            helper.assertBlockProperty(composterPos, (Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(8));
            helper.assertItemEntityPresent(Items.PUMPKIN_PIE, SPAWN_ITEM_POS, 0.0);
        }).thenSucceed();
    }

    private void spawnItemAndExpectNoPickUp(GameTestHelper helper, BlockPos composterPos, Item item) {
        helper.setBlock(composterPos, Blocks.COMPOSTER);
        this.spawnItem(helper, item);
        helper.startSequence().thenExecuteAfter(61, () -> {
            helper.assertBlockProperty(composterPos, (Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(0));
            helper.assertItemEntityPresent(item, SPAWN_ITEM_POS, 0.0);
        }).thenSucceed();
    }

    private static void spawnItemFrame(GameTestHelper helper, BlockPos pos, Direction direction, Item item) {
        ItemFrame itemFrame = new ItemFrame((Level)helper.getLevel(), helper.absolutePos(pos), direction);
        itemFrame.setItem(new ItemStack((ItemLike)item));
        helper.getLevel().addFreshEntity((Entity)itemFrame);
    }

    private ItemEntity spawnItem(GameTestHelper helper, Item item) {
        return helper.spawnItem(item, SPAWN_ITEM_X, SPAWN_ITEM_Y, SPAWN_ITEM_Z);
    }

    private static void assertItemInSlot(GameTestHelper helper, BlockPos furnacePos, int slot, Item expectedItem, int expectedCount) {
        ItemStack stack = HopperhockTest.getFurnaceBlockEntity(helper, furnacePos).getItem(slot);
        if (stack.getItem() != expectedItem) {
            TestingUtil.throwPositionedAssertion(helper, furnacePos, () -> "Expected " + String.valueOf(expectedItem) + " in slot " + slot + ", but got " + String.valueOf(stack.getItem()));
        } else if (stack.getCount() != expectedCount) {
            TestingUtil.throwPositionedAssertion(helper, furnacePos, () -> "Expected " + expectedCount + " items in slot " + slot + ", but got " + stack.getCount());
        }
    }

    private static AbstractFurnaceBlockEntity getFurnaceBlockEntity(GameTestHelper helper, BlockPos furnacePos) {
        BlockEntity blockEntity = helper.getBlockEntity(furnacePos);
        if (blockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
            return furnace;
        }
        throw new GameTestAssertPosException("Expected furnace here", helper.absolutePos(furnacePos), furnacePos, helper.getTick());
    }
}

