/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.serverbound;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;

public class DodgePacket
implements CustomPacketPayload {
    public static final DodgePacket INSTANCE = new DodgePacket();
    public static final CustomPacketPayload.Type<DodgePacket> ID = new CustomPacketPayload.Type(BotaniaAPI.botaniaRL("do"));
    public static final StreamCodec<ByteBuf, DodgePacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<DodgePacket> type() {
        return ID;
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.dash, SoundSource.PLAYERS, 1.0f, 1.0f);
            ItemStack ringStack = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (LivingEntity)player);
            if (ringStack.isEmpty()) {
                player.connection.disconnect((Component)Component.translatable((String)"botaniamisc.invalidDodge"));
                return;
            }
            player.causeFoodExhaustion(0.3f);
            player.getCooldowns().addCooldown(ringStack.getItem(), 20);
        });
    }
}

