/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;

public record UpdateItemsRemainingPacket(ItemStack stack, int count, @Nullable Component tooltip) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateItemsRemainingPacket> ID = new CustomPacketPayload.Type(BotaniaAPI.botaniaRL("rem"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateItemsRemainingPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, UpdateItemsRemainingPacket::stack, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateItemsRemainingPacket::count, (StreamCodec)ComponentSerialization.OPTIONAL_STREAM_CODEC.map(o -> o.orElse(null), Optional::ofNullable), UpdateItemsRemainingPacket::tooltip, UpdateItemsRemainingPacket::new);

    public CustomPacketPayload.Type<UpdateItemsRemainingPacket> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(UpdateItemsRemainingPacket packet) {
            ItemStack stack = packet.stack();
            int count = packet.count();
            Component tooltip = packet.tooltip();
            Minecraft.getInstance().execute(() -> ItemsRemainingRenderHandler.set(stack, count, tooltip));
        }
    }
}

