/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.GrassSeedsItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;

public record BotaniaEffectPacket(EffectType effectType, double x, double y, double z, int[] args) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BotaniaEffectPacket> ID = new CustomPacketPayload.Type(BotaniaAPI.botaniaRL("eff"));
    private static final int MAX_VARIABLE_ARGS = 128;
    public static final StreamCodec<ByteBuf, BotaniaEffectPacket> STREAM_CODEC = StreamCodec.composite(EffectType.STREAM_CODEC, BotaniaEffectPacket::effectType, (StreamCodec)ByteBufCodecs.DOUBLE, BotaniaEffectPacket::x, (StreamCodec)ByteBufCodecs.DOUBLE, BotaniaEffectPacket::y, (StreamCodec)ByteBufCodecs.DOUBLE, BotaniaEffectPacket::z, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()).map(Ints::toArray, is -> Ints.asList((int[])is)), BotaniaEffectPacket::args, (type, x, y, z, args) -> new BotaniaEffectPacket((EffectType)((Object)type), (double)x, (double)y, (double)z, (int)args));

    public CustomPacketPayload.Type<BotaniaEffectPacket> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(BotaniaEffectPacket packet) {
            final EffectType type = packet.effectType();
            final double x = packet.x();
            final double y = packet.y();
            final double z = packet.z();
            final int[] args = packet.args();
            final Minecraft mc = Minecraft.getInstance();
            mc.execute(new Runnable(){

                @Override
                public void run() {
                    ClientLevel world = mc.level;
                    switch (type) {
                        case PAINT_LENS: {
                            DyeColor placeColor = DyeColor.byId((int)args[0]);
                            int hex = ColorHelper.getColorValue(placeColor);
                            int r = (hex & 0xFF0000) >> 16;
                            int g = (hex & 0xFF00) >> 8;
                            int b = hex & 0xFF;
                            for (int i = 0; i < 10; ++i) {
                                BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z).relative(Direction.getRandom((RandomSource)world.random));
                                SparkleParticleData data = SparkleParticleData.sparkle(0.6f + (float)Math.random() * 0.5f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
                                world.addParticle((ParticleOptions)data, (double)((float)pos.getX() + (float)Math.random()), (double)((float)pos.getY() + (float)Math.random()), (double)((float)pos.getZ() + (float)Math.random()), 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case ARENA_INDICATOR: {
                            SparkleParticleData data = SparkleParticleData.sparkle(5.0f, 1.0f, 0.0f, 1.0f, 120);
                            for (int i = 0; i < 360; i += 8) {
                                float rad = (float)i * (float)Math.PI / 180.0f;
                                double wx = x + 0.5 - Math.cos(rad) * 12.0;
                                double wy = y + 0.5;
                                double wz = z + 0.5 - Math.sin(rad) * 12.0;
                                Proxy.INSTANCE.addParticleForceNear((Level)world, data, wx, wy, wz, 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case ITEM_SMOKE: {
                            Entity item = world.getEntity(args[0]);
                            if (item == null) {
                                return;
                            }
                            int p = args[1];
                            for (int i = 0; i < p; ++i) {
                                double m = 0.01;
                                double d0 = item.level().random.nextGaussian() * m;
                                double d1 = item.level().random.nextGaussian() * m;
                                double d2 = item.level().random.nextGaussian() * m;
                                double d3 = 10.0;
                                item.level().addParticle((ParticleOptions)ParticleTypes.POOF, x + (double)(item.level().random.nextFloat() * item.getBbWidth() * 2.0f) - (double)item.getBbWidth() - d0 * d3, y + (double)(item.level().random.nextFloat() * item.getBbHeight()) - d1 * d3, z + (double)(item.level().random.nextFloat() * item.getBbWidth() * 2.0f) - (double)item.getBbWidth() - d2 * d3, d0, d1, d2);
                            }
                            break;
                        }
                        case SPARK_NET_INDICATOR: {
                            Entity e1 = world.getEntity(args[0]);
                            Entity e2 = world.getEntity(args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            Vec3 orig = new Vec3(e1.getX(), e1.getY() + 0.25, e1.getZ());
                            Vec3 end = new Vec3(e2.getX(), e2.getY() + 0.25, e2.getZ());
                            Vec3 diff = end.subtract(orig);
                            Vec3 movement = diff.normalize().scale(0.1);
                            int iters = (int)(diff.length() / movement.length());
                            float huePer = 1.0f / (float)iters;
                            float hueSum = (float)Math.random();
                            Vec3 currentPos = orig;
                            for (int i = 0; i < iters; ++i) {
                                float hue = (float)i * huePer + hueSum;
                                int color = Mth.hsvToRgb((float)Mth.frac((float)hue), (float)1.0f, (float)1.0f);
                                float r = Math.min(1.0f, (float)(color >> 16 & 0xFF) / 255.0f + 0.4f);
                                float g = Math.min(1.0f, (float)(color >> 8 & 0xFF) / 255.0f + 0.4f);
                                float b = Math.min(1.0f, (float)(color & 0xFF) / 255.0f + 0.4f);
                                SparkleParticleData data = SparkleParticleData.noClip(1.0f, r, g, b, 12);
                                world.addAlwaysVisibleParticle((ParticleOptions)data, true, currentPos.x, currentPos.y, currentPos.z, 0.0, 0.0, 0.0);
                                currentPos = currentPos.add(movement);
                            }
                            break;
                        }
                        case SPARK_MANA_FLOW: {
                            Entity e1 = world.getEntity(args[0]);
                            Entity e2 = world.getEntity(args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            double rc = 0.45;
                            Vec3 thisVec = VecHelper.fromEntityCenter(e1).add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            Vec3 receiverVec = VecHelper.fromEntityCenter(e2).add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            Vec3 motion = receiverVec.subtract(thisVec).scale((double)0.04f);
                            int color = args[2];
                            float r = (float)(color >> 16 & 0xFF) / 255.0f;
                            float g = (float)(color >> 8 & 0xFF) / 255.0f;
                            float b = (float)(color & 0xFF) / 255.0f;
                            if ((double)world.random.nextFloat() < 0.25) {
                                r += 0.2f * (float)world.random.nextGaussian();
                                g += 0.2f * (float)world.random.nextGaussian();
                                b += 0.2f * (float)world.random.nextGaussian();
                            }
                            float size = 0.125f + 0.125f * (float)Math.random();
                            WispParticleData data = WispParticleData.wisp(size, r, g, b).withNoClip(true);
                            world.addAlwaysVisibleParticle((ParticleOptions)data, thisVec.x, thisVec.y, thisVec.z, motion.x, motion.y, motion.z);
                            break;
                        }
                        case ENCHANTER_DESTROY: {
                            for (int i = 0; i < 50; ++i) {
                                float red = (float)Math.random();
                                float green = (float)Math.random();
                                float blue = (float)Math.random();
                                WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                                world.addParticle((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * 0.25f), (double)((float)(Math.random() - 0.5) * 0.25f), (double)((float)(Math.random() - 0.5) * 0.25f));
                            }
                            break;
                        }
                        case BLACK_LOTUS_DISSOLVE: {
                            for (int i = 0; i < 50; ++i) {
                                float r = (float)Math.random() * 0.35f;
                                float g = 0.0f;
                                float b = (float)Math.random() * 0.35f;
                                float s = 0.45f * (float)Math.random() * 0.25f;
                                float m = 0.045f;
                                float mx = ((float)Math.random() - 0.5f) * m;
                                float my = (float)Math.random() * m;
                                float mz = ((float)Math.random() - 0.5f) * m;
                                WispParticleData data = WispParticleData.wisp(s, r, g, b);
                                world.addParticle((ParticleOptions)data, x, y, z, (double)mx, (double)my, (double)mz);
                            }
                            break;
                        }
                        case TERRA_PLATE: {
                            BlockEntity te = world.getBlockEntity(BlockPos.containing((double)x, (double)y, (double)z));
                            if (!(te instanceof TerrestrialAgglomerationPlateBlockEntity)) break;
                            float percentage = Float.intBitsToFloat(args[0]);
                            int ticks = (int)(100.0 * (double)percentage);
                            int totalSpiritCount = 3;
                            double tickIncrement = 360.0 / (double)totalSpiritCount;
                            int speed = 5;
                            double wticks = (double)(ticks * speed) - tickIncrement;
                            double r = Math.sin((double)(ticks - 100) / 10.0) * 2.0;
                            double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
                            for (int i = 0; i < totalSpiritCount; ++i) {
                                double wx = x + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                                double wy = y + 0.25 + Math.abs(r) * 0.7;
                                double wz = z + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                                wticks += tickIncrement;
                                float[] colorsfx = new float[]{0.0f, (float)ticks / 100.0f, 1.0f - (float)ticks / 100.0f};
                                WispParticleData data = WispParticleData.wisp(0.85f, colorsfx[0], colorsfx[1], colorsfx[2], 0.25f);
                                Proxy.INSTANCE.addParticleForceNear((Level)world, data, wx, wy, wz, 0.0, (float)(-g * 0.05), 0.0);
                                data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.1f, colorsfx[0], colorsfx[1], colorsfx[2], 0.9f);
                                world.addParticle((ParticleOptions)data, wx, wy, wz, (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f));
                                if (ticks != 100) continue;
                                for (int j = 0; j < 15; ++j) {
                                    data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, colorsfx[0], colorsfx[1], colorsfx[2]);
                                    world.addParticle((ParticleOptions)data, x + 0.5, y + 0.5, z + 0.5, (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f));
                                }
                            }
                            break;
                        }
                        case FLUGEL_EFFECT: {
                            Entity entity = world.getEntity(args[0]);
                            if (entity == null) break;
                            for (int i = 0; i < 15; ++i) {
                                float x1 = (float)(entity.getX() + Math.random());
                                float y1 = (float)(entity.getY() + Math.random());
                                float z1 = (float)(entity.getZ() + Math.random());
                                WispParticleData data = WispParticleData.wisp((float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                                world.addParticle((ParticleOptions)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(-(-0.3f + (float)Math.random() * 0.2f)), 0.0);
                            }
                            break;
                        }
                        case PARTICLE_BEAM: {
                            WandOfTheForestItem.doParticleBeam((Level)world, new Vec3(x, y, z), new Vec3((double)args[0] + 0.5, (double)args[1] + 0.5, (double)args[2] + 0.5));
                            break;
                        }
                        case DIVA_EFFECT: {
                            Entity target = world.getEntity(args[0]);
                            if (target == null) break;
                            double x1 = target.getX();
                            double y1 = target.getY();
                            double z1 = target.getZ();
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 1.0f, 1.0f, 0.25f, 3);
                            for (int i = 0; i < 50; ++i) {
                                world.addParticle((ParticleOptions)data, x1 + Math.random() * (double)target.getBbWidth(), y1 + Math.random() * (double)target.getBbHeight(), z1 + Math.random() * (double)target.getBbWidth(), 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case HALO_CRAFT: {
                            Entity target = world.getEntity(args[0]);
                            if (target == null) break;
                            Vec3 lookVec3 = target.getLookAngle();
                            Vec3 centerVector = VecHelper.fromEntityCenter(target).add(lookVec3.x * 3.0, 1.3, lookVec3.z * 3.0);
                            float m = 0.1f;
                            for (int i = 0; i < 4; ++i) {
                                WispParticleData data = WispParticleData.wisp(0.2f + 0.2f * (float)Math.random(), 1.0f, 0.0f, 1.0f);
                                target.level().addParticle((ParticleOptions)data, centerVector.x, centerVector.y, centerVector.z, (double)(((float)Math.random() - 0.5f) * m), (double)(((float)Math.random() - 0.5f) * m), (double)(((float)Math.random() - 0.5f) * m));
                            }
                            break;
                        }
                        case AVATAR_TORNADO_JUMP: {
                            Entity p = world.getEntity(args[0]);
                            if (p == null) break;
                            for (int i = 0; i < 20; ++i) {
                                for (int j = 0; j < 5; ++j) {
                                    WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                                    world.addParticle((ParticleOptions)data, p.getX(), p.getY() + (double)i, p.getZ(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                                }
                            }
                            break;
                        }
                        case AVATAR_TORNADO_BOOST: {
                            Entity p = world.getEntity(args[0]);
                            if (p == null) break;
                            Vec3 lookDir = p.getLookAngle();
                            for (int i = 0; i < 20; ++i) {
                                for (int j = 0; j < 5; ++j) {
                                    WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                                    world.addParticle((ParticleOptions)data, p.getX() + lookDir.x() * (double)i, p.getY() + lookDir.y() * (double)i, p.getZ() + lookDir.z() * (double)i, (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.y()) + Math.abs(lookDir.z())) + (double)(-0.01f * (float)Math.random()) * lookDir.x(), (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.x()) + Math.abs(lookDir.z())) + (double)(-0.01f * (float)Math.random()) * lookDir.y(), (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.y()) + Math.abs(lookDir.x())) + (double)(-0.01f * (float)Math.random()) * lookDir.z());
                                }
                            }
                            break;
                        }
                        case THUNDERCALLER_EFFECT: {
                            int id;
                            Entity entity;
                            Vec3 source = new Vec3(x, y, z);
                            int[] nArray = args;
                            int n = nArray.length;
                            for (int i = 0; i < n && (entity = world.getEntity(id = nArray[i])) != null; ++i) {
                                Vec3 entityPos = VecHelper.fromEntityCenter(entity);
                                Proxy.INSTANCE.lightningFX((Level)world, source, entityPos, 1.0f, 96708, 0xAADFFF);
                                source = entityPos;
                            }
                            break;
                        }
                        case GRASS_SEED_PARTICLES: {
                            int color = args[0];
                            GrassSeedsItem.spawnParticles((Level)world, BlockPos.containing((double)x, (double)y, (double)z), GrassSeedsItem.extractR(color), GrassSeedsItem.extractG(color), GrassSeedsItem.extractB(color));
                        }
                    }
                }
            });
        }
    }
}

