/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.client.core.SkyblockWorldInfo;
import vazkii.botania.client.render.world.SkyblockSkyRenderer;
import vazkii.botania.client.render.world.WorldOverlays;
import vazkii.botania.xplat.BotaniaConfig;

@Mixin(value={LevelRenderer.class}, priority=900)
public class LevelRendererMixin {
    @Shadow
    @Nullable
    private VertexBuffer starBuffer;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Nullable
    private ClientLevel level;
    @Unique
    private static final Matrix4f SUN_SCALE = new Matrix4f().scale(2.0f, 1.0f, 2.0f);
    @Unique
    private static final Matrix4f MOON_SCALE = new Matrix4f().scale(1.5f, 1.0f, 1.5f);

    @Unique
    private static boolean isGogSky() {
        SkyblockWorldInfo skyblockInfo;
        ClientLevel world = Minecraft.getInstance().level;
        LevelData levelData = world.getLevelData();
        boolean isGog = levelData instanceof SkyblockWorldInfo && (skyblockInfo = (SkyblockWorldInfo)levelData).isGardenOfGlass();
        return BotaniaConfig.client().enableFancySkybox() && world.dimension() == Level.OVERWORLD && (BotaniaConfig.client().enableFancySkyboxInNormalWorlds() || isGog);
    }

    @Inject(method={"renderSky"}, slice={@Slice(from=@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getRainLevel(F)F"))}, at={@At(shift=At.Shift.AFTER, ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V")}, require=0)
    private void renderExtras(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (LevelRendererMixin.isGogSky()) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            SkyblockSkyRenderer.renderExtra(poseStack, Minecraft.getInstance().level, partialTick, 0.0f);
        }
    }

    @ModifyVariable(method={"renderSky"}, slice=@Slice(from=@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F"), to=@At(ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")), at=@At(value="CONSTANT", args={"floatValue=30.0"}), ordinal=1, require=0)
    private Matrix4f makeSunBigger(Matrix4f matrix) {
        if (LevelRendererMixin.isGogSky()) {
            matrix = new Matrix4f((Matrix4fc)matrix);
            matrix.mul((Matrix4fc)SUN_SCALE);
        }
        return matrix;
    }

    @ModifyVariable(method={"renderSky"}, slice=@Slice(from=@At(ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V"), to=@At(ordinal=1, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")), at=@At(value="CONSTANT", args={"floatValue=20.0"}), ordinal=1, require=0)
    private Matrix4f makeMoonBigger(Matrix4f matrix) {
        if (LevelRendererMixin.isGogSky()) {
            matrix.mul((Matrix4fc)MOON_SCALE);
        }
        return matrix;
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getStarBrightness(F)F")}, require=0)
    private void renderExtraStars(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (LevelRendererMixin.isGogSky()) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            SkyblockSkyRenderer.renderStars(this.starBuffer, poseStack, projectionMatrix, partialTick, skyFogSetup);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;applyModelViewMatrix()V", ordinal=0)})
    private void renderOverlays(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        PoseStack poseStack = new PoseStack();
        WorldOverlays.renderWorldLast(camera, deltaTracker.getGameTimeDeltaPartialTick(false), poseStack, this.renderBuffers, (Level)this.level);
    }
}

