/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.xplat.XplatAbstractions;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @WrapOperation(method={"checkRidingStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getVehicle()Lnet/minecraft/world/entity/Entity;")})
    private Entity trackLuminizerTravel(ServerPlayer player, Operation<Entity> original, @Local int cm) {
        Entity entity = (Entity)original.call(new Object[]{player});
        if (entity instanceof LuminizerBlockEntity.PlayerMoverEntity) {
            player.awardStat(BotaniaStats.LUMINIZER_ONE_CM, cm);
        }
        return entity;
    }

    @Inject(at={@At(value="RETURN")}, method={"initMenu"})
    private void onLogin(CallbackInfo ci) {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            SkyblockWorldEvents.onPlayerJoin((ServerPlayer)this);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void onTick(CallbackInfo ci) {
        if (EquipmentHandler.instance instanceof EquipmentHandler.InventoryEquipmentHandler) {
            ((EquipmentHandler.InventoryEquipmentHandler)EquipmentHandler.instance).onPlayerTick((Player)this);
        }
    }
}

