/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.common.block.flower.generating.NarslimmusBlockEntity;
import vazkii.botania.common.brew.effect.BloodthirstMobEffect;
import vazkii.botania.common.brew.effect.EmptinessMobEffect;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V"), method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"})
    private static Entity onSpawned(Entity entity) {
        NarslimmusBlockEntity.onSpawn(entity);
        return entity;
    }

    @Inject(at={@At(value="HEAD")}, method={"isValidPositionForMob"}, cancellable=true)
    private static void emptiness(ServerLevel world, Mob entity, double squaredDistance, CallbackInfoReturnable<Boolean> cir) {
        if (EmptinessMobEffect.shouldCancel((LivingEntity)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"isValidPositionForMob"})
    private static void bloodthirstOverride(ServerLevel world, Mob entity, double distance, CallbackInfoReturnable<Boolean> cir) {
        if (BloodthirstMobEffect.overrideSpawn((ServerLevelAccessor)world, entity.blockPosition(), entity.getType().getCategory())) {
            cir.setReturnValue((Object)true);
        }
    }
}

