/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes.builder;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.lang3.tuple.Triple;
import vazkii.botania.common.crafting.recipe.WrappingRecipeSerializer;
import vazkii.botania.data.recipes.builder.CapturingRecipeOutput;

public class WrapperRecipeBuilder<T extends Recipe<?>> {
    private final WrappingRecipeSerializer<T> serializer;
    private final RecipeBuilder recipeBuilder;

    public WrapperRecipeBuilder(WrappingRecipeSerializer<T> serializer, RecipeBuilder recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        this.serializer = serializer;
    }

    public static <T extends Recipe<?>> WrapperRecipeBuilder<T> wrap(WrappingRecipeSerializer<T> serializer, RecipeBuilder recipeBuilder) {
        return new WrapperRecipeBuilder<T>(serializer, recipeBuilder);
    }

    public void save(RecipeOutput recipeOutput) {
        CapturingRecipeOutput capturingRecipeOutput = new CapturingRecipeOutput(recipeOutput);
        Triple<ResourceLocation, Recipe<?>, AdvancementHolder> output = capturingRecipeOutput.captureSave(arg_0 -> ((RecipeBuilder)this.recipeBuilder).save(arg_0));
        T wrappedRecipe = this.serializer.wrap((Recipe)output.getMiddle());
        recipeOutput.accept((ResourceLocation)output.getLeft(), wrappedRecipe, (AdvancementHolder)output.getRight());
    }
}

