/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes.builder;

import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.lang3.tuple.Triple;
import vazkii.botania.common.crafting.recipe.NbtOutputRecipe;
import vazkii.botania.data.recipes.builder.CapturingRecipeOutput;

public class NbtOutputRecipeBuilder {
    private final RecipeBuilder recipeBuilder;
    private final Consumer<CompoundTag> nbtDefinition;

    public NbtOutputRecipeBuilder(RecipeBuilder recipeBuilder, Consumer<CompoundTag> nbtDefinition) {
        this.recipeBuilder = recipeBuilder;
        this.nbtDefinition = nbtDefinition;
    }

    public static NbtOutputRecipeBuilder setNbt(RecipeBuilder recipeBuilder, Consumer<CompoundTag> nbtDefinition) {
        return new NbtOutputRecipeBuilder(recipeBuilder, nbtDefinition);
    }

    public void save(RecipeOutput recipeOutput, String recipeId) {
        CapturingRecipeOutput capturingRecipeOutput = new CapturingRecipeOutput(recipeOutput);
        Triple<ResourceLocation, Recipe<?>, AdvancementHolder> output = capturingRecipeOutput.captureSave(ro -> this.recipeBuilder.save(ro, recipeId));
        CompoundTag tag = new CompoundTag();
        this.nbtDefinition.accept(tag);
        NbtOutputRecipe wrappedRecipe = new NbtOutputRecipe((Recipe)output.getMiddle());
        recipeOutput.accept((ResourceLocation)output.getLeft(), wrappedRecipe, (AdvancementHolder)output.getRight());
    }
}

