/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes.builder;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.lang3.tuple.Triple;
import vazkii.botania.common.crafting.recipe.GogAlternationRecipe;
import vazkii.botania.data.recipes.builder.CapturingRecipeOutput;

public class GogAlternationRecipeBuilder {
    private final RecipeBuilder baseRecipeBuilder;
    private final RecipeBuilder gogRecipeBuilder;

    public GogAlternationRecipeBuilder(RecipeBuilder baseRecipeBuilder, RecipeBuilder gogRecipeBuilder) {
        if (baseRecipeBuilder.getResult() != gogRecipeBuilder.getResult()) {
            throw new IllegalArgumentException("Both recipes must have the same result item, found: %s/%s".formatted(baseRecipeBuilder.getResult(), gogRecipeBuilder.getResult()));
        }
        this.baseRecipeBuilder = baseRecipeBuilder;
        this.gogRecipeBuilder = gogRecipeBuilder;
    }

    public static GogAlternationRecipeBuilder alternatives(RecipeBuilder baseRecipeBuilder, RecipeBuilder gogRecipeBuilder) {
        return new GogAlternationRecipeBuilder(baseRecipeBuilder, gogRecipeBuilder);
    }

    public static void saveAlternatives(RecipeOutput recipeOutput, Consumer<RecipeOutput> baseRecipeOutputConsumer, Consumer<RecipeOutput> gogRecipeOutputConsumer) {
        CapturingRecipeOutput capturingRecipeOutput = new CapturingRecipeOutput(recipeOutput);
        Triple<ResourceLocation, Recipe<?>, AdvancementHolder> baseOutput = capturingRecipeOutput.captureSave(baseRecipeOutputConsumer);
        Triple<ResourceLocation, Recipe<?>, AdvancementHolder> gogOutput = capturingRecipeOutput.captureSave(gogRecipeOutputConsumer);
        if (!Objects.equals(baseOutput.getLeft(), gogOutput.getLeft())) {
            throw new IllegalArgumentException("Both recipes mut have matching IDs, got: %s/%s".formatted(baseOutput.getLeft(), gogOutput.getLeft()));
        }
        if (!Objects.equals(baseOutput.getRight(), gogOutput.getRight())) {
            // empty if block
        }
        GogAlternationRecipe alternationRecipe = new GogAlternationRecipe((Recipe)baseOutput.getMiddle(), (Recipe)gogOutput.getMiddle());
        recipeOutput.accept((ResourceLocation)baseOutput.getLeft(), alternationRecipe, (AdvancementHolder)baseOutput.getRight());
    }

    public void save(RecipeOutput recipeOutput, String recipeId) {
        this.save(recipeOutput, (RecipeBuilder builder, RecipeOutput output) -> builder.save(output, recipeId));
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation recipeId) {
        this.save(recipeOutput, (RecipeBuilder builder, RecipeOutput output) -> builder.save(output, recipeId));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, RecipeBuilder::save);
    }

    private void save(RecipeOutput recipeOutput, BiConsumer<RecipeBuilder, RecipeOutput> partialSaveAction) {
        GogAlternationRecipeBuilder.saveAlternatives(recipeOutput, output -> partialSaveAction.accept(this.baseRecipeBuilder, (RecipeOutput)output), output -> partialSaveAction.accept(this.gogRecipeBuilder, (RecipeOutput)output));
    }
}

