/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes.builder;

import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class BotaniaSpecialRecipeBuilder {
    private final Function<CraftingBookCategory, Recipe<?>> factory;
    private final CraftingBookCategory category;

    public BotaniaSpecialRecipeBuilder(Function<CraftingBookCategory, Recipe<?>> factory, CraftingBookCategory category) {
        this.factory = factory;
        this.category = category;
    }

    public static BotaniaSpecialRecipeBuilder special(Function<CraftingBookCategory, Recipe<?>> factory, CraftingBookCategory category) {
        return new BotaniaSpecialRecipeBuilder(factory, category);
    }

    public void save(RecipeOutput recipeOutput) {
        Recipe<?> recipe = this.factory.apply(this.category);
        RecipeSerializer serializer = recipe.getSerializer();
        ResourceLocation serializerKey = BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)serializer);
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)serializerKey.getNamespace(), (String)("dynamic/" + serializerKey.getPath()));
        recipeOutput.accept(recipeId, recipe, null);
    }
}

