/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class StonecuttingProvider
extends BotaniaRecipeProvider {
    public StonecuttingProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Override
    public void buildRecipes(RecipeOutput consumer) {
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            this.registerForMetamorphic(variant, consumer);
        }
        for (String color : LibBlockNames.PAVEMENT_VARIANTS) {
            this.registerForPavement(color, consumer);
        }
        for (String variant : LibBlockNames.QUARTZ_VARIANTS) {
            this.registerForQuartz(variant, consumer);
        }
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolished);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolishedSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolishedStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockPolishedWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrick);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockBrickChiseled);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockSlate);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrick);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockBrickChiseled);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickChiseled);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaBlocks.livingrockBrickMossySlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaBlocks.livingrockBrickMossyStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.livingrockBrickMossy, (ItemLike)BotaniaBlocks.livingrockBrickMossyWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaBlocks.shimmerrockSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaBlocks.shimmerrockStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrick);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaBrickWall);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickSlab, 2);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickStairs);
        this.stonecutting(consumer, (ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickWall);
        List allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(BotaniaAPI::botaniaRL).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).collect(Collectors.toList());
        this.anyToAnyStonecutting(consumer, allAzulejos);
    }

    private void registerForQuartz(String variant, RecipeOutput consumer) {
        Block base = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(variant));
        Block slab = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(variant + "_slab"));
        Block stairs = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(variant + "_stairs"));
        Block chiseled = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("chiseled_" + variant));
        Block pillar = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(variant + "_pillar"));
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)slab, 2);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)stairs);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)chiseled);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)pillar);
    }

    private void registerForPavement(String color, RecipeOutput consumer) {
        Block base = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(color + "_pavement"));
        Block slab = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(color + "_pavement_slab"));
        Block stair = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL(color + "_pavement_stairs"));
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)slab, 2);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)stair);
    }

    private void registerForMetamorphic(String variant, RecipeOutput consumer) {
        Block base = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_stone"));
        Block slab = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_stone_slab"));
        Block stair = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_stone_stairs"));
        Block wall = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_stone_wall"));
        Block brick = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_bricks"));
        Block brickSlab = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_bricks_slab"));
        Block brickStair = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_bricks_stairs"));
        Block brickWall = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_bricks_wall"));
        Block chiseledBrick = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("chiseled_metamorphic_" + variant + "_bricks"));
        Block cobble = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_cobblestone"));
        Block cobbleSlab = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_cobblestone_slab"));
        Block cobbleStair = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_cobblestone_stairs"));
        Block cobbleWall = (Block)BuiltInRegistries.BLOCK.get(BotaniaAPI.botaniaRL("metamorphic_" + variant + "_cobblestone_wall"));
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)slab, 2);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)stair);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)wall);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)brick);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)brickSlab, 2);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)brickStair);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)brickWall);
        this.stonecutting(consumer, (ItemLike)base, (ItemLike)chiseledBrick);
        this.stonecutting(consumer, (ItemLike)brick, (ItemLike)brickSlab, 2);
        this.stonecutting(consumer, (ItemLike)brick, (ItemLike)brickStair);
        this.stonecutting(consumer, (ItemLike)brick, (ItemLike)brickWall);
        this.stonecutting(consumer, (ItemLike)brick, (ItemLike)chiseledBrick);
        this.stonecutting(consumer, (ItemLike)cobble, (ItemLike)cobbleSlab, 2);
        this.stonecutting(consumer, (ItemLike)cobble, (ItemLike)cobbleStair);
        this.stonecutting(consumer, (ItemLike)cobble, (ItemLike)cobbleWall);
    }

    @NotNull
    public String getName() {
        return "Botania stonecutting recipes";
    }

    protected ResourceLocation idFor(ItemLike a, ItemLike b) {
        ResourceLocation aId = BuiltInRegistries.ITEM.getKey((Object)a.asItem());
        ResourceLocation bId = BuiltInRegistries.ITEM.getKey((Object)b.asItem());
        return BotaniaAPI.botaniaRL("stonecutting/" + aId.getPath() + "_to_" + bId.getPath());
    }

    protected void stonecutting(RecipeOutput consumer, ResourceLocation id, Ingredient input, ItemLike output) {
        this.stonecutting(consumer, id, input, output, 1);
    }

    protected void stonecutting(RecipeOutput consumer, ResourceLocation id, Ingredient input, ItemLike output, int count) {
        ItemStack outputStack = new ItemStack(output);
        outputStack.setCount(count);
        consumer.accept(id, (Recipe)new StonecutterRecipe("", input, outputStack), null);
    }

    protected void stonecutting(RecipeOutput consumer, ItemLike input, ItemLike output) {
        this.stonecutting(consumer, input, output, 1);
    }

    protected void stonecutting(RecipeOutput consumer, ItemLike input, ItemLike output, int count) {
        ItemStack outputStack = new ItemStack(output);
        outputStack.setCount(count);
        consumer.accept(this.idFor(input, output), (Recipe)new StonecutterRecipe("", Ingredient.of((ItemLike[])new ItemLike[]{input}), outputStack), null);
    }

    protected void anyToAnyStonecutting(RecipeOutput consumer, List<? extends ItemLike> inputs) {
        for (ItemLike itemLike : inputs) {
            Ingredient input = Ingredient.of((ItemLike[])((ItemLike[])inputs.stream().filter(thisInput -> output != thisInput).toArray(ItemLike[]::new)));
            ResourceLocation id = BotaniaAPI.botaniaRL("stonecutting/" + BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath());
            this.stonecutting(consumer, id, input, itemLike);
        }
    }
}

