/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.RunicAltarRecipe;
import vazkii.botania.common.crafting.recipe.HeadRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class RunicAltarProvider
extends BotaniaRecipeProvider {
    protected static Ingredient DEFAULT_REAGENT = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.livingrock});

    public RunicAltarProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    public String getName() {
        return "Botania runic altar recipes";
    }

    @Override
    public void buildRecipes(RecipeOutput consumer) {
        int costTier1 = 5200;
        int costTier2 = 8000;
        int costTier3 = 12000;
        Ingredient manaSteel = Ingredient.of(BotaniaTags.Items.INGOTS_MANASTEEL);
        Ingredient manaDiamond = Ingredient.of(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaPowder = Ingredient.of(BotaniaTags.Items.DUSTS_MANA);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("water"), new ItemStack((ItemLike)BotaniaItems.runeWater, 2), 5200, manaPowder, manaSteel, Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_MEAL}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SUGAR_CANE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FISHING_ROD}));
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("fire"), new ItemStack((ItemLike)BotaniaItems.runeFire, 2), 5200, manaPowder, manaSteel, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_BRICK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}));
        Ingredient stone = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE});
        Ingredient coalBlock = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.COAL_BLOCK});
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("earth"), new ItemStack((ItemLike)BotaniaItems.runeEarth, 2), 5200, manaPowder, manaSteel, stone, coalBlock, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM}));
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("air"), new ItemStack((ItemLike)BotaniaItems.runeAir, 2), 5200, manaPowder, manaSteel, Ingredient.of((TagKey)ItemTags.WOOL_CARPETS), Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}));
        Ingredient fire = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeFire});
        Ingredient water = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWater});
        Ingredient earth = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeEarth});
        Ingredient air = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAir});
        Ingredient sapling = Ingredient.of((TagKey)ItemTags.SAPLINGS);
        Ingredient leaves = Ingredient.of((TagKey)ItemTags.LEAVES);
        Ingredient sand = Ingredient.of((TagKey)ItemTags.SAND);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("spring"), new ItemStack((ItemLike)BotaniaItems.runeSpring), 8000, water, fire, sapling, sapling, sapling, Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}));
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("summer"), new ItemStack((ItemLike)BotaniaItems.runeSummer), 8000, earth, air, sand, sand, Ingredient.of((ItemLike[])new ItemLike[]{Items.SLIME_BALL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}));
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("autumn"), new ItemStack((ItemLike)BotaniaItems.runeAutumn), 8000, fire, air, leaves, leaves, leaves, Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}));
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("winter"), new ItemStack((ItemLike)BotaniaItems.runeWinter), 8000, water, earth, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SNOW_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SNOW_BLOCK}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CAKE}));
        Ingredient spring = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSpring});
        Ingredient summer = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSummer});
        Ingredient autumn = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAutumn});
        Ingredient winter = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWinter});
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("mana"), new ItemStack((ItemLike)BotaniaItems.runeMana), 8000, manaSteel, manaSteel, manaSteel, manaSteel, manaSteel, Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl}));
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("lust"), new ItemStack((ItemLike)BotaniaItems.runeLust), 12000, manaDiamond, manaDiamond, summer, air);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("gluttony"), new ItemStack((ItemLike)BotaniaItems.runeGluttony), 12000, manaDiamond, manaDiamond, winter, fire);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("greed"), new ItemStack((ItemLike)BotaniaItems.runeGreed), 12000, manaDiamond, manaDiamond, spring, water);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("sloth"), new ItemStack((ItemLike)BotaniaItems.runeSloth), 12000, manaDiamond, manaDiamond, autumn, air);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("wrath"), new ItemStack((ItemLike)BotaniaItems.runeWrath), 12000, manaDiamond, manaDiamond, winter, earth);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("envy"), new ItemStack((ItemLike)BotaniaItems.runeEnvy), 12000, manaDiamond, manaDiamond, winter, water);
        RunicAltarProvider.defaultReagent(consumer, RunicAltarProvider.idFor("pride"), new ItemStack((ItemLike)BotaniaItems.runePride), 12000, manaDiamond, manaDiamond, summer, fire);
        consumer.accept(RunicAltarProvider.idFor("head"), (Recipe)new HeadRecipe(new ItemStack((ItemLike)Items.PLAYER_HEAD), DEFAULT_REAGENT, 22500, Ingredient.of((ItemLike[])new ItemLike[]{Items.SKELETON_SKULL}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.pixieDust}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_CRYSTALS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NAME_TAG}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})), null);
    }

    private static ResourceLocation idFor(String s) {
        return BotaniaAPI.botaniaRL("runic_altar/" + s);
    }

    protected static void defaultReagent(RecipeOutput consumer, ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        consumer.accept(id, (Recipe)new RunicAltarRecipe(output, DEFAULT_REAGENT, mana, inputs, new Ingredient[0]), null);
    }
}

