/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.mojang.authlib.properties.PropertyMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.PetalApothecaryRecipe;
import vazkii.botania.common.crafting.recipe.GogAlternationRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class PetalApothecaryProvider
extends BotaniaRecipeProvider {
    private static final Ingredient DEFAULT_REAGENT = Ingredient.of(BotaniaTags.Items.SEED_APOTHECARY_REAGENT);

    public PetalApothecaryProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    public String getName() {
        return "Botania petal apothecary recipes";
    }

    @Override
    public void buildRecipes(RecipeOutput consumer) {
        Ingredient white = PetalApothecaryProvider.tagIngr("petals/white");
        Ingredient orange = PetalApothecaryProvider.tagIngr("petals/orange");
        Ingredient magenta = PetalApothecaryProvider.tagIngr("petals/magenta");
        Ingredient lightBlue = PetalApothecaryProvider.tagIngr("petals/light_blue");
        Ingredient yellow = PetalApothecaryProvider.tagIngr("petals/yellow");
        Ingredient lime = PetalApothecaryProvider.tagIngr("petals/lime");
        Ingredient pink = PetalApothecaryProvider.tagIngr("petals/pink");
        Ingredient gray = PetalApothecaryProvider.tagIngr("petals/gray");
        Ingredient lightGray = PetalApothecaryProvider.tagIngr("petals/light_gray");
        Ingredient cyan = PetalApothecaryProvider.tagIngr("petals/cyan");
        Ingredient purple = PetalApothecaryProvider.tagIngr("petals/purple");
        Ingredient blue = PetalApothecaryProvider.tagIngr("petals/blue");
        Ingredient brown = PetalApothecaryProvider.tagIngr("petals/brown");
        Ingredient green = PetalApothecaryProvider.tagIngr("petals/green");
        Ingredient red = PetalApothecaryProvider.tagIngr("petals/red");
        Ingredient black = PetalApothecaryProvider.tagIngr("petals/black");
        Ingredient runeWater = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWater});
        Ingredient runeFire = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeFire});
        Ingredient runeEarth = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeEarth});
        Ingredient runeAir = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAir});
        Ingredient runeSpring = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSpring});
        Ingredient runeSummer = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSummer});
        Ingredient runeAutumn = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAutumn});
        Ingredient runeWinter = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWinter});
        Ingredient runeMana = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeMana});
        Ingredient runeLust = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeLust});
        Ingredient runeGluttony = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeGluttony});
        Ingredient runeGreed = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeGreed});
        Ingredient runeSloth = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSloth});
        Ingredient runeWrath = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWrath});
        Ingredient runeEnvy = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeEnvy});
        Ingredient runePride = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runePride});
        Ingredient redstoneRoot = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.redstoneRoot});
        Ingredient pixieDust = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.pixieDust});
        Ingredient gaiaSpirit = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.lifeEssence});
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.pureDaisy, white, white, white, white);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.manastar, lightBlue, green, red, cyan);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.endoflame, brown, brown, red, lightGray);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.hydroangeas, blue, blue, cyan, cyan);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.thermalily, red, orange, orange, runeEarth, runeFire);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.rosaArcana, pink, pink, purple, purple, lime, runeMana);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.munchdew, lime, lime, red, red, green, runeGluttony);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.entropinnyum, red, red, gray, gray, white, white, runeWrath, runeFire);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.kekimurus, white, white, orange, orange, brown, brown, runeGluttony, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.gourmaryllis, lightGray, lightGray, yellow, yellow, red, runeFire, runeSummer);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.narslimmus, lime, lime, green, green, black, runeSummer, runeWater);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.spectrolus, red, red, green, green, blue, blue, white, white, runeWinter, runeAir, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.rafflowsia, purple, purple, green, green, black, runeEarth, runePride, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.shulkMeNot, purple, purple, magenta, magenta, lightGray, gaiaSpirit, runeEnvy, runeWrath);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.dandelifeon, purple, purple, lime, green, runeWater, runeFire, runeEarth, runeAir, redstoneRoot, gaiaSpirit);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.jadedAmaranthus, purple, lime, green, runeSpring, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.bellethorn, red, red, red, cyan, cyan, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.dreadthorn, black, black, black, cyan, cyan, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.heiseiDream, magenta, magenta, purple, pink, runeWrath, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.tigerseye, yellow, brown, orange, lime, runeAutumn);
        PetalApothecaryRecipe base = new PetalApothecaryRecipe(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechid), DEFAULT_REAGENT, gray, gray, yellow, green, red, runePride, runeGreed, redstoneRoot, pixieDust);
        PetalApothecaryRecipe gog = new PetalApothecaryRecipe(new ItemStack((ItemLike)BotaniaFlowerBlocks.orechid), DEFAULT_REAGENT, gray, gray, yellow, yellow, green, green, red, red);
        consumer.accept(PetalApothecaryProvider.idFor(BotaniaAPI.botaniaRL("orechid")), new GogAlternationRecipe(base, gog), null);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.orechidIgnem, red, red, white, white, pink, runePride, runeGreed, redstoneRoot, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.fallenKanade, white, white, yellow, yellow, orange, runeSpring);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.exoflame, red, red, gray, lightGray, runeFire, runeSummer);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.agricarnation, lime, lime, green, yellow, runeSpring, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.hopperhock, gray, gray, lightGray, lightGray, runeAir, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.tangleberrie, cyan, cyan, gray, lightGray, runeAir, runeEarth);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.jiyuulia, pink, pink, purple, lightGray, runeWater, runeAir);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.rannuncarpus, orange, orange, yellow, runeEarth, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.hyacidus, purple, purple, magenta, magenta, green, runeWater, runeAutumn, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.pollidisiac, red, red, pink, pink, orange, runeLust, runeFire);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.clayconia, lightGray, lightGray, gray, cyan, runeEarth);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.loonium, green, green, green, green, gray, runeSloth, runeGluttony, runeEnvy, redstoneRoot, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.daffomill, white, white, brown, yellow, runeAir, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.vinculotus, black, black, purple, purple, green, runeWater, runeSloth, runeLust, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.spectranthemum, white, white, lightGray, lightGray, cyan, runeEnvy, runeWater, redstoneRoot, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.medumone, brown, brown, gray, gray, runeEarth, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.marimorphosis, gray, yellow, green, red, runeEarth, runeFire, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.bubbell, cyan, cyan, lightBlue, lightBlue, blue, blue, runeWater, runeSummer, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.solegnolia, brown, brown, red, blue, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.bergamute, orange, green, green, redstoneRoot);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaFlowerBlocks.labellia, yellow, yellow, blue, white, black, runeAutumn, redstoneRoot, pixieDust);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaBlocks.motifDaybloom, yellow, yellow, orange, lightBlue);
        PetalApothecaryProvider.make(consumer, (ItemLike)BotaniaBlocks.motifNightshade, black, black, purple, gray);
        ItemStack vazkiiHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        vazkiiHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of("Vazkii"), Optional.empty(), new PropertyMap()));
        Object[] inputs = new Ingredient[16];
        Arrays.fill(inputs, pink);
        consumer.accept(PetalApothecaryProvider.idFor(BotaniaAPI.botaniaRL("vazkii_head")), (Recipe)new PetalApothecaryRecipe(vazkiiHead, DEFAULT_REAGENT, (Ingredient[])inputs), null);
    }

    protected static Ingredient tagIngr(String tag) {
        return Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BotaniaAPI.botaniaRL(tag)));
    }

    protected static void make(RecipeOutput consumer, ItemLike output, Ingredient ... ingredients) {
        consumer.accept(PetalApothecaryProvider.idFor(BuiltInRegistries.ITEM.getKey((Object)output.asItem())), (Recipe)new PetalApothecaryRecipe(new ItemStack(output), DEFAULT_REAGENT, ingredients), null);
    }

    protected static ResourceLocation idFor(ResourceLocation name) {
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("petal_apothecary/" + name.getPath()));
    }
}

