/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.MarimorphosisRecipe;
import vazkii.botania.common.crafting.OrechidIgnemRecipe;
import vazkii.botania.common.crafting.OrechidRecipe;
import vazkii.botania.common.crafting.StateIngredients;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class OrechidProvider
extends BotaniaRecipeProvider {
    public OrechidProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Override
    public void buildRecipes(RecipeOutput consumer) {
        this.stone(consumer, Blocks.COAL_ORE, 67415);
        this.stone(consumer, Blocks.IRON_ORE, 29371);
        this.stone(consumer, Blocks.REDSTONE_ORE, 7654);
        this.stone(consumer, Blocks.COPPER_ORE, 7000);
        this.stone(consumer, Blocks.GOLD_ORE, 2647);
        this.stone(consumer, Blocks.EMERALD_ORE, 1239);
        this.stone(consumer, Blocks.LAPIS_ORE, 1079);
        this.stone(consumer, Blocks.DIAMOND_ORE, 883);
        this.deepslate(consumer, Blocks.DEEPSLATE_COAL_ORE, 75);
        this.deepslate(consumer, Blocks.DEEPSLATE_IRON_ORE, 250);
        this.deepslate(consumer, Blocks.DEEPSLATE_REDSTONE_ORE, 150);
        this.deepslate(consumer, Blocks.DEEPSLATE_COPPER_ORE, 75);
        this.deepslate(consumer, Blocks.DEEPSLATE_GOLD_ORE, 125);
        this.deepslate(consumer, Blocks.DEEPSLATE_EMERALD_ORE, 50);
        this.deepslate(consumer, Blocks.DEEPSLATE_LAPIS_ORE, 175);
        this.deepslate(consumer, Blocks.DEEPSLATE_DIAMOND_ORE, 100);
        this.netherrack(consumer, Blocks.NETHER_QUARTZ_ORE, 19600);
        this.netherrack(consumer, Blocks.NETHER_GOLD_ORE, 3635);
        this.netherrack(consumer, Blocks.ANCIENT_DEBRIS, 148);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneForest, BotaniaTags.Biomes.MARIMORPHOSIS_FOREST_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStonePlains, BotaniaTags.Biomes.MARIMORPHOSIS_PLAINS_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneMountain, BotaniaTags.Biomes.MARIMORPHOSIS_MOUNTAIN_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneFungal, BotaniaTags.Biomes.MARIMORPHOSIS_FUNGAL_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneSwamp, BotaniaTags.Biomes.MARIMORPHOSIS_SWAMP_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneDesert, BotaniaTags.Biomes.MARIMORPHOSIS_DESERT_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneTaiga, BotaniaTags.Biomes.MARIMORPHOSIS_TAIGA_BONUS);
        this.biomeStone(consumer, BotaniaBlocks.biomeStoneMesa, BotaniaTags.Biomes.MARIMORPHOSIS_MESA_BONUS);
    }

    protected ResourceLocation orechidId(Block b) {
        return BotaniaAPI.botaniaRL("orechid/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    protected ResourceLocation ignemId(Block b) {
        return BotaniaAPI.botaniaRL("orechid_ignem/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    protected ResourceLocation marimorphosisId(Block b) {
        return BotaniaAPI.botaniaRL("marimorphosis/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    protected void stone(RecipeOutput consumer, Block output, int weight) {
        consumer.accept(this.orechidId(output), (Recipe)new OrechidRecipe(OrechidProvider.forBlock(Blocks.STONE), OrechidProvider.forBlock(output), weight, null), null);
    }

    protected void deepslate(RecipeOutput consumer, Block output, int weight) {
        consumer.accept(this.orechidId(output), (Recipe)new OrechidRecipe(OrechidProvider.forBlock(Blocks.DEEPSLATE), OrechidProvider.forBlock(output), weight, null), null);
    }

    protected void netherrack(RecipeOutput consumer, Block output, int weight) {
        consumer.accept(this.ignemId(output), (Recipe)new OrechidIgnemRecipe(OrechidProvider.forBlock(Blocks.NETHERRACK), OrechidProvider.forBlock(output), weight, null), null);
    }

    protected void biomeStone(RecipeOutput consumer, Block output, TagKey<Biome> biome) {
        consumer.accept(this.marimorphosisId(output), (Recipe)new MarimorphosisRecipe(OrechidProvider.forTag(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE), OrechidProvider.forBlock(output), 1, null, 11, biome), null);
    }

    protected static StateIngredient forBlock(Block block) {
        return StateIngredients.of(block);
    }

    protected static StateIngredient forTag(TagKey<Block> tag) {
        return StateIngredients.of(tag);
    }

    public String getName() {
        return "Botania Orechid and Marimorphosis recipes";
    }
}

