/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.ElvenTradeRecipe;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class ElvenTradeProvider
extends BotaniaRecipeProvider {
    public ElvenTradeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Override
    public void buildRecipes(RecipeOutput consumer) {
        consumer.accept(ElvenTradeProvider.id("dreamwood_log"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaBlocks.dreamwoodLog), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.livingwoodLog})), null);
        consumer.accept(ElvenTradeProvider.id("dreamwood"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaBlocks.dreamwood), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.livingwood})), null);
        Ingredient manaSteel = Ingredient.of(BotaniaTags.Items.INGOTS_MANASTEEL);
        Ingredient manaSteelBlock = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manasteelBlock});
        consumer.accept(ElvenTradeProvider.id("elementium"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaItems.elementium), manaSteel, manaSteel), null);
        consumer.accept(ElvenTradeProvider.id("elementium_block"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaBlocks.elementiumBlock), manaSteelBlock, manaSteelBlock), null);
        consumer.accept(ElvenTradeProvider.id("pixie_dust"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaItems.pixieDust), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})), null);
        consumer.accept(ElvenTradeProvider.id("dragonstone"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaItems.dragonstone), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaDiamond})), null);
        consumer.accept(ElvenTradeProvider.id("dragonstone_block"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaBlocks.dragonstoneBlock), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manaDiamondBlock})), null);
        consumer.accept(ElvenTradeProvider.id("elf_quartz"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaItems.elfQuartz), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ})), null);
        consumer.accept(ElvenTradeProvider.id("elf_glass"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)BotaniaBlocks.elfGlass), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manaGlass})), null);
        consumer.accept(ElvenTradeProvider.id("iron_return"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)Items.IRON_INGOT), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), null);
        consumer.accept(ElvenTradeProvider.id("iron_block_return"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)Blocks.IRON_BLOCK), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.IRON_BLOCK})), null);
        consumer.accept(ElvenTradeProvider.id("ender_pearl_return"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)Items.ENDER_PEARL), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL})), null);
        consumer.accept(ElvenTradeProvider.id("diamond_return"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)Items.DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), null);
        consumer.accept(ElvenTradeProvider.id("diamond_block_return"), (Recipe)new ElvenTradeRecipe(ElvenTradeProvider.singleOutput((ItemLike)Blocks.DIAMOND_BLOCK), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DIAMOND_BLOCK})), null);
        consumer.accept(ElvenTradeProvider.id("lexicon_elven"), (Recipe)new LexiconElvenTradeRecipe(), null);
    }

    private static ItemStack[] singleOutput(ItemLike output) {
        return new ItemStack[]{new ItemStack(output)};
    }

    private static ResourceLocation id(String path) {
        return BotaniaAPI.botaniaRL("elven_trade/" + path);
    }

    public String getName() {
        return "Botania elven trade recipes";
    }
}

