/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.ArmorUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.BlackHoleTalismanExtractRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticAttachRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticRemoveRecipe;
import vazkii.botania.common.crafting.recipe.LaputaShardUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.LensDyeingRecipe;
import vazkii.botania.common.crafting.recipe.ManaBlasterClipRecipe;
import vazkii.botania.common.crafting.recipe.ManaBlasterLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaBlasterRemoveLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.MergeVialRecipe;
import vazkii.botania.common.crafting.recipe.PhantomInkRecipe;
import vazkii.botania.common.crafting.recipe.ResoluteIvyRecipe;
import vazkii.botania.common.crafting.recipe.ShapelessManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.SpellbindingClothRecipe;
import vazkii.botania.common.crafting.recipe.SplitLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraShattererTippingRecipe;
import vazkii.botania.common.crafting.recipe.WandOfTheForestRecipe;
import vazkii.botania.common.crafting.recipe.WaterBottleMatchingRecipe;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;
import vazkii.botania.data.recipes.builder.BotaniaSpecialRecipeBuilder;
import vazkii.botania.data.recipes.builder.GogAlternationRecipeBuilder;
import vazkii.botania.data.recipes.builder.NbtOutputRecipeBuilder;
import vazkii.botania.data.recipes.builder.WrapperRecipeBuilder;
import vazkii.botania.mixin.RecipeProviderAccessor;

public class CraftingRecipeProvider
extends BotaniaRecipeProvider {
    public CraftingRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Override
    public void buildRecipes(RecipeOutput recipeOutput) {
        this.specialRecipe(recipeOutput, AncientWillRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, BlackHoleTalismanExtractRecipe::new, CraftingBookCategory.MISC);
        this.specialRecipe(recipeOutput, CompositeLensRecipe::new, CraftingBookCategory.REDSTONE);
        this.specialRecipe(recipeOutput, CosmeticAttachRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, CosmeticRemoveRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, LaputaShardUpgradeRecipe::new, CraftingBookCategory.MISC);
        this.specialRecipe(recipeOutput, LensDyeingRecipe::new, CraftingBookCategory.REDSTONE);
        this.specialRecipe(recipeOutput, ManaBlasterClipRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, ManaBlasterLensRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, ManaBlasterRemoveLensRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, MergeVialRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, PhantomInkRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, ResoluteIvyRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, SpellbindingClothRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.specialRecipe(recipeOutput, SplitLensRecipe::new, CraftingBookCategory.REDSTONE);
        this.specialRecipe(recipeOutput, TerraShattererTippingRecipe::new, CraftingBookCategory.EQUIPMENT);
        this.registerMain(recipeOutput);
        this.registerMisc(recipeOutput);
        this.registerTools(recipeOutput);
        this.registerTrinkets(recipeOutput);
        this.registerLenses(recipeOutput);
        this.registerCorporeaAndRedString(recipeOutput);
        this.registerFloatingFlowers(recipeOutput);
        this.registerConversions(recipeOutput);
        this.registerDecor(recipeOutput);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItem(ItemLike item) {
        return RecipeProviderAccessor.botania_inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{item}));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromItems(ItemLike ... items) {
        ItemPredicate.Builder[] preds = new ItemPredicate.Builder[items.length];
        for (int i = 0; i < items.length; ++i) {
            preds[i] = ItemPredicate.Builder.item().of(new ItemLike[]{items[i]});
        }
        return RecipeProviderAccessor.botania_inventoryTrigger(preds);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> conditionsFromTag(TagKey<Item> tag) {
        return RecipeProviderAccessor.botania_inventoryTrigger(ItemPredicate.Builder.item().of(tag));
    }

    protected ResourceLocation prefix(String path) {
        return BotaniaAPI.botaniaRL(path);
    }

    private void registerMain(RecipeOutput recipeOutput) {
        Criterion<InventoryChangeTrigger.TriggerInstance> hasAnyDye = CraftingRecipeProvider.conditionsFromItems((ItemLike[])ColorHelper.supportedColors().map(DyeItem::byColor).toArray(ItemLike[]::new));
        GogAlternationRecipeBuilder.alternatives((RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.manaSpreader).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).pattern("WWW").pattern("CP ").pattern("WWW").group("botania:spreader").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)), (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.manaSpreader).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern("WWW").pattern("WP ").pattern("WWW").group("botania:spreader").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.redstoneSpreader).requires((ItemLike)BotaniaBlocks.manaSpreader).requires((ItemLike)Items.REDSTONE).group("botania:spreader").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaSpreader)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.elvenSpreader).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).pattern("WWW").pattern("EP ").pattern("WWW").group("botania:spreader").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.gaiaSpreader).requires((ItemLike)BotaniaBlocks.elvenSpreader).requires(BotaniaTags.Items.GEMS_DRAGONSTONE).requires((ItemLike)BotaniaItems.lifeEssence).group("botania:spreader").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.manaPool).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).pattern("R R").pattern("RRR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.dilutedPool).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrockSlab).pattern("R R").pattern("RRR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.fabulousPool).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.shimmerrock).pattern("R R").pattern("RRR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.shimmerrock)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.fabulousPool).define(Character.valueOf('P'), (ItemLike)BotaniaBlocks.manaPool).define(Character.valueOf('B'), (ItemLike)BotaniaBlocks.bifrostPerm).pattern("BPB").pattern("BBB").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.bifrostPerm)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).save(recipeOutput, this.prefix(BuiltInRegistries.ITEM.getKey((Object)BotaniaBlocks.fabulousPool.asItem()).getPath() + "_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.runeAltar).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).pattern("SSS").pattern("SPS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.runeAltar).define(Character.valueOf('P'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).pattern("SSS").pattern("SPS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput, this.prefix("runic_altar_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.manaPylon).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern(" G ").pattern("MDM").pattern(" G ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.naturaPylon).define(Character.valueOf('P'), (ItemLike)BotaniaBlocks.manaPylon).define(Character.valueOf('T'), BotaniaTags.Items.NUGGETS_TERRASTEEL).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).pattern(" T ").pattern("TPT").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaPylon)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.gaiaPylon).define(Character.valueOf('P'), (ItemLike)BotaniaBlocks.manaPylon).define(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern(" D ").pattern("EPE").pattern(" D ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.distributor).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("RRR").pattern("S S").pattern("RRR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.manaVoid).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('O'), (ItemLike)Items.OBSIDIAN).pattern("SSS").pattern("O O").pattern("SSS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.manaDetector).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('T'), (ItemLike)Blocks.TARGET).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).pattern("RSR").pattern("STS").pattern("RSR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Blocks.TARGET)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.turntable).define(Character.valueOf('P'), (ItemLike)Items.STICKY_PISTON).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern("WWW").pattern("WPW").pattern("WWW").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.STICKY_PISTON)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.tinyPlanet).define(Character.valueOf('P'), (ItemLike)BotaniaItems.tinyPlanet).define(Character.valueOf('S'), (ItemLike)Items.STONE).pattern("SSS").pattern("SPS").pattern("SSS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.tinyPlanet)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.alchemyCatalyst).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('B'), (ItemLike)Items.BREWING_STAND).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).pattern("SGS").pattern("BPB").pattern("SGS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.BREWING_STAND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.openCrate).define(Character.valueOf('W'), (ItemLike)BotaniaBlocks.livingwoodPlanks).pattern("WWW").pattern("W W").pattern("W W").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingwoodPlanks)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.craftCrate).define(Character.valueOf('C'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('W'), (ItemLike)BotaniaBlocks.dreamwoodPlanks).pattern("WCW").pattern("W W").pattern("W W").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.dreamwoodPlanks)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.forestEye).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("MSM").pattern("SES").pattern("MSM").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.wildDrum).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).define(Character.valueOf('H'), (ItemLike)BotaniaItems.grassHorn).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("WLW").pattern("WHW").pattern("WLW").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassHorn)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.gatheringDrum).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("WLW").pattern("WEW").pattern("WLW").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.canopyDrum).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).define(Character.valueOf('H'), (ItemLike)BotaniaItems.leavesHorn).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("WLW").pattern("WHW").pattern("WLW").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.leavesHorn)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.abstrusePlatform, (int)2).define(Character.valueOf('0'), BotaniaTags.Items.LIVINGWOOD_LOGS).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('3'), (ItemLike)BotaniaBlocks.livingwoodFramed).define(Character.valueOf('4'), (ItemLike)BotaniaBlocks.livingwoodPatternFramed).pattern("343").pattern("0P0").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.spectralPlatform, (int)2).define(Character.valueOf('0'), BotaniaTags.Items.DREAMWOOD_LOGS).define(Character.valueOf('3'), (ItemLike)BotaniaBlocks.dreamwoodFramed).define(Character.valueOf('4'), (ItemLike)BotaniaBlocks.dreamwoodPatternFramed).define(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).pattern("343").pattern("0D0").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.alfPortal).define(Character.valueOf('T'), BotaniaTags.Items.NUGGETS_TERRASTEEL).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern("WTW").pattern("WTW").pattern("WTW").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.conjurationCatalyst).define(Character.valueOf('P'), (ItemLike)BotaniaBlocks.alchemyCatalyst).define(Character.valueOf('B'), (ItemLike)BotaniaItems.pixieDust).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('G'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("SBS").pattern("GPG").pattern("SGS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.spawnerClaw).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_BRICKS).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('E'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('M'), BotaniaTags.Items.BLOCKS_MANASTEEL).pattern("BSB").pattern("PMP").pattern("PEP").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.enderEye).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('O'), (ItemLike)Items.OBSIDIAN).pattern("RER").pattern("EOE").pattern("RER").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.ENDER_EYE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.starfield).define(Character.valueOf('P'), (ItemLike)BotaniaItems.pixieDust).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('O'), (ItemLike)Items.OBSIDIAN).pattern("EPE").pattern("EOE").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.rfGenerator).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("SRS").pattern("RMR").pattern("SRS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.REDSTONE_BLOCK)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.brewery).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeMana).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('S'), (ItemLike)Items.BREWING_STAND).define(Character.valueOf('M'), BotaniaTags.Items.BLOCKS_MANASTEEL).pattern("RSR").pattern("RAR").pattern("RMR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeMana)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.BREWING_STAND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.terraPlate).define(Character.valueOf('0'), (ItemLike)BotaniaItems.runeWater).define(Character.valueOf('1'), (ItemLike)BotaniaItems.runeFire).define(Character.valueOf('2'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('3'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('8'), (ItemLike)BotaniaItems.runeMana).define(Character.valueOf('L'), (ItemLike)Blocks.LAPIS_BLOCK).define(Character.valueOf('M'), BotaniaTags.Items.BLOCKS_MANASTEEL).pattern("LLL").pattern("0M1").pattern("283").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.RUNES)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.prism).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.spectralPlatform).define(Character.valueOf('G'), (ItemLike)Items.GLASS).pattern("GPG").pattern("GSG").pattern("GPG").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.PRISMARINE_CRYSTALS)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.spectralPlatform)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.pump).define(Character.valueOf('B'), (ItemLike)Items.BUCKET).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("SSS").pattern("IBI").pattern("SSS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.incensePlate).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingwoodSlab).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern("SSW").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.hourglass).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('M'), (ItemLike)BotaniaBlocks.manaGlass).pattern("GMG").pattern("RSR").pattern("GMG").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaGlass)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)BotaniaBlocks.ghostRail).requires((ItemLike)Items.RAIL).requires((ItemLike)BotaniaBlocks.spectralPlatform).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.RAIL)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.spectralPlatform)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.sparkChanger).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("ESE").pattern("SRS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.felPumpkin).define(Character.valueOf('P'), (ItemLike)Items.PUMPKIN).define(Character.valueOf('B'), (ItemLike)Items.BONE).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('F'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('G'), (ItemLike)Items.GUNPOWDER).pattern(" S ").pattern("BPF").pattern(" G ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.PUMPKIN)).save(recipeOutput);
        GogAlternationRecipeBuilder.alternatives((RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaBlocks.cocoon).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('C'), (ItemLike)BotaniaItems.manaweaveCloth).define(Character.valueOf('P'), (ItemLike)BotaniaBlocks.felPumpkin).define(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).pattern("SSS").pattern("CPC").pattern("SDS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.felPumpkin)), (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaBlocks.cocoon).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('P'), (ItemLike)BotaniaBlocks.felPumpkin).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("SSS").pattern("SPS").pattern("SIS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.felPumpkin))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)BotaniaBlocks.lightRelayDefault).requires((ItemLike)BotaniaItems.redString).requires(BotaniaTags.Items.GEMS_DRAGONSTONE).requires((ItemLike)Items.GLOWSTONE_DUST).requires((ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)BotaniaBlocks.lightRelayDetector).requires((ItemLike)BotaniaBlocks.lightRelayDefault).requires((ItemLike)Items.REDSTONE).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)BotaniaBlocks.lightRelayFork).requires((ItemLike)BotaniaBlocks.lightRelayDefault).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)BotaniaBlocks.lightRelayToggle).requires((ItemLike)BotaniaBlocks.lightRelayDefault).requires((ItemLike)Items.LEVER).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.lightLauncher).define(Character.valueOf('D'), BotaniaTags.Items.DREAMWOOD_LOGS).define(Character.valueOf('L'), (ItemLike)BotaniaBlocks.lightRelayDefault).pattern("DDD").pattern("DLD").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.lightRelayDefault)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaBlocks.manaBomb).define(Character.valueOf('T'), (ItemLike)Items.TNT).define(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('L'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern("LTL").pattern("TGT").pattern("LTL").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.bellows).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingwoodSlab).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("SSS").pattern("RL ").pattern("SSS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeAir)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.bifrostPerm).requires((ItemLike)BotaniaItems.rainbowRod).requires((ItemLike)BotaniaBlocks.elfGlass).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.cellBlock, (int)3).requires((ItemLike)Items.CACTUS, 3).requires((ItemLike)Items.BEETROOT).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.POTATO).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaFlowerBlocks.dandelifeon)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.teruTeruBozu).define(Character.valueOf('C'), (ItemLike)BotaniaItems.manaweaveCloth).define(Character.valueOf('S'), (ItemLike)Items.SUNFLOWER).pattern("C").pattern("C").pattern("S").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaweaveCloth)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.avatar).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern(" W ").pattern("WDW").pattern("W W").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.animatedTorch).define(Character.valueOf('D'), BotaniaTags.Items.DUSTS_MANA).define(Character.valueOf('T'), (ItemLike)Items.REDSTONE_TORCH).pattern("D").pattern("T").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.REDSTONE_TORCH)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.DUSTS_MANA)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern(" W").pattern("W ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.redstoneRoot).requires((ItemLike)Items.REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.FERN, Items.SHORT_GRASS})).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.REDSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.dreamwoodTwig).define(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).pattern(" W").pattern("W ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.gaiaIngot).define(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).pattern(" S ").pattern("SIS").pattern(" S ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.manaweaveCloth).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).pattern("SS").pattern("SS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).save(recipeOutput);
        Ingredient dyes = Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_DYE, Items.ORANGE_DYE, Items.MAGENTA_DYE, Items.LIGHT_BLUE_DYE, Items.YELLOW_DYE, Items.LIME_DYE, Items.PINK_DYE, Items.GRAY_DYE, Items.LIGHT_GRAY_DYE, Items.CYAN_DYE, Items.PURPLE_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.GREEN_DYE, Items.RED_DYE, Items.BLACK_DYE});
        GogAlternationRecipeBuilder.alternatives((RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.fertilizer).requires((ItemLike)Items.BONE_MEAL).requires(dyes, 4).unlockedBy("has_item", hasAnyDye), (RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.fertilizer, (int)3).requires((ItemLike)Items.BONE_MEAL).requires(dyes, 4).unlockedBy("has_item", hasAnyDye)).save(recipeOutput, "botania:fertilizer_dye");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.drySeeds).requires((ItemLike)BotaniaItems.grassSeeds).requires((ItemLike)Items.DEAD_BUSH).group("botania:seeds").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.goldenSeeds).requires((ItemLike)BotaniaItems.grassSeeds).requires((ItemLike)Items.WHEAT).group("botania:seeds").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.vividSeeds).requires((ItemLike)BotaniaItems.grassSeeds).requires((ItemLike)Items.GREEN_DYE).group("botania:seeds").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.scorchedSeeds).requires((ItemLike)BotaniaItems.grassSeeds).requires((ItemLike)Items.BLAZE_POWDER).group("botania:seeds").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.infusedSeeds).requires((ItemLike)BotaniaItems.grassSeeds).requires((ItemLike)Items.PRISMARINE_SHARD).group("botania:seeds").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.mutatedSeeds).requires((ItemLike)BotaniaItems.grassSeeds).requires((ItemLike)Items.SPIDER_EYE).group("botania:seeds").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassSeeds)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.darkQuartz, (int)8).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('C'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).pattern("QQQ").pattern("QCQ").pattern("QQQ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.QUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.blazeQuartz, (int)8).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('C'), (ItemLike)Items.BLAZE_POWDER).pattern("QQQ").pattern("QCQ").pattern("QQQ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.QUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lavenderQuartz, (int)8).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('C'), Ingredient.of((ItemLike[])new ItemLike[]{Items.ALLIUM, Items.PINK_TULIP, Items.LILAC, Items.PEONY})).pattern("QQQ").pattern("QCQ").pattern("QQQ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.QUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.redQuartz, (int)8).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('C'), (ItemLike)Items.REDSTONE).pattern("QQQ").pattern("QCQ").pattern("QQQ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.QUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.sunnyQuartz, (int)8).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('C'), (ItemLike)Items.SUNFLOWER).pattern("QQQ").pattern("QCQ").pattern("QQQ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.QUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.vineBall).define(Character.valueOf('V'), (ItemLike)Items.VINE).pattern("VVV").pattern("VVV").pattern("VVV").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.VINE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.necroVirus).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)BotaniaItems.vineBall).requires((ItemLike)Items.MAGMA_CREAM).requires((ItemLike)Items.FERMENTED_SPIDER_EYE).requires((ItemLike)Items.ENDER_EYE).requires((ItemLike)Items.ZOMBIE_HEAD).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.ZOMBIE_HEAD)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.nullVirus).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)BotaniaItems.vineBall).requires((ItemLike)Items.MAGMA_CREAM).requires((ItemLike)Items.FERMENTED_SPIDER_EYE).requires((ItemLike)Items.ENDER_EYE).requires((ItemLike)Items.SKELETON_SKULL).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.SKELETON_SKULL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaItems.spark).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('N'), (ItemLike)Items.GOLD_NUGGET).pattern(" P ").pattern("BNB").pattern(" P ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.BLAZE_POWDER)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaItems.sparkUpgradeDispersive).requires((ItemLike)BotaniaItems.pixieDust).requires(BotaniaTags.Items.INGOTS_MANASTEEL).requires((ItemLike)BotaniaItems.runeWater).group("botania:spark_upgrade").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.sparkUpgradeDominant).requires((ItemLike)BotaniaItems.pixieDust).requires(BotaniaTags.Items.INGOTS_MANASTEEL).requires((ItemLike)BotaniaItems.runeFire).group("botania:spark_upgrade").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.sparkUpgradeRecessive).requires((ItemLike)BotaniaItems.pixieDust).requires(BotaniaTags.Items.INGOTS_MANASTEEL).requires((ItemLike)BotaniaItems.runeEarth).group("botania:spark_upgrade").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.sparkUpgradeIsolated).requires((ItemLike)BotaniaItems.pixieDust).requires(BotaniaTags.Items.INGOTS_MANASTEEL).requires((ItemLike)BotaniaItems.runeAir).group("botania:spark_upgrade").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.spark)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.vial, (int)3).define(Character.valueOf('G'), (ItemLike)BotaniaBlocks.manaGlass).pattern("G G").pattern(" G ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaGlass)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.brewery)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.flask, (int)3).define(Character.valueOf('G'), (ItemLike)BotaniaBlocks.elfGlass).pattern("G G").pattern(" G ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.elfGlass)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.worldSeed, (int)4).define(Character.valueOf('S'), (ItemLike)Items.WHEAT_SEEDS).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('G'), (ItemLike)Items.GRASS_BLOCK).pattern("G").pattern("S").pattern("D").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.thornChakram, (int)2).define(Character.valueOf('T'), BotaniaTags.Items.INGOTS_TERRASTEEL).define(Character.valueOf('V'), (ItemLike)Items.VINE).pattern("VVV").pattern("VTV").pattern("VVV").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.flareChakram, (int)2).define(Character.valueOf('P'), (ItemLike)BotaniaItems.pixieDust).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('C'), (ItemLike)BotaniaItems.thornChakram).pattern("BBB").pattern("CPC").pattern("BBB").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.thornChakram)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.phantomInk, (int)4).requires((ItemLike)BotaniaItems.manaPearl).requires(Ingredient.of((ItemLike[])((ItemLike[])ColorHelper.supportedColors().map(DyeItem::byColor).toArray(ItemLike[]::new)))).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS, Items.WHITE_STAINED_GLASS, Items.ORANGE_STAINED_GLASS, Items.MAGENTA_STAINED_GLASS, Items.LIGHT_BLUE_STAINED_GLASS, Items.YELLOW_STAINED_GLASS, Items.LIME_STAINED_GLASS, Items.PINK_STAINED_GLASS, Items.GRAY_STAINED_GLASS, Items.LIGHT_GRAY_STAINED_GLASS, Items.CYAN_STAINED_GLASS, Items.PURPLE_STAINED_GLASS, Items.BLUE_STAINED_GLASS, Items.BROWN_STAINED_GLASS, Items.GREEN_STAINED_GLASS, Items.RED_STAINED_GLASS, Items.BLACK_STAINED_GLASS})).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.keepIvy).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)Items.VINE).requires((ItemLike)BotaniaItems.enderAirBottle).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).save(recipeOutput);
    }

    private void registerMisc(RecipeOutput recipeOutput) {
        Ingredient mushrooms = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.whiteMushroom, BotaniaBlocks.orangeMushroom, BotaniaBlocks.magentaMushroom, BotaniaBlocks.lightBlueMushroom, BotaniaBlocks.yellowMushroom, BotaniaBlocks.limeMushroom, BotaniaBlocks.pinkMushroom, BotaniaBlocks.grayMushroom, BotaniaBlocks.lightGrayMushroom, BotaniaBlocks.cyanMushroom, BotaniaBlocks.purpleMushroom, BotaniaBlocks.blueMushroom, BotaniaBlocks.brownMushroom, BotaniaBlocks.greenMushroom, BotaniaBlocks.redMushroom, BotaniaBlocks.blackMushroom});
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.MUSHROOM_STEW).requires(mushrooms, 2).requires((ItemLike)Items.BOWL).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.BOWL)).unlockedBy("has_orig_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mushroom_stew"))).save(recipeOutput, "botania:mushroom_stew");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.COBWEB).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('M'), (ItemLike)BotaniaItems.manaString).pattern("S S").pattern(" M ").pattern("S S").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).save(recipeOutput, this.prefix("cobweb"));
        this.petalApothecary((ItemLike)Items.COBBLESTONE, (ItemLike)BotaniaBlocks.defaultAltar).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).save(recipeOutput);
        this.petalApothecary((ItemLike)Items.MOSSY_COBBLESTONE, (ItemLike)BotaniaBlocks.mossyAltar).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).save(recipeOutput);
        this.petalApothecary((ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockAltar).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        this.petalApothecary((ItemLike)Items.COBBLED_DEEPSLATE, (ItemLike)BotaniaBlocks.deepslateAltar).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS)).save(recipeOutput);
        for (String metamorphicVariant : LibBlockNames.METAMORPHIC_VARIANTS) {
            Block apothecary = this.getBlockOrThrow(this.prefix("apothecary_" + metamorphicVariant));
            Block cobble = this.getBlockOrThrow(this.prefix("metamorphic_" + metamorphicVariant + "_cobblestone"));
            this.petalApothecary((ItemLike)cobble, (ItemLike)apothecary).group("botania:metamorphic_apothecary").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)cobble)).unlockedBy("has_flower_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaFlowerBlocks.marimorphosis)).save(recipeOutput);
        }
        ColorHelper.supportedColors().forEach(color -> {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.getShinyFlower(color)).requires((ItemLike)Items.GLOWSTONE_DUST).requires((ItemLike)Items.GLOWSTONE_DUST).requires((ItemLike)BotaniaBlocks.getFlower(color)).group("botania:shiny_flower").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getFlower(color))).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.getFloatingFlower(color)).define(Character.valueOf('S'), (ItemLike)BotaniaItems.grassSeeds).define(Character.valueOf('D'), (ItemLike)Items.DIRT).define(Character.valueOf('F'), (ItemLike)BotaniaBlocks.getShinyFlower(color)).pattern("F").pattern("S").pattern("D").group("botania:floating_flowers").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getShinyFlower(color))).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.getPetalBlock(color)).define(Character.valueOf('P'), (ItemLike)BotaniaItems.getPetal(color)).pattern("PPP").pattern("PPP").pattern("PPP").group("botania:petal_block").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal(color))).save(recipeOutput);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BotaniaBlocks.getMushroom(color)).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_MUSHROOM, Items.BROWN_MUSHROOM})).requires((ItemLike)DyeItem.byColor((DyeColor)color)).group("botania:mushroom").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.RED_MUSHROOM)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.BROWN_MUSHROOM)).save(recipeOutput, "botania:mushroom_" + color.ordinal());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.getPetal(color), (int)4).requires((ItemLike)BotaniaBlocks.getDoubleFlower(color)).group("botania:petal_double").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getDoubleFlower(color))).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal(color))).save(recipeOutput, "botania:petal_" + color.getName() + "_double");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.getPetal(color), (int)2).requires((ItemLike)BotaniaBlocks.getFlower(color)).group("botania:petal").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.getFlower(color))).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal(color))).save(recipeOutput, "botania:petal_" + color.getName());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)DyeItem.byColor((DyeColor)color)).requires(Ingredient.of(BotaniaTags.Items.getPetalTag(color))).group("botania:dye").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.getPetal(color))).save(recipeOutput, "botania:dye_" + color.getName());
        });
    }

    private void registerTools(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.lexicon).requires(ItemTags.SAPLINGS).requires((ItemLike)Items.BOOK).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag((TagKey<Item>)ItemTags.SAPLINGS)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.BOOK)).save(recipeOutput);
        WrapperRecipeBuilder.wrap(WandOfTheForestRecipe.SERIALIZER, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.twigWand).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).pattern(" PS").pattern(" SP").pattern("S  ").group("botania:twig_wand").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS))).save(recipeOutput);
        WrapperRecipeBuilder.wrap(WandOfTheForestRecipe.SERIALIZER, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.dreamwoodWand).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('S'), (ItemLike)BotaniaItems.dreamwoodTwig).pattern(" PS").pattern(" SP").pattern("S  ").group("botania:twig_wand").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.PETALS))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.manaTablet).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).pattern("SSS").pattern("SPS").pattern("SSS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.manaTablet).define(Character.valueOf('P'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.livingrock).pattern("SSS").pattern("SPS").pattern("SSS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput, this.prefix("mana_tablet_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.cacophonium).define(Character.valueOf('N'), (ItemLike)Items.NOTE_BLOCK).define(Character.valueOf('G'), (ItemLike)Items.COPPER_INGOT).pattern(" G ").pattern("GNG").pattern("GG ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.NOTE_BLOCK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.grassHorn).define(Character.valueOf('S'), (ItemLike)BotaniaItems.grassSeeds).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).pattern(" W ").pattern("WSW").pattern("WW ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.leavesHorn).requires((ItemLike)BotaniaItems.grassHorn).requires(ItemTags.LEAVES).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassHorn)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.snowHorn).requires((ItemLike)BotaniaItems.grassHorn).requires((ItemLike)Items.SNOWBALL).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.grassHorn)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.manaMirror).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('T'), (ItemLike)BotaniaItems.manaTablet).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).pattern(" PR").pattern(" SI").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaTablet)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.openBucket).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("E E").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.spawnerMover).define(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('E'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("EIE").pattern("ADA").pattern("EIE").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.slingshot).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).pattern(" TA").pattern(" TT").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeAir)).save(recipeOutput);
        this.registerSimpleArmorSet(recipeOutput, Ingredient.of(BotaniaTags.Items.INGOTS_MANASTEEL), "manasteel", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL));
        this.registerSimpleArmorSet(recipeOutput, Ingredient.of(BotaniaTags.Items.INGOTS_ELEMENTIUM), "elementium", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM));
        this.registerSimpleArmorSet(recipeOutput, Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaweaveCloth}), "manaweave", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaweaveCloth));
        this.registerTerrasteelUpgradeRecipe(recipeOutput, (ItemLike)BotaniaItems.terrasteelHelm, (ItemLike)BotaniaItems.manasteelHelm, (ItemLike)BotaniaItems.runeSpring);
        this.registerTerrasteelUpgradeRecipe(recipeOutput, (ItemLike)BotaniaItems.terrasteelChest, (ItemLike)BotaniaItems.manasteelChest, (ItemLike)BotaniaItems.runeSummer);
        this.registerTerrasteelUpgradeRecipe(recipeOutput, (ItemLike)BotaniaItems.terrasteelLegs, (ItemLike)BotaniaItems.manasteelLegs, (ItemLike)BotaniaItems.runeAutumn);
        this.registerTerrasteelUpgradeRecipe(recipeOutput, (ItemLike)BotaniaItems.terrasteelBoots, (ItemLike)BotaniaItems.manasteelBoots, (ItemLike)BotaniaItems.runeWinter);
        this.registerToolSetRecipes(recipeOutput, Ingredient.of(BotaniaTags.Items.INGOTS_MANASTEEL), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.livingwoodTwig}), CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL), (ItemLike)BotaniaItems.manasteelSword, (ItemLike)BotaniaItems.manasteelPick, (ItemLike)BotaniaItems.manasteelAxe, (ItemLike)BotaniaItems.manasteelHoe, (ItemLike)BotaniaItems.manasteelShovel, (ItemLike)BotaniaItems.manasteelShears);
        this.registerToolSetRecipes(recipeOutput, Ingredient.of(BotaniaTags.Items.INGOTS_ELEMENTIUM), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.dreamwoodTwig}), CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM), (ItemLike)BotaniaItems.elementiumSword, (ItemLike)BotaniaItems.elementiumPick, (ItemLike)BotaniaItems.elementiumAxe, (ItemLike)BotaniaItems.elementiumHoe, (ItemLike)BotaniaItems.elementiumShovel, (ItemLike)BotaniaItems.elementiumShears);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.terraSword).define(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).pattern("I").pattern("I").pattern("S").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        WrapperRecipeBuilder.wrap(ManaUpgradeRecipe.SERIALIZER, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.terraPick).define(Character.valueOf('T'), (ItemLike)BotaniaItems.manaTablet).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_TERRASTEEL).define(Character.valueOf('L'), (ItemLike)BotaniaItems.livingwoodTwig).pattern("ITI").pattern("ILI").pattern(" L ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.terraAxe).define(Character.valueOf('S'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('T'), BotaniaTags.Items.INGOTS_TERRASTEEL).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE).pattern("TTG").pattern("TST").pattern(" S ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.starSword).define(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('T'), (ItemLike)BotaniaItems.terraSword).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("  I").pattern("AD ").pattern("TA ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.terraAxe)).unlockedBy("has_terrasteel", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.thunderSword).define(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('T'), (ItemLike)BotaniaItems.terraSword).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("  I").pattern("AD ").pattern("TA ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.terraAxe)).unlockedBy("has_terrasteel", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.glassPick).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("GIG").pattern(" T ").pattern(" T ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.livingwoodBow).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).pattern(" TS").pattern("T S").pattern(" TS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).unlockedBy("has_twig", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.livingwoodTwig)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.crystalBow).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).pattern(" DS").pattern("T S").pattern(" DS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.enderDagger).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).pattern("P").pattern("S").pattern("T").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.enderHand).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('E'), (ItemLike)Items.ENDER_CHEST).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('O'), (ItemLike)Items.OBSIDIAN).pattern("PLO").pattern("LEL").pattern("OL ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.ENDER_CHEST)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.ENDER_EYE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.placeholder, (int)32).requires((ItemLike)Items.CRAFTING_TABLE).requires((ItemLike)BotaniaBlocks.livingrock).unlockedBy("has_dreamwood", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).unlockedBy("has_crafty_crate", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.craftCrate)).save(recipeOutput);
        for (CraftyCratePattern pattern : CraftyCratePattern.values()) {
            if (pattern == CraftyCratePattern.NONE) continue;
            Item item = this.getItemOrThrow(this.prefix("pattern_" + pattern.getSerializedName().split("_", 2)[1]));
            String s = pattern.openSlots.stream().map(bool -> bool != false ? "R" : "P").collect(Collectors.joining());
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)item).define(Character.valueOf('P'), (ItemLike)BotaniaItems.placeholder).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).pattern(s.substring(0, 3)).pattern(s.substring(3, 6)).pattern(s.substring(6, 9)).group("botania:craft_pattern").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.placeholder)).unlockedBy("has_crafty_crate", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.craftCrate)).save(recipeOutput);
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.manaGun).define(Character.valueOf('S'), (ItemLike)BotaniaBlocks.redstoneSpreader).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('T'), (ItemLike)Items.TNT).define(Character.valueOf('W'), BotaniaTags.Items.LIVINGWOOD_LOGS).define(Character.valueOf('M'), (ItemLike)BotaniaItems.runeMana).pattern("SMD").pattern(" WT").pattern("  W").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.dirtRod).define(Character.valueOf('D'), (ItemLike)Items.DIRT).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).pattern("  D").pattern(" T ").pattern("E  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeEarth)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.terraformRod).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAutumn).define(Character.valueOf('R'), (ItemLike)BotaniaItems.dirtRod).define(Character.valueOf('S'), (ItemLike)BotaniaItems.runeSpring).define(Character.valueOf('T'), BotaniaTags.Items.INGOTS_TERRASTEEL).define(Character.valueOf('G'), (ItemLike)BotaniaItems.grassSeeds).define(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWinter).define(Character.valueOf('M'), (ItemLike)BotaniaItems.runeSummer).pattern(" WT").pattern("ARS").pattern("GM ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        WrapperRecipeBuilder.wrap(WaterBottleMatchingRecipe.SERIALIZER, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.waterRod).define(Character.valueOf('B'), Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)})).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeWater).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).pattern("  B").pattern(" T ").pattern("R  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeWater))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.rainbowRod).define(Character.valueOf('P'), (ItemLike)BotaniaItems.pixieDust).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern(" PD").pattern(" EP").pattern("E  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.tornadoRod).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).pattern("  F").pattern(" T ").pattern("R  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeAir)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.fireRod).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeFire).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('F'), (ItemLike)Items.BLAZE_POWDER).pattern("  F").pattern(" T ").pattern("R  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeFire)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.skyDirtRod).requires((ItemLike)BotaniaItems.dirtRod).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)BotaniaItems.runeAir).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.diviningRod).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).pattern(" TD").pattern(" TT").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.gravityRod).define(Character.valueOf('T'), (ItemLike)BotaniaItems.dreamwoodTwig).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).pattern(" TD").pattern(" WT").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.missileRod).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('T'), (ItemLike)BotaniaItems.dreamwoodTwig).define(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).pattern("GDD").pattern(" TD").pattern("T G").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.cobbleRod).define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('F'), (ItemLike)BotaniaItems.runeFire).define(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWater).pattern(" FC").pattern(" TW").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeFire)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeWater)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.smeltRod).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('F'), (ItemLike)BotaniaItems.runeFire).pattern(" BF").pattern(" TB").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeFire)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.exchangeRod).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeSloth).define(Character.valueOf('S'), (ItemLike)Items.STONE).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).pattern(" SR").pattern(" TS").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeSloth)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.laputaShard).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('F'), BotaniaTags.Items.MUNDANE_FLOATING_FLOWERS).pattern("SFS").pattern("PDP").pattern("ASE").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.craftingHalo).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('C'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern(" P ").pattern("ICI").pattern(" I ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.clip).define(Character.valueOf('D'), BotaniaTags.Items.DREAMWOOD_LOGS).pattern(" D ").pattern("D D").pattern("DD ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.spellCloth).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('C'), (ItemLike)BotaniaItems.manaweaveCloth).pattern(" C ").pattern("CPC").pattern(" C ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaweaveCloth)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.flowerBag).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('W'), ItemTags.WOOL).pattern("WPW").pattern("W W").pattern(" W ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.MYSTICAL_FLOWERS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)BotaniaItems.poolMinecart).requires((ItemLike)Items.MINECART).requires((ItemLike)BotaniaBlocks.manaPool).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.blackHoleTalisman).define(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).pattern(" G ").pattern("EAE").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.temperanceStone).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('S'), (ItemLike)Items.STONE).pattern(" S ").pattern("SRS").pattern(" S ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeEarth)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.incenseStick).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('G'), (ItemLike)Items.GHAST_TEAR).pattern("  G").pattern(" B ").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.GHAST_TEAR)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.obedienceStick).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("  M").pattern(" T ").pattern("T  ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.slimeBottle).define(Character.valueOf('S'), (ItemLike)Items.SLIME_BALL).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('G'), (ItemLike)BotaniaBlocks.elfGlass).pattern("EGE").pattern("ESE").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.autocraftingHalo).requires((ItemLike)BotaniaItems.craftingHalo).requires(BotaniaTags.Items.GEMS_MANA_DIAMOND).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.sextant).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern(" TI").pattern(" TT").pattern("III").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.astrolabe).define(Character.valueOf('D'), BotaniaTags.Items.DREAMWOOD_LOGS).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).pattern(" EG").pattern("EEE").pattern("GED").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
    }

    private void registerTrinkets(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.tinyPlanet).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('S'), (ItemLike)Items.STONE).define(Character.valueOf('L'), (ItemLike)BotaniaBlocks.livingrock).pattern("LSL").pattern("SPS").pattern("LSL").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        WrapperRecipeBuilder.wrap(ManaUpgradeRecipe.SERIALIZER, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.manaRing).define(Character.valueOf('T'), (ItemLike)BotaniaItems.manaTablet).define(Character.valueOf('I'), (ItemLike)BotaniaItems.manaSteel).pattern("TI ").pattern("I I").pattern(" I ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaTablet))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.auraRing).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeMana).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("RI ").pattern("I I").pattern(" I ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.runeMana)).save(recipeOutput);
        WrapperRecipeBuilder.wrap(ShapelessManaUpgradeRecipe.SERIALIZER, (RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.manaRingGreater).requires(BotaniaTags.Items.INGOTS_TERRASTEEL).requires((ItemLike)BotaniaItems.manaRing).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.terrasteel))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.auraRingGreater).requires(BotaniaTags.Items.INGOTS_TERRASTEEL).requires((ItemLike)BotaniaItems.auraRing).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.travelBelt).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("EL ").pattern("L L").pattern("SLA").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.knockbackBelt).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeFire).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("AL ").pattern("L L").pattern("SLE").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.icePendant).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeWater).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).define(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWinter).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("WS ").pattern("S S").pattern("MSR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.lavaPendant).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).define(Character.valueOf('D'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('F'), (ItemLike)BotaniaItems.runeFire).define(Character.valueOf('M'), (ItemLike)BotaniaItems.runeSummer).pattern("MS ").pattern("S S").pattern("DSF").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.magnetRing).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensMagnet).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("LM ").pattern("M M").pattern(" M ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.waterRing).define(Character.valueOf('P'), (ItemLike)Items.PUFFERFISH).define(Character.valueOf('C'), (ItemLike)Items.COD).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).define(Character.valueOf('W'), (ItemLike)BotaniaItems.runeWater).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("WMP").pattern("MHM").pattern("CM ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.HEART_OF_THE_SEA)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.miningRing).define(Character.valueOf('P'), (ItemLike)Items.GOLDEN_PICKAXE).define(Character.valueOf('E'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("EMP").pattern("M M").pattern(" M ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.divaCharm).define(Character.valueOf('P'), (ItemLike)BotaniaItems.tinyPlanet).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('H'), (ItemLike)BotaniaItems.runePride).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lifeEssence).pattern("LGP").pattern(" HG").pattern(" GL").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.flightTiara).define(Character.valueOf('E'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lifeEssence).pattern("LLL").pattern("ILI").pattern("FEF").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput, "botania:flighttiara_0");
        Item[] items = new Item[]{Items.QUARTZ, BotaniaItems.darkQuartz, BotaniaItems.manaQuartz, BotaniaItems.blazeQuartz, BotaniaItems.lavenderQuartz, BotaniaItems.redQuartz, BotaniaItems.elfQuartz, BotaniaItems.sunnyQuartz};
        for (int i = 0; i < items.length; ++i) {
            int tiaraType = i + 1;
            NbtOutputRecipeBuilder.setNbt((RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.flightTiara).requires((ItemLike)BotaniaItems.flightTiara).requires((ItemLike)items[i]).group("botania:flight_tiara_wings").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.flightTiara)), tag -> tag.putInt("variant", tiaraType)).save(recipeOutput, "botania:flighttiara_" + tiaraType);
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.pixieRing).define(Character.valueOf('D'), (ItemLike)BotaniaItems.pixieDust).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("DE ").pattern("E E").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.superTravelBelt).define(Character.valueOf('S'), (ItemLike)BotaniaItems.travelBelt).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lifeEssence).pattern("E  ").pattern(" S ").pattern("L E").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.reachRing).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runePride).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).pattern("RE ").pattern("E E").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.itemFinder).define(Character.valueOf('E'), (ItemLike)Items.EMERALD).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('Y'), (ItemLike)Items.ENDER_EYE).pattern(" I ").pattern("IYI").pattern("IEI").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.ENDER_EYE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.superLavaPendant).define(Character.valueOf('P'), (ItemLike)BotaniaItems.lavaPendant).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('N'), (ItemLike)Items.NETHER_BRICK).pattern("BBB").pattern("BPB").pattern("NGN").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.bloodPendant).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('G'), (ItemLike)Items.GHAST_TEAR).pattern(" P ").pattern("PGP").pattern("DP ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.GHAST_TEAR)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.holyCloak).define(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).pattern("WWW").pattern("GWG").pattern("GSG").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.unholyCloak).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('W'), (ItemLike)Items.BLACK_WOOL).pattern("WWW").pattern("RWR").pattern("RSR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)BotaniaItems.balanceCloak).define(Character.valueOf('R'), (ItemLike)Items.EMERALD).define(Character.valueOf('S'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('W'), (ItemLike)Items.LIGHT_GRAY_WOOL).pattern("WWW").pattern("RWR").pattern("RSR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.monocle).define(Character.valueOf('G'), (ItemLike)BotaniaBlocks.manaGlass).define(Character.valueOf('I'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('N'), (ItemLike)Items.GOLD_NUGGET).pattern("GN").pattern("IN").pattern(" N").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.swapRing).define(Character.valueOf('C'), (ItemLike)Items.CLAY).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("CM ").pattern("M M").pattern(" M ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.magnetRingGreater).requires(BotaniaTags.Items.INGOTS_TERRASTEEL).requires((ItemLike)BotaniaItems.magnetRing).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.magnetRing)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.speedUpBelt).define(Character.valueOf('P'), (ItemLike)BotaniaItems.grassSeeds).define(Character.valueOf('B'), (ItemLike)BotaniaItems.travelBelt).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('M'), (ItemLike)Items.MAP).pattern(" M ").pattern("PBP").pattern(" S ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.MAP)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.travelBelt)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.dodgeRing).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('E'), (ItemLike)Items.EMERALD).define(Character.valueOf('M'), BotaniaTags.Items.INGOTS_MANASTEEL).pattern("EM ").pattern("M M").pattern(" MR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.invisibilityCloak).define(Character.valueOf('P'), (ItemLike)BotaniaItems.manaPearl).define(Character.valueOf('C'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('G'), (ItemLike)BotaniaBlocks.manaGlass).pattern("CWC").pattern("GWG").pattern("GPG").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaPearl)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.cloudPendant).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).define(Character.valueOf('D'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('F'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('M'), (ItemLike)BotaniaItems.runeAutumn).pattern("MS ").pattern("S S").pattern("DSF").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.superCloudPendant).define(Character.valueOf('P'), (ItemLike)BotaniaItems.cloudPendant).define(Character.valueOf('B'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('G'), (ItemLike)BotaniaItems.lifeEssence).define(Character.valueOf('N'), (ItemLike)Items.WHITE_WOOL).pattern("BEB").pattern("BPB").pattern("NGN").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.cloudPendant)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lifeEssence)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.thirdEye).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ_BLOCK).define(Character.valueOf('R'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('S'), (ItemLike)BotaniaItems.runeEarth).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).pattern("RSR").pattern("QEQ").pattern("RDR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)BotaniaItems.goddessCharm).define(Character.valueOf('P'), BotaniaTags.Items.PETALS_PINK).define(Character.valueOf('A'), (ItemLike)BotaniaItems.runeWater).define(Character.valueOf('S'), (ItemLike)BotaniaItems.runeSpring).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_MANA_DIAMOND).pattern(" P ").pattern(" P ").pattern("ADS").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND)).save(recipeOutput);
    }

    private void registerCorporeaAndRedString(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.redString).requires((ItemLike)Items.STRING).requires((ItemLike)Items.REDSTONE_BLOCK).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)BotaniaItems.enderAirBottle).group("botania:red_string").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.redString).requires((ItemLike)Items.STRING).requires((ItemLike)Items.REDSTONE_BLOCK).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)BotaniaItems.enderAirBottle).requires((ItemLike)Items.PUMPKIN).group("botania:red_string").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).save(recipeOutput, "botania:red_string_alt");
        CraftingRecipeProvider.registerRedStringBlock(recipeOutput, (ItemLike)BotaniaBlocks.redStringDispenser, Ingredient.of((ItemLike[])new ItemLike[]{Items.DISPENSER}), CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.DISPENSER));
        CraftingRecipeProvider.registerRedStringBlock(recipeOutput, (ItemLike)BotaniaBlocks.redStringFertilizer, Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.fertilizer}), CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.fertilizer));
        CraftingRecipeProvider.registerRedStringBlock(recipeOutput, (ItemLike)BotaniaBlocks.redStringComparator, Ingredient.of((ItemLike[])new ItemLike[]{Items.COMPARATOR}), CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.COMPARATOR));
        CraftingRecipeProvider.registerRedStringBlock(recipeOutput, (ItemLike)BotaniaBlocks.redStringRelay, Ingredient.of((ItemLike[])new ItemLike[]{BotaniaBlocks.manaSpreader}), CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.manaSpreader));
        CraftingRecipeProvider.registerRedStringBlock(recipeOutput, (ItemLike)BotaniaBlocks.redStringInterceptor, Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_BUTTON}), CraftingRecipeProvider.conditionsFromItem((ItemLike)Items.STONE_BUTTON));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaItems.corporeaSpark, (int)4).requires((ItemLike)BotaniaItems.spark).requires((ItemLike)BotaniaItems.pixieDust).requires((ItemLike)BotaniaItems.enderAirBottle).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.enderAirBottle)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaItems.corporeaSparkMaster).requires((ItemLike)BotaniaItems.corporeaSpark).requires(BotaniaTags.Items.GEMS_DRAGONSTONE).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.corporeaIndex).define(Character.valueOf('A'), (ItemLike)BotaniaItems.enderAirBottle).define(Character.valueOf('S'), (ItemLike)BotaniaItems.corporeaSpark).define(Character.valueOf('D'), BotaniaTags.Items.GEMS_DRAGONSTONE).define(Character.valueOf('O'), (ItemLike)Items.OBSIDIAN).pattern("AOA").pattern("OSO").pattern("DOD").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.corporeaFunnel).requires((ItemLike)Items.DROPPER).requires((ItemLike)BotaniaItems.corporeaSpark).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.corporeaInterceptor).requires((ItemLike)Items.REDSTONE_BLOCK).requires((ItemLike)BotaniaItems.corporeaSpark).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)BotaniaBlocks.corporeaCrystalCube).define(Character.valueOf('C'), (ItemLike)BotaniaItems.corporeaSpark).define(Character.valueOf('G'), (ItemLike)BotaniaBlocks.elfGlass).define(Character.valueOf('W'), BotaniaTags.Items.DREAMWOOD_LOGS).pattern("C").pattern("G").pattern("W").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.corporeaBlock, (int)8).requires((ItemLike)BotaniaBlocks.livingrockPolished).requires((ItemLike)BotaniaItems.corporeaSpark).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.corporeaSpark)).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.corporeaSlab, (ItemLike)BotaniaBlocks.corporeaBlock).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.corporeaStairs, (ItemLike)BotaniaBlocks.corporeaBlock).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.corporeaBrick, (int)4).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.corporeaBlock).pattern("RR").pattern("RR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.corporeaBlock)).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.corporeaBrickSlab, (ItemLike)BotaniaBlocks.corporeaBrick).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.corporeaBrickStairs, (ItemLike)BotaniaBlocks.corporeaBrick).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.corporeaBrickWall, (ItemLike)BotaniaBlocks.corporeaBrick, 6).save(recipeOutput);
    }

    private void registerLenses(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensNormal).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_MANASTEEL).define(Character.valueOf('G'), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS, Items.GLASS_PANE})).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensSpeed).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeAir).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensPower).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeFire).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensTime).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeEarth).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensEfficiency).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeWater).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensBounce).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeSummer).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensGravity).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeWinter).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensMine).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('A'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern(" P ").pattern("ALA").pattern(" R ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensDamage).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeWrath).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensPhantom).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaBlocks.abstrusePlatform).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensMagnet).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)Items.IRON_INGOT).requires((ItemLike)Items.GOLD_INGOT).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensExplosive).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.runeEnvy).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensInfluence).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeAir).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern("PRP").pattern("PLP").pattern("PPP").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensWeight).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).define(Character.valueOf('R'), (ItemLike)BotaniaItems.runeWater).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern("PPP").pattern("PLP").pattern("PRP").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensPaint).define(Character.valueOf('E'), BotaniaTags.Items.INGOTS_ELEMENTIUM).define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern(" E ").pattern("WLW").pattern(" E ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensFire).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)Items.FIRE_CHARGE).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensPiston).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaBlocks.pistonRelay).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensLight).define(Character.valueOf('F'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern("GFG").pattern("FLF").pattern("GFG").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensLight).define(Character.valueOf('F'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern("FGF").pattern("GLG").pattern("FGF").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput, "botania:lens_light_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensMessenger).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('L'), (ItemLike)BotaniaItems.lensNormal).pattern(" P ").pattern("PLP").pattern(" P ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.lensNormal)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensWarp).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaItems.pixieDust).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.pixieDust)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensRedirect).requires((ItemLike)BotaniaItems.lensNormal).requires(BotaniaTags.Items.LIVINGWOOD_LOGS).requires(BotaniaTags.Items.INGOTS_ELEMENTIUM).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensFirework).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)Items.FIREWORK_ROCKET).requires(BotaniaTags.Items.INGOTS_ELEMENTIUM).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensFlare).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)BotaniaBlocks.elfGlass).requires(BotaniaTags.Items.INGOTS_ELEMENTIUM).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)BotaniaItems.lensTripwire).requires((ItemLike)BotaniaItems.lensNormal).requires((ItemLike)Items.TRIPWIRE_HOOK).requires(BotaniaTags.Items.INGOTS_ELEMENTIUM).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM)).save(recipeOutput);
    }

    private void registerFloatingFlowers(RecipeOutput recipeOutput) {
        for (Block block : new Block[]{BotaniaFlowerBlocks.pureDaisy, BotaniaFlowerBlocks.manastar, BotaniaFlowerBlocks.hydroangeas, BotaniaFlowerBlocks.endoflame, BotaniaFlowerBlocks.thermalily, BotaniaFlowerBlocks.rosaArcana, BotaniaFlowerBlocks.munchdew, BotaniaFlowerBlocks.entropinnyum, BotaniaFlowerBlocks.kekimurus, BotaniaFlowerBlocks.gourmaryllis, BotaniaFlowerBlocks.narslimmus, BotaniaFlowerBlocks.spectrolus, BotaniaFlowerBlocks.dandelifeon, BotaniaFlowerBlocks.rafflowsia, BotaniaFlowerBlocks.shulkMeNot, BotaniaFlowerBlocks.bellethorn, BotaniaFlowerBlocks.bellethornChibi, BotaniaFlowerBlocks.bergamute, BotaniaFlowerBlocks.dreadthorn, BotaniaFlowerBlocks.heiseiDream, BotaniaFlowerBlocks.tigerseye, BotaniaFlowerBlocks.jadedAmaranthus, BotaniaFlowerBlocks.orechid, BotaniaFlowerBlocks.fallenKanade, BotaniaFlowerBlocks.exoflame, BotaniaFlowerBlocks.agricarnation, BotaniaFlowerBlocks.agricarnationChibi, BotaniaFlowerBlocks.hopperhock, BotaniaFlowerBlocks.hopperhockChibi, BotaniaFlowerBlocks.tangleberrie, BotaniaFlowerBlocks.tangleberrieChibi, BotaniaFlowerBlocks.jiyuulia, BotaniaFlowerBlocks.jiyuuliaChibi, BotaniaFlowerBlocks.rannuncarpus, BotaniaFlowerBlocks.rannuncarpusChibi, BotaniaFlowerBlocks.hyacidus, BotaniaFlowerBlocks.pollidisiac, BotaniaFlowerBlocks.clayconia, BotaniaFlowerBlocks.clayconiaChibi, BotaniaFlowerBlocks.loonium, BotaniaFlowerBlocks.daffomill, BotaniaFlowerBlocks.vinculotus, BotaniaFlowerBlocks.spectranthemum, BotaniaFlowerBlocks.medumone, BotaniaFlowerBlocks.marimorphosis, BotaniaFlowerBlocks.marimorphosisChibi, BotaniaFlowerBlocks.bubbell, BotaniaFlowerBlocks.bubbellChibi, BotaniaFlowerBlocks.solegnolia, BotaniaFlowerBlocks.solegnoliaChibi, BotaniaFlowerBlocks.orechidIgnem, BotaniaFlowerBlocks.labellia}) {
            this.createFloatingFlowerRecipe(recipeOutput, (ItemLike)block);
        }
    }

    private void registerConversions(RecipeOutput recipeOutput) {
        this.compression((ItemLike)BotaniaItems.manaSteel, BotaniaTags.Items.NUGGETS_MANASTEEL).save(recipeOutput, this.prefix("conversions/manasteel_from_nuggets"));
        this.compression((ItemLike)BotaniaItems.elementium, BotaniaTags.Items.NUGGETS_ELEMENTIUM).save(recipeOutput, this.prefix("conversions/elementium_from_nuggets"));
        this.compression((ItemLike)BotaniaItems.terrasteel, BotaniaTags.Items.NUGGETS_TERRASTEEL).save(recipeOutput, this.prefix("conversions/terrasteel_from_nugget"));
        this.compression((ItemLike)BotaniaBlocks.manasteelBlock, BotaniaTags.Items.INGOTS_MANASTEEL).save(recipeOutput);
        this.compression((ItemLike)BotaniaBlocks.terrasteelBlock, BotaniaTags.Items.INGOTS_TERRASTEEL).save(recipeOutput);
        this.compression((ItemLike)BotaniaBlocks.elementiumBlock, BotaniaTags.Items.INGOTS_ELEMENTIUM).save(recipeOutput);
        this.compression((ItemLike)BotaniaBlocks.manaDiamondBlock, BotaniaTags.Items.GEMS_MANA_DIAMOND).save(recipeOutput);
        this.compression((ItemLike)BotaniaBlocks.dragonstoneBlock, BotaniaTags.Items.GEMS_DRAGONSTONE).save(recipeOutput);
        GogAlternationRecipeBuilder.alternatives((RecipeBuilder)this.compression((ItemLike)BotaniaBlocks.blazeBlock, (ItemLike)Items.BLAZE_ROD), (RecipeBuilder)this.compression((ItemLike)BotaniaBlocks.blazeBlock, (ItemLike)Items.BLAZE_POWDER)).save(recipeOutput);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.whitePetal, (ItemLike)BotaniaBlocks.petalBlockWhite);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.orangePetal, (ItemLike)BotaniaBlocks.petalBlockOrange);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.magentaPetal, (ItemLike)BotaniaBlocks.petalBlockMagenta);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.lightBluePetal, (ItemLike)BotaniaBlocks.petalBlockLightBlue);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.yellowPetal, (ItemLike)BotaniaBlocks.petalBlockYellow);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.limePetal, (ItemLike)BotaniaBlocks.petalBlockLime);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.pinkPetal, (ItemLike)BotaniaBlocks.petalBlockPink);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.grayPetal, (ItemLike)BotaniaBlocks.petalBlockGray);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.lightGrayPetal, (ItemLike)BotaniaBlocks.petalBlockSilver);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.cyanPetal, (ItemLike)BotaniaBlocks.petalBlockCyan);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.purplePetal, (ItemLike)BotaniaBlocks.petalBlockPurple);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.bluePetal, (ItemLike)BotaniaBlocks.petalBlockBlue);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.brownPetal, (ItemLike)BotaniaBlocks.petalBlockBrown);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.greenPetal, (ItemLike)BotaniaBlocks.petalBlockGreen);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.redPetal, (ItemLike)BotaniaBlocks.petalBlockRed);
        this.deconstructPetalBlock(recipeOutput, (ItemLike)BotaniaItems.blackPetal, (ItemLike)BotaniaBlocks.petalBlockBlack);
        GogAlternationRecipeBuilder.saveAlternatives(recipeOutput, output -> this.deconstruct((RecipeOutput)output, (ItemLike)Items.BLAZE_ROD, (ItemLike)BotaniaBlocks.blazeBlock, "blazeblock_deconstruct"), output -> this.deconstruct((RecipeOutput)output, (ItemLike)Items.BLAZE_POWDER, (ItemLike)BotaniaBlocks.blazeBlock, "blazeblock_deconstruct"));
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.manaSteel, BotaniaTags.Items.BLOCKS_MANASTEEL, "manasteel_block_deconstruct");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.manaDiamond, (ItemLike)BotaniaBlocks.manaDiamondBlock, "manadiamond_block_deconstruct");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.terrasteel, BotaniaTags.Items.BLOCKS_TERRASTEEL, "terrasteel_block_deconstruct");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.elementium, BotaniaTags.Items.BLOCKS_ELEMENTIUM, "elementium_block_deconstruct");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.dragonstone, (ItemLike)BotaniaBlocks.dragonstoneBlock, "dragonstone_block_deconstruct");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.manasteelNugget, BotaniaTags.Items.INGOTS_MANASTEEL, "manasteel_to_nuggets");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.terrasteelNugget, BotaniaTags.Items.INGOTS_TERRASTEEL, "terrasteel_to_nugget");
        this.deconstruct(recipeOutput, (ItemLike)BotaniaItems.elementiumNugget, BotaniaTags.Items.INGOTS_ELEMENTIUM, "elementium_to_nuggets");
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.livingrock, (ItemLike)BotaniaBlocks.livingrockSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.livingrockPolished, (ItemLike)BotaniaBlocks.livingrockPolishedSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.livingrockBrick, (ItemLike)BotaniaBlocks.livingrockBrickSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.livingwood, (ItemLike)BotaniaBlocks.livingwoodSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.livingwoodPlanks, (ItemLike)BotaniaBlocks.livingwoodPlankSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.dreamwood, (ItemLike)BotaniaBlocks.dreamwoodSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.dreamwoodPlanks, (ItemLike)BotaniaBlocks.dreamwoodPlankSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.shimmerrock, (ItemLike)BotaniaBlocks.shimmerrockSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.shimmerwoodPlanks, (ItemLike)BotaniaBlocks.shimmerwoodPlankSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneForest, (ItemLike)BotaniaBlocks.biomeStoneForestSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickForest, (ItemLike)BotaniaBlocks.biomeBrickForestSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneForest, (ItemLike)BotaniaBlocks.biomeCobblestoneForestSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStonePlains, (ItemLike)BotaniaBlocks.biomeStonePlainsSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickPlains, (ItemLike)BotaniaBlocks.biomeBrickPlainsSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestonePlains, (ItemLike)BotaniaBlocks.biomeCobblestonePlainsSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneMountain, (ItemLike)BotaniaBlocks.biomeStoneMountainSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickMountain, (ItemLike)BotaniaBlocks.biomeBrickMountainSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneMountain, (ItemLike)BotaniaBlocks.biomeCobblestoneMountainSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneFungal, (ItemLike)BotaniaBlocks.biomeStoneFungalSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickFungal, (ItemLike)BotaniaBlocks.biomeBrickFungalSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneFungal, (ItemLike)BotaniaBlocks.biomeCobblestoneFungalSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneSwamp, (ItemLike)BotaniaBlocks.biomeStoneSwampSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickSwamp, (ItemLike)BotaniaBlocks.biomeBrickSwampSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneSwamp, (ItemLike)BotaniaBlocks.biomeCobblestoneSwampSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneDesert, (ItemLike)BotaniaBlocks.biomeStoneDesertSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickDesert, (ItemLike)BotaniaBlocks.biomeBrickDesertSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneDesert, (ItemLike)BotaniaBlocks.biomeCobblestoneDesertSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneTaiga, (ItemLike)BotaniaBlocks.biomeStoneTaigaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickTaiga, (ItemLike)BotaniaBlocks.biomeBrickTaigaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneTaiga, (ItemLike)BotaniaBlocks.biomeCobblestoneTaigaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeStoneMesa, (ItemLike)BotaniaBlocks.biomeStoneMesaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeBrickMesa, (ItemLike)BotaniaBlocks.biomeBrickMesaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.biomeCobblestoneMesa, (ItemLike)BotaniaBlocks.biomeCobblestoneMesaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.whitePavement, (ItemLike)BotaniaBlocks.whitePavementSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.blackPavement, (ItemLike)BotaniaBlocks.blackPavementSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.bluePavement, (ItemLike)BotaniaBlocks.bluePavementSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.yellowPavement, (ItemLike)BotaniaBlocks.yellowPavementSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.redPavement, (ItemLike)BotaniaBlocks.redPavementSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.greenPavement, (ItemLike)BotaniaBlocks.greenPavementSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.darkQuartz, (ItemLike)BotaniaBlocks.darkQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.manaQuartz, (ItemLike)BotaniaBlocks.manaQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.blazeQuartz, (ItemLike)BotaniaBlocks.blazeQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.lavenderQuartz, (ItemLike)BotaniaBlocks.lavenderQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.redQuartz, (ItemLike)BotaniaBlocks.redQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.elfQuartz, (ItemLike)BotaniaBlocks.elfQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.sunnyQuartz, (ItemLike)BotaniaBlocks.sunnyQuartzSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.corporeaBlock, (ItemLike)BotaniaBlocks.corporeaSlab);
        this.recombineSlab(recipeOutput, (ItemLike)BotaniaBlocks.corporeaBrick, (ItemLike)BotaniaBlocks.corporeaBrickSlab);
    }

    private void registerDecor(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.livingrockPolished, (int)4).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).pattern("RR").pattern("RR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.livingrockSlate).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrockSlab).pattern("R").pattern("R").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.livingrockBrick, (int)4).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrockPolished).pattern("RR").pattern("RR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockPolished)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.livingrockBrickChiseled).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrockBrickSlab).pattern("R").pattern("R").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockBrick)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.livingrockBrickMossy).requires((ItemLike)BotaniaBlocks.livingrockBrick).requires((ItemLike)Items.MOSS_BLOCK).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockBrick)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.livingrockBrickMossy).requires((ItemLike)BotaniaBlocks.livingrockBrick).requires((ItemLike)Items.VINE).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrockBrick)).save(recipeOutput, "botania:mossy_livingrock_bricks_vine");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.shimmerrock).requires((ItemLike)BotaniaBlocks.livingrock).requires((ItemLike)BotaniaBlocks.bifrostPerm).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.bifrostPerm)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BotaniaBlocks.shimmerwoodPlanks).requires((ItemLike)BotaniaBlocks.dreamwoodPlanks).requires((ItemLike)BotaniaBlocks.bifrostPerm).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.bifrostPerm)).unlockedBy("has_alt_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.rainbowRod)).save(recipeOutput);
        this.registerForQuartz(recipeOutput, "dark_quartz", (ItemLike)BotaniaItems.darkQuartz);
        this.registerForQuartz(recipeOutput, "mana_quartz", (ItemLike)BotaniaItems.manaQuartz);
        this.registerForQuartz(recipeOutput, "blaze_quartz", (ItemLike)BotaniaItems.blazeQuartz);
        this.registerForQuartz(recipeOutput, "lavender_quartz", (ItemLike)BotaniaItems.lavenderQuartz);
        this.registerForQuartz(recipeOutput, "red_quartz", (ItemLike)BotaniaItems.redQuartz);
        this.registerForQuartz(recipeOutput, "elf_quartz", (ItemLike)BotaniaItems.elfQuartz);
        this.registerForQuartz(recipeOutput, "sunny_quartz", (ItemLike)BotaniaItems.sunnyQuartz);
        this.registerForWood(recipeOutput, "livingwood");
        this.registerForWood(recipeOutput, "dreamwood");
        this.stairs((ItemLike)BotaniaBlocks.livingrockStairs, (ItemLike)BotaniaBlocks.livingrock).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.livingrockSlab, (ItemLike)BotaniaBlocks.livingrock).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.livingrockWall, (ItemLike)BotaniaBlocks.livingrock, 6).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.livingrockPolishedStairs, (ItemLike)BotaniaBlocks.livingrockPolished).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.livingrockPolishedSlab, (ItemLike)BotaniaBlocks.livingrockPolished).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.livingrockPolishedWall, (ItemLike)BotaniaBlocks.livingrockPolished, 6).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.livingrockBrickStairs, (ItemLike)BotaniaBlocks.livingrockBrick).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.livingrockBrickSlab, (ItemLike)BotaniaBlocks.livingrockBrick).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.livingrockBrickWall, (ItemLike)BotaniaBlocks.livingrockBrick, 6).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.livingrockBrickMossyStairs, (ItemLike)BotaniaBlocks.livingrockBrickMossy).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.livingrockBrickMossySlab, (ItemLike)BotaniaBlocks.livingrockBrickMossy).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.livingrockBrickMossyWall, (ItemLike)BotaniaBlocks.livingrockBrickMossy, 6).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.shimmerrockStairs, (ItemLike)BotaniaBlocks.shimmerrock).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.shimmerrockSlab, (ItemLike)BotaniaBlocks.shimmerrock).save(recipeOutput);
        this.stairs((ItemLike)BotaniaBlocks.shimmerwoodPlankStairs, (ItemLike)BotaniaBlocks.shimmerwoodPlanks).save(recipeOutput);
        this.slabShape((ItemLike)BotaniaBlocks.shimmerwoodPlankSlab, (ItemLike)BotaniaBlocks.shimmerwoodPlanks).save(recipeOutput);
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            this.registerForMetamorphic(recipeOutput, variant);
        }
        Item[] pavementIngredients = new Item[]{Items.AIR, Items.COAL, Items.LAPIS_LAZULI, Items.REDSTONE, Items.WHEAT, Items.SLIME_BALL};
        for (int i2 = 0; i2 < pavementIngredients.length; ++i2) {
            this.registerForPavement(recipeOutput, LibBlockNames.PAVEMENT_VARIANTS[i2], pavementIngredients[i2]);
        }
        this.wallShape((ItemLike)BotaniaBlocks.managlassPane, (ItemLike)BotaniaBlocks.manaGlass, 16).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.alfglassPane, (ItemLike)BotaniaBlocks.elfGlass, 16).save(recipeOutput);
        this.wallShape((ItemLike)BotaniaBlocks.bifrostPane, (ItemLike)BotaniaBlocks.bifrostPerm, 16).save(recipeOutput);
        List<Item> allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(BotaniaAPI::botaniaRL).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).toList();
        for (int i3 = 0; i3 < allAzulejos.size(); ++i3) {
            int resultIndex = (i3 + 1) % allAzulejos.size();
            String recipeName = "azulejo_" + resultIndex;
            if (resultIndex == 0) {
                recipeName = recipeName + "_alt";
            }
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)allAzulejos.get(resultIndex))).requires((ItemLike)allAzulejos.get(i3)).unlockedBy("has_azulejo", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.azulejo0)).group("botania:azulejo_cycling").save(recipeOutput, this.prefix(recipeName));
        }
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.blackBowtie, (ItemLike)BotaniaItems.whitePetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.blackTie, (ItemLike)BotaniaItems.orangePetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.redGlasses, (ItemLike)BotaniaItems.magentaPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.puffyScarf, (ItemLike)BotaniaItems.lightBluePetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.engineerGoggles, (ItemLike)BotaniaItems.yellowPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.eyepatch, (ItemLike)BotaniaItems.limePetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.wickedEyepatch, (ItemLike)BotaniaItems.pinkPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.redRibbons, (ItemLike)BotaniaItems.grayPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.pinkFlowerBud, (ItemLike)BotaniaItems.lightGrayPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.polkaDottedBows, (ItemLike)BotaniaItems.cyanPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.blueButterfly, (ItemLike)BotaniaItems.purplePetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.catEars, (ItemLike)BotaniaItems.bluePetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.witchPin, (ItemLike)BotaniaItems.brownPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.devilTail, (ItemLike)BotaniaItems.greenPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.kamuiEye, (ItemLike)BotaniaItems.redPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.googlyEyes, (ItemLike)BotaniaItems.blackPetal);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.fourLeafClover, (ItemLike)Items.WHITE_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.clockEye, (ItemLike)Items.ORANGE_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.unicornHorn, (ItemLike)Items.MAGENTA_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.devilHorns, (ItemLike)Items.LIGHT_BLUE_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.hyperPlus, (ItemLike)Items.YELLOW_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.botanistEmblem, (ItemLike)Items.LIME_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.ancientMask, (ItemLike)Items.PINK_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.eerieMask, (ItemLike)Items.GRAY_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.alienAntenna, (ItemLike)Items.LIGHT_GRAY_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.anaglyphGlasses, (ItemLike)Items.CYAN_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.orangeShades, (ItemLike)Items.PURPLE_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.grouchoGlasses, (ItemLike)Items.BLUE_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.thickEyebrows, (ItemLike)Items.BROWN_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.lusitanicShield, (ItemLike)Items.GREEN_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.tinyPotatoMask, (ItemLike)Items.RED_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.questgiverMark, (ItemLike)Items.BLACK_DYE);
        this.cosmeticBauble(recipeOutput, (ItemLike)BotaniaItems.thinkingHand, (ItemLike)BotaniaBlocks.tinyPotato);
    }

    protected void registerSimpleArmorSet(RecipeOutput recipeOutput, Ingredient item, String variant, Criterion<InventoryChangeTrigger.TriggerInstance> criterion) {
        Item helmet = this.getItemOrThrow(this.prefix(variant + "_helmet"));
        Item chestplate = this.getItemOrThrow(this.prefix(variant + "_chestplate"));
        Item leggings = this.getItemOrThrow(this.prefix(variant + "_leggings"));
        Item boots = this.getItemOrThrow(this.prefix(variant + "_boots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).define(Character.valueOf('S'), item).pattern("SSS").pattern("S S").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).define(Character.valueOf('S'), item).pattern("S S").pattern("SSS").pattern("SSS").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).define(Character.valueOf('S'), item).pattern("SSS").pattern("S S").pattern("S S").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).define(Character.valueOf('S'), item).pattern("S S").pattern("S S").unlockedBy("has_item", criterion).save(recipeOutput);
    }

    protected void registerToolSetRecipes(RecipeOutput recipeOutput, Ingredient item, Ingredient stick, Criterion<InventoryChangeTrigger.TriggerInstance> criterion, ItemLike sword, ItemLike pickaxe, ItemLike axe, ItemLike hoe, ItemLike shovel, ItemLike shears) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).define(Character.valueOf('S'), item).define(Character.valueOf('T'), stick).pattern("SSS").pattern(" T ").pattern(" T ").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).define(Character.valueOf('S'), item).define(Character.valueOf('T'), stick).pattern("S").pattern("T").pattern("T").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).define(Character.valueOf('S'), item).define(Character.valueOf('T'), stick).pattern("SS").pattern("ST").pattern(" T").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).define(Character.valueOf('S'), item).define(Character.valueOf('T'), stick).pattern("SS").pattern(" T").pattern(" T").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)sword).define(Character.valueOf('S'), item).define(Character.valueOf('T'), stick).pattern("S").pattern("S").pattern("T").unlockedBy("has_item", criterion).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shears).define(Character.valueOf('S'), item).pattern(" S").pattern("S ").unlockedBy("has_item", criterion).save(recipeOutput);
    }

    protected void registerTerrasteelUpgradeRecipe(RecipeOutput recipeOutput, ItemLike output, ItemLike upgradedInput, ItemLike runeInput) {
        WrapperRecipeBuilder.wrap(ArmorUpgradeRecipe.SERIALIZER, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).define(Character.valueOf('T'), (ItemLike)BotaniaItems.livingwoodTwig).define(Character.valueOf('S'), BotaniaTags.Items.INGOTS_TERRASTEEL).define(Character.valueOf('R'), runeInput).define(Character.valueOf('A'), upgradedInput).pattern("TRT").pattern("SAS").pattern(" S ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL)).unlockedBy("has_prev_tier", CraftingRecipeProvider.conditionsFromItem(upgradedInput))).save(recipeOutput);
    }

    public static void registerRedStringBlock(RecipeOutput recipeOutput, ItemLike output, Ingredient input, Criterion<InventoryChangeTrigger.TriggerInstance> criterion) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).define(Character.valueOf('R'), (ItemLike)BotaniaBlocks.livingrock).define(Character.valueOf('S'), (ItemLike)BotaniaItems.redString).define(Character.valueOf('M'), input).pattern("RRR").pattern("RMS").pattern("RRR").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.redString)).unlockedBy("has_base_block", criterion).save(recipeOutput);
    }

    protected void createFloatingFlowerRecipe(RecipeOutput recipeOutput, ItemLike input) {
        ResourceLocation inputName = BuiltInRegistries.ITEM.getKey((Object)input.asItem());
        Item output = this.getItemOrThrow(ResourceLocation.fromNamespaceAndPath((String)inputName.getNamespace(), (String)("floating_" + inputName.getPath())));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output).requires(BotaniaTags.Items.FLOATING_FLOWERS).requires(input).group("botania:floating_flower").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).save(recipeOutput);
    }

    protected void deconstruct(RecipeOutput recipeOutput, ItemLike output, ItemLike input, String name) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(output)).requires(input).save(recipeOutput, this.prefix("conversions/" + name));
    }

    protected void deconstruct(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input, String name) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(output)).requires(input).save(recipeOutput, this.prefix("conversions/" + name));
    }

    protected void deconstructPetalBlock(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(output)).requires(input).group("botania:petal_block_deconstruct").save(recipeOutput, this.prefix("conversions/" + BuiltInRegistries.ITEM.getKey((Object)input.asItem()).getPath() + "_deconstruct"));
    }

    protected void recombineSlab(RecipeOutput recipeOutput, ItemLike fullBlock, ItemLike slab) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fullBlock).define(Character.valueOf('Q'), slab).pattern("QQ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(slab)).save(recipeOutput, this.prefix("slab_recombine/" + BuiltInRegistries.ITEM.getKey((Object)fullBlock.asItem()).getPath()));
    }

    protected ShapedRecipeBuilder petalApothecary(ItemLike block, ItemLike apothecary) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)apothecary).define(Character.valueOf('P'), BotaniaTags.Items.PETALS).define(Character.valueOf('C'), block).pattern("CPC").pattern(" C ").pattern("CCC");
    }

    protected void registerForQuartz(RecipeOutput recipeOutput, String variant, ItemLike baseItem) {
        Block base = this.getBlockOrThrow(this.prefix(variant));
        Block slab = this.getBlockOrThrow(this.prefix(variant + "_slab"));
        Block stairs = this.getBlockOrThrow(this.prefix(variant + "_stairs"));
        Block chiseled = this.getBlockOrThrow(this.prefix("chiseled_" + variant));
        Block pillar = this.getBlockOrThrow(this.prefix(variant + "_pillar"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)base).define(Character.valueOf('Q'), baseItem).pattern("QQ").pattern("QQ").group("botania:quartz_block").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(baseItem)).save(recipeOutput);
        this.stairs((ItemLike)stairs, (ItemLike)base).group("botania:quartz_stairs").save(recipeOutput);
        this.slabShape((ItemLike)slab, (ItemLike)base).group("botania:quartz_slab").save(recipeOutput);
        this.pillar((ItemLike)pillar, (ItemLike)base).group("botania:quartz_pillar").save(recipeOutput);
        this.chiseled((ItemLike)chiseled, (ItemLike)slab).group("botania:quartz_chiseled").unlockedBy("has_base_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)base)).save(recipeOutput);
    }

    protected void registerForWood(RecipeOutput recipeOutput, String variant) {
        TagKey<Item> tag = variant.contains("livingwood") ? BotaniaTags.Items.LIVINGWOOD_LOGS : BotaniaTags.Items.DREAMWOOD_LOGS;
        Block log = this.getBlockOrThrow(this.prefix(variant + "_log"));
        Block wood = this.getBlockOrThrow(this.prefix(variant));
        Block strippedLog = this.getBlockOrThrow(this.prefix("stripped_" + variant + "_log"));
        Block strippedWood = this.getBlockOrThrow(this.prefix("stripped_" + variant));
        Block glimmeringLog = this.getBlockOrThrow(this.prefix("glimmering_" + variant + "_log"));
        Block glimmeringWood = this.getBlockOrThrow(this.prefix("glimmering_" + variant));
        Block glimmeringStrippedLog = this.getBlockOrThrow(this.prefix("glimmering_stripped_" + variant + "_log"));
        Block glimmeringStrippedWood = this.getBlockOrThrow(this.prefix("glimmering_stripped_" + variant));
        Block stairs = this.getBlockOrThrow(this.prefix(variant + "_stairs"));
        Block slab = this.getBlockOrThrow(this.prefix(variant + "_slab"));
        Block wall = this.getBlockOrThrow(this.prefix(variant + "_wall"));
        Block strippedStairs = this.getBlockOrThrow(this.prefix("stripped_" + variant + "_stairs"));
        Block strippedSlab = this.getBlockOrThrow(this.prefix("stripped_" + variant + "_slab"));
        Block strippedWall = this.getBlockOrThrow(this.prefix("stripped_" + variant + "_wall"));
        Block planks = this.getBlockOrThrow(this.prefix(variant + "_planks"));
        Block planksStairs = this.getBlockOrThrow(this.prefix(variant + "_planks_stairs"));
        Block planksSlab = this.getBlockOrThrow(this.prefix(variant + "_planks_slab"));
        Block mossyPlanks = this.getBlockOrThrow(this.prefix("mossy_" + variant + "_planks"));
        Block framed = this.getBlockOrThrow(this.prefix("framed_" + variant));
        Block patternFramed = this.getBlockOrThrow(this.prefix("pattern_framed_" + variant));
        Block fence = this.getBlockOrThrow(this.prefix(variant + "_fence"));
        Block fenceGate = this.getBlockOrThrow(this.prefix(variant + "_fence_gate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)4).requires(tag).group("planks").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(tag)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)3).group("wood").unlockedBy("has_log", CraftingRecipeProvider.conditionsFromItem((ItemLike)log)).define(Character.valueOf('#'), (ItemLike)log).pattern("##").pattern("##").save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)strippedWood, (int)3).group("wood").unlockedBy("has_log", CraftingRecipeProvider.conditionsFromItem((ItemLike)strippedLog)).define(Character.valueOf('#'), (ItemLike)strippedLog).pattern("##").pattern("##").save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glimmeringLog).group("botania:glimmering_" + variant).requires((ItemLike)log).requires((ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)log)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glimmeringWood).group("botania:glimmering_" + variant).requires((ItemLike)wood).requires((ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)wood)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glimmeringStrippedLog).group("botania:glimmering_" + variant).requires((ItemLike)strippedLog).requires((ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)strippedLog)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glimmeringStrippedWood).group("botania:glimmering_" + variant).requires((ItemLike)strippedWood).requires((ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)strippedWood)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glimmeringWood, (int)3).group("botania:glimmering_" + variant).unlockedBy("has_log", CraftingRecipeProvider.conditionsFromItem((ItemLike)glimmeringLog)).define(Character.valueOf('#'), (ItemLike)glimmeringLog).pattern("##").pattern("##").save(recipeOutput, this.prefix("glimmering_" + variant + "_from_log"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glimmeringStrippedWood, (int)3).group("botania:glimmering_" + variant).unlockedBy("has_log", CraftingRecipeProvider.conditionsFromItem((ItemLike)glimmeringStrippedLog)).define(Character.valueOf('#'), (ItemLike)glimmeringStrippedLog).pattern("##").pattern("##").save(recipeOutput, this.prefix("glimmering_stripped_" + variant + "_from_log"));
        this.stairs((ItemLike)stairs, (ItemLike)wood).save(recipeOutput);
        this.slabShape((ItemLike)slab, (ItemLike)wood).save(recipeOutput);
        this.wallShape((ItemLike)wall, (ItemLike)wood, 6).save(recipeOutput);
        this.fence((ItemLike)fence, (ItemLike)planks).save(recipeOutput);
        this.fenceGate((ItemLike)fenceGate, (ItemLike)planks).save(recipeOutput);
        this.stairs((ItemLike)strippedStairs, (ItemLike)strippedWood).save(recipeOutput);
        this.slabShape((ItemLike)strippedSlab, (ItemLike)strippedWood).save(recipeOutput);
        this.wallShape((ItemLike)strippedWall, (ItemLike)strippedWood, 6).save(recipeOutput);
        this.stairs((ItemLike)planksStairs, (ItemLike)planks).save(recipeOutput);
        this.slabShape((ItemLike)planksSlab, (ItemLike)planks).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)mossyPlanks).requires((ItemLike)planks).requires((ItemLike)Items.MOSS_BLOCK).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)planks)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)mossyPlanks).requires((ItemLike)planks).requires((ItemLike)Items.VINE).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)planks)).save(recipeOutput, this.prefix("mossy_" + variant + "_planks_vine"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)framed, (int)4).define(Character.valueOf('W'), (ItemLike)planks).pattern("W W").pattern("W W").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)planks)).save(recipeOutput);
        this.ringShape((ItemLike)patternFramed, (ItemLike)planks).save(recipeOutput);
    }

    private void registerForPavement(RecipeOutput recipeOutput, String color, Item mainInput) {
        String baseName = color + "_pavement";
        Block base = this.getBlockOrThrow(this.prefix(baseName));
        Block stair = this.getBlockOrThrow(this.prefix(baseName + "_stairs"));
        Block slab = this.getBlockOrThrow(this.prefix(baseName + "_slab"));
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)base, (int)3).requires((ItemLike)BotaniaBlocks.livingrock).requires((ItemLike)Items.COBBLESTONE).requires((ItemLike)Items.GRAVEL).group("botania:pavement").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaBlocks.livingrock));
        if (mainInput != Items.AIR) {
            builder.requires((ItemLike)mainInput);
        }
        builder.save(recipeOutput);
        this.slabShape((ItemLike)slab, (ItemLike)base).group("botania:pavement_slab").save(recipeOutput);
        this.stairs((ItemLike)stair, (ItemLike)base).group("botania:pavement_stairs").save(recipeOutput);
    }

    private void registerForMetamorphic(RecipeOutput recipeOutput, String variant) {
        Block base = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_stone"));
        Block slab = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_stone_slab"));
        Block stair = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_stone_stairs"));
        Block wall = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_stone_wall"));
        Block brick = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_bricks"));
        Block brickSlab = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_bricks_slab"));
        Block brickStair = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_bricks_stairs"));
        Block brickWall = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_bricks_wall"));
        Block chiseledBrick = this.getBlockOrThrow(this.prefix("chiseled_metamorphic_" + variant + "_bricks"));
        Block cobble = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_cobblestone"));
        Block cobbleSlab = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_cobblestone_slab"));
        Block cobbleStair = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_cobblestone_stairs"));
        Block cobbleWall = this.getBlockOrThrow(this.prefix("metamorphic_" + variant + "_cobblestone_wall"));
        Criterion<InventoryChangeTrigger.TriggerInstance> marimorphosis = CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaFlowerBlocks.marimorphosis);
        this.slabShape((ItemLike)slab, (ItemLike)base).group("botania:metamorphic_stone_slab").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.stairs((ItemLike)stair, (ItemLike)base).group("botania:metamorphic_stone_stairs").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.wallShape((ItemLike)wall, (ItemLike)base, 6).group("botania:metamorphic_stone_wall").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.brick((ItemLike)brick, (ItemLike)base).group("botania:metamorphic_brick").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.slabShape((ItemLike)brickSlab, (ItemLike)brick).group("botania:metamorphic_brick_slab").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.stairs((ItemLike)brickStair, (ItemLike)brick).group("botania:metamorphic_brick_stairs").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.wallShape((ItemLike)brickWall, (ItemLike)brick, 6).group("botania:metamorphic_brick_wall").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.chiseled((ItemLike)chiseledBrick, (ItemLike)brickSlab).unlockedBy("has_base_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)brick)).unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.slabShape((ItemLike)cobbleSlab, (ItemLike)cobble).group("botania:metamorphic_cobble_slab").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.stairs((ItemLike)cobbleStair, (ItemLike)cobble).group("botania:metamorphic_cobble_stairs").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
        this.wallShape((ItemLike)cobbleWall, (ItemLike)cobble, 6).group("botania:metamorphic_cobble_wall").unlockedBy("has_flower_item", marimorphosis).save(recipeOutput);
    }

    private ShapedRecipeBuilder compression(ItemLike output, TagKey<Item> input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)(output instanceof Block ? RecipeCategory.BUILDING_BLOCKS : RecipeCategory.MISC), (ItemLike)output).define(Character.valueOf('I'), input).pattern("III").pattern("III").pattern("III").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromTag(input));
    }

    protected ShapedRecipeBuilder compression(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)(output instanceof Block ? RecipeCategory.BUILDING_BLOCKS : RecipeCategory.MISC), (ItemLike)output).define(Character.valueOf('I'), input).pattern("III").pattern("III").pattern("III").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input));
    }

    protected ShapedRecipeBuilder brick(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).define(Character.valueOf('Q'), input).pattern("QQ").pattern("QQ");
    }

    protected ShapedRecipeBuilder stairs(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).define(Character.valueOf('Q'), input).pattern("Q  ").pattern("QQ ").pattern("QQQ");
    }

    protected ShapedRecipeBuilder slabShape(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).define(Character.valueOf('Q'), input).pattern("QQQ");
    }

    protected ShapedRecipeBuilder pillar(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)2).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).define(Character.valueOf('Q'), input).pattern("Q").pattern("Q");
    }

    protected ShapedRecipeBuilder chiseled(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).define(Character.valueOf('Q'), input).pattern("Q").pattern("Q");
    }

    protected ShapedRecipeBuilder wallShape(ItemLike output, ItemLike input, int amount) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)amount).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).define(Character.valueOf('B'), input).pattern("BBB").pattern("BBB");
    }

    protected ShapedRecipeBuilder fence(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)3).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).group("wooden_fence").define(Character.valueOf('B'), input).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("BSB").pattern("BSB");
    }

    protected ShapedRecipeBuilder fenceGate(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output, (int)1).unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input)).group("wooden_fence_gate").define(Character.valueOf('B'), input).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("SBS").pattern("SBS");
    }

    protected ShapedRecipeBuilder ringShape(ItemLike output, ItemLike input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).define(Character.valueOf('W'), input).pattern(" W ").pattern("W W").pattern(" W ").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem(input));
    }

    protected void cosmeticBauble(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).define(Character.valueOf('P'), input).define(Character.valueOf('S'), (ItemLike)BotaniaItems.manaString).pattern("PPP").pattern("PSP").pattern("PPP").group("botania:cosmetic_bauble").unlockedBy("has_item", CraftingRecipeProvider.conditionsFromItem((ItemLike)BotaniaItems.manaString)).save(recipeOutput);
    }

    protected void specialRecipe(RecipeOutput recipeOutput, Function<CraftingBookCategory, Recipe<?>> factory, CraftingBookCategory category) {
        BotaniaSpecialRecipeBuilder.special(factory, category).save(recipeOutput);
    }

    protected Block getBlockOrThrow(ResourceLocation location) {
        return (Block)BuiltInRegistries.BLOCK.getOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location));
    }

    protected Item getItemOrThrow(ResourceLocation location) {
        return (Item)BuiltInRegistries.ITEM.getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location));
    }

    public String getName() {
        return "Botania crafting recipes";
    }
}

