/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;

public class PottedPlantModelProvider
implements DataProvider {
    private final PackOutput packOutput;

    public PottedPlantModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<Tuple> jsons = new ArrayList<Tuple>();
        for (Block b : BuiltInRegistries.BLOCK) {
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)b);
            if (!"botania".equals(blockId.getNamespace()) || !(b instanceof FlowerPotBlock)) continue;
            String name = blockId.getPath();
            String nonPotted = name.replace("potted_", "");
            JsonObject obj = new JsonObject();
            obj.addProperty("parent", "minecraft:block/flower_pot_cross");
            JsonObject textures = new JsonObject();
            textures.addProperty("plant", "botania:block/" + nonPotted);
            obj.add("textures", (JsonElement)textures);
            jsons.add(new Tuple((Object)name, (Object)obj));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        PackOutput.PathProvider blocks = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models/block");
        for (Tuple pair : jsons) {
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)pair.getB()), (Path)blocks.json(BotaniaAPI.botaniaRL((String)pair.getA()))));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation resourceLocation) {
        return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation));
    }

    @NotNull
    public String getName() {
        return "Botania potted plant models";
    }
}

