/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;

public class LooniumStructureLootProvider
implements DataProvider {
    public static final EnumSet<VillageLoot> PLAINS_VILLAGE_LOOT = EnumSet.of(VillageLoot.CARTOGRAPHER, VillageLoot.FISHER, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> DESERT_VILLAGE_LOOT = EnumSet.of(VillageLoot.TEMPLE, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> SAVANNA_VILLAGE_LOOT = EnumSet.of(VillageLoot.BUTCHER, VillageLoot.CARTOGRAPHER, VillageLoot.MASON, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> SNOWY_VILLAGE_LOOT = EnumSet.of(VillageLoot.ARMORER, VillageLoot.CARTOGRAPHER, VillageLoot.SHEPHERD, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> TAIGA_VILLAGE_LOOT = EnumSet.of(VillageLoot.CARTOGRAPHER, VillageLoot.FLETCHER, VillageLoot.TANNERY, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registryLookupFuture;

    public LooniumStructureLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables/loonium");
        this.registryLookupFuture = registryLookupFuture;
    }

    public static ResourceKey<LootTable> getStructureId(ResourceKey<Structure> structureKey) {
        return LooniumStructureLootProvider.getStructureId(structureKey.location());
    }

    public static ResourceKey<LootTable> getStructureId(ResourceLocation structureId) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BotaniaAPI.botaniaRL("%s/%s".formatted(structureId.getNamespace(), structureId.getPath())));
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.registryLookupFuture.thenCompose(registryLookup -> this.run(cache, (HolderLookup.Provider)registryLookup));
    }

    private CompletableFuture<?> run(@NotNull CachedOutput cache, HolderLookup.Provider registries) {
        HashMap<ResourceKey<LootTable>, LootTable.Builder> tables = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();
        this.addLootTables(tables);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(tables.size());
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.json(((ResourceKey)e.getKey()).location());
            LootTable.Builder builder = (LootTable.Builder)e.getValue();
            LootTable lootTable = builder.setParamSet(LootContextParamSets.ALL_PARAMS).build();
            output.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, (Codec)LootTable.DIRECT_CODEC, (Object)lootTable, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addLootTables(Map<ResourceKey<LootTable>, LootTable.Builder> tables) {
        tables.put((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BotaniaAPI.botaniaRL("default")), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.ANCIENT_CITY), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.ANCIENT_CITY).setWeight(9)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.ANCIENT_CITY_ICE_BOX).setWeight(1))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.BASTION_REMNANT), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.BASTION_BRIDGE).setWeight(1)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.BASTION_HOGLIN_STABLE).setWeight(1)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.BASTION_TREASURE).setWeight(1)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.BASTION_OTHER).setWeight(7))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.BURIED_TREASURE), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.BURIED_TREASURE));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.DESERT_PYRAMID), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.DESERT_PYRAMID).setWeight(37)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY).setWeight(2)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.END_CITY), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.END_CITY_TREASURE).setWeight(49)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ELYTRA))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.FORTRESS), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.JUNGLE_TEMPLE), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.JUNGLE_TEMPLE).setWeight(9)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.JUNGLE_TEMPLE_DISPENSER))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.MINESHAFT), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.MINESHAFT_MESA), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.OCEAN_MONUMENT), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)EntityType.ELDER_GUARDIAN.getDefaultLootTable()).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WET_SPONGE))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.OCEAN_RUIN_COLD), LooniumStructureLootProvider.buildOceanRuinLootTable((ResourceKey<LootTable>)BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.OCEAN_RUIN_WARM), LooniumStructureLootProvider.buildOceanRuinLootTable((ResourceKey<LootTable>)BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.PILLAGER_OUTPOST), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.PILLAGER_OUTPOST));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_DESERT), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_JUNGLE), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_MOUNTAIN), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_NETHER), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_OCEAN), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_STANDARD), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.RUINED_PORTAL_SWAMP), LooniumStructureLootProvider.buildDelegateLootTable((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.SHIPWRECK), LooniumStructureLootProvider.buildShipwreckLootTable());
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.SHIPWRECK_BEACHED), LooniumStructureLootProvider.buildShipwreckLootTable());
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.STRONGHOLD), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.STRONGHOLD_CORRIDOR).setWeight(4)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.STRONGHOLD_CROSSING).setWeight(6)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.STRONGHOLD_LIBRARY).setWeight(3))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.TRAIL_RUINS), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON).setWeight(9)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.VILLAGE_PLAINS), LooniumStructureLootProvider.buildVillageLootTable((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_PLAINS_HOUSE, PLAINS_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.VILLAGE_DESERT), LooniumStructureLootProvider.buildVillageLootTable((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_DESERT_HOUSE, DESERT_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.VILLAGE_SAVANNA), LooniumStructureLootProvider.buildVillageLootTable((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SAVANNA_HOUSE, SAVANNA_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.VILLAGE_SNOWY), LooniumStructureLootProvider.buildVillageLootTable((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SNOWY_HOUSE, SNOWY_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.VILLAGE_TAIGA), LooniumStructureLootProvider.buildVillageLootTable((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TAIGA_HOUSE, TAIGA_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.WOODLAND_MANSION), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.WOODLAND_MANSION).setWeight(99)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TOTEM_OF_UNDYING).setWeight(1))));
    }

    public static LootTable.Builder buildVillageLootTable(ResourceKey<LootTable> house, Set<VillageLoot> villageLootSet) {
        LootPool.Builder lootPool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(house).setWeight(3));
        for (VillageLoot loot : villageLootSet) {
            lootPool.add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(loot.lootTable));
        }
        return LootTable.lootTable().withPool(lootPool);
    }

    @NotNull
    public static LootTable.Builder buildShipwreckLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.SHIPWRECK_MAP)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.SHIPWRECK_SUPPLY)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.SHIPWRECK_TREASURE)));
    }

    @NotNull
    public static LootTable.Builder buildDelegateLootTable(ResourceKey<LootTable> reference) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(reference)));
    }

    @NotNull
    public static LootTable.Builder buildOceanRuinLootTable(ResourceKey<LootTable> archaeology) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.UNDERWATER_RUIN_BIG)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.UNDERWATER_RUIN_SMALL).setWeight(8)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(archaeology)));
    }

    @NotNull
    public String getName() {
        return "Structure-specific loot tables for the Loonium";
    }

    public static enum VillageLoot {
        WEAPONSMITH((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_WEAPONSMITH),
        TOOLSMITH((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TOOLSMITH),
        ARMORER((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_ARMORER),
        CARTOGRAPHER((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_CARTOGRAPHER),
        MASON((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_MASON),
        SHEPHERD((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_SHEPHERD),
        BUTCHER((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_BUTCHER),
        FLETCHER((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_FLETCHER),
        FISHER((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_FISHER),
        TANNERY((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TANNERY),
        TEMPLE((ResourceKey<LootTable>)BuiltInLootTables.VILLAGE_TEMPLE);

        public final ResourceKey<LootTable> lootTable;

        private VillageLoot(ResourceKey<LootTable> lootTable) {
            this.lootTable = lootTable;
        }
    }
}

