/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.loot.BotaniaLootTables;

public class LooniumStructureConfigurationProvider
implements DataProvider {
    public static final ResourceLocation LOONIUM_MODIFIER_DAMAGE = BotaniaAPI.botaniaRL("loonium_modifier_damage");
    public static final ResourceLocation LOONIUM_MODIFIER_HEALTH = BotaniaAPI.botaniaRL("loonium_modifier_health");
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registryLookupFuture;

    public LooniumStructureConfigurationProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loonium_config");
        this.registryLookupFuture = registryLookupFuture;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.registryLookupFuture.thenCompose(registryLookup -> this.run(cache, (HolderLookup.Provider)registryLookup));
    }

    private CompletableFuture<?> run(@NotNull CachedOutput cache, HolderLookup.Provider registries) {
        HashMap<ResourceLocation, LooniumStructureConfiguration> configs = new HashMap<ResourceLocation, LooniumStructureConfiguration>();
        this.addConfigs(configs);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(configs.size());
        for (Map.Entry e : configs.entrySet()) {
            Path path = this.pathProvider.json((ResourceLocation)e.getKey());
            LooniumStructureConfiguration config = (LooniumStructureConfiguration)e.getValue();
            JsonElement jsonTree = (JsonElement)LooniumStructureConfiguration.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow();
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addConfigs(Map<ResourceLocation, LooniumStructureConfiguration> configs) {
        ResourceLocation defaultConfigId = LooniumStructureConfiguration.DEFAULT_CONFIG_ID;
        configs.put(defaultConfigId, LooniumStructureConfigurationProvider.getDefaultConfig());
        configs.put(BuiltinStructures.ANCIENT_CITY.location(), LooniumStructureConfigurationProvider.getConfigAncientCity(defaultConfigId));
        configs.put(BuiltinStructures.BASTION_REMNANT.location(), LooniumStructureConfigurationProvider.getConfigBastionRemnant(defaultConfigId));
        configs.put(BuiltinStructures.DESERT_PYRAMID.location(), LooniumStructureConfigurationProvider.getConfigDesertPyramid(defaultConfigId));
        configs.put(BuiltinStructures.END_CITY.location(), LooniumStructureConfigurationProvider.getConfigEndCity(defaultConfigId));
        configs.put(BuiltinStructures.FORTRESS.location(), LooniumStructureConfigurationProvider.getConfigFortress(defaultConfigId));
        configs.put(BuiltinStructures.JUNGLE_TEMPLE.location(), LooniumStructureConfigurationProvider.getConfigJungleTemple(defaultConfigId));
        configs.put(BuiltinStructures.OCEAN_MONUMENT.location(), LooniumStructureConfigurationProvider.getConfigOceanMonument(defaultConfigId));
        ResourceLocation oceanRuinId = BotaniaAPI.botaniaRL("ocean_ruins");
        configs.put(oceanRuinId, LooniumStructureConfiguration.forParent(defaultConfigId).boundingBoxType(StructureSpawnOverride.BoundingBoxType.STRUCTURE).build());
        configs.put(BuiltinStructures.OCEAN_RUIN_COLD.location(), LooniumStructureConfigurationProvider.getConfigOceanRuinCold(oceanRuinId));
        configs.put(BuiltinStructures.OCEAN_RUIN_WARM.location(), LooniumStructureConfigurationProvider.getConfigOceanRuinWarm(oceanRuinId));
        configs.put(BuiltinStructures.PILLAGER_OUTPOST.location(), LooniumStructureConfigurationProvider.getConfigPillagerOutpost(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_DESERT.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalDesert(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_JUNGLE.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalJungle(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_MOUNTAIN.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalMountain(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_NETHER.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalNether(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_OCEAN.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalOcean(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_STANDARD.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalStandard(defaultConfigId));
        configs.put(BuiltinStructures.RUINED_PORTAL_SWAMP.location(), LooniumStructureConfigurationProvider.getConfigRuinedPortalSwamp(defaultConfigId));
        configs.put(BuiltinStructures.SHIPWRECK.location(), LooniumStructureConfigurationProvider.getConfigShipwreck(defaultConfigId));
        configs.put(BuiltinStructures.SHIPWRECK_BEACHED.location(), LooniumStructureConfiguration.forParent(BuiltinStructures.SHIPWRECK.location()).build());
        configs.put(BuiltinStructures.STRONGHOLD.location(), LooniumStructureConfigurationProvider.getConfigStronghold(defaultConfigId));
        configs.put(BuiltinStructures.TRAIL_RUINS.location(), LooniumStructureConfigurationProvider.getConfigTrailRuins(defaultConfigId));
        ResourceLocation villageId = BotaniaAPI.botaniaRL("village");
        configs.put(villageId, LooniumStructureConfiguration.forParent(defaultConfigId).boundingBoxType(StructureSpawnOverride.BoundingBoxType.STRUCTURE).build());
        configs.put(BuiltinStructures.VILLAGE_DESERT.location(), LooniumStructureConfigurationProvider.getConfigVillageDesert(villageId));
        configs.put(BuiltinStructures.VILLAGE_PLAINS.location(), LooniumStructureConfigurationProvider.getConfigVillagePlains(villageId));
        configs.put(BuiltinStructures.VILLAGE_SAVANNA.location(), LooniumStructureConfigurationProvider.getConfigVillageSavanna(villageId));
        configs.put(BuiltinStructures.VILLAGE_SNOWY.location(), LooniumStructureConfigurationProvider.getConfigVillageSnowy(villageId));
        configs.put(BuiltinStructures.VILLAGE_TAIGA.location(), LooniumStructureConfigurationProvider.getConfigVillageTaiga(villageId));
        configs.put(BuiltinStructures.WOODLAND_MANSION.location(), LooniumStructureConfigurationProvider.getConfigWoodlandMansion(defaultConfigId));
    }

    public static LooniumStructureConfiguration getDefaultConfig() {
        return LooniumStructureConfiguration.builder().manaCost(35000).maxNearbyMobs(10).boundingBoxType(StructureSpawnOverride.BoundingBoxType.PIECE).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 529).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).attributeModifiers(new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH, (Holder<Attribute>)Attributes.MAX_HEALTH, 2.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 1.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, true)).build();
    }

    public static LooniumStructureConfiguration getConfigAncientCity(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 40).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 80).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 410).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 60).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 400).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 200).build()).build();
    }

    public static LooniumStructureConfiguration getConfigBastionRemnant(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getPiglinSpawnData(450, BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT, false, false), LooniumMobSpawnData.entityWeight(EntityType.PIGLIN_BRUTE, 50).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD).attributeModifiers(new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH, (Holder<Attribute>)Attributes.MAX_HEALTH, 1.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 1.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).build(), LooniumMobSpawnData.entityWeight(EntityType.HOGLIN, 300).spawnAsAdult().build()).build();
    }

    public static LooniumStructureConfiguration getConfigDesertPyramid(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 50).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 40).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 360).build()).build();
    }

    public static LooniumStructureConfiguration getConfigEndCity(ResourceLocation parentId) {
        LooniumMobEffectToApply[] creeperEffects = new LooniumMobEffectToApply[]{LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).duration(100).build(), LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).duration(100).build(), LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.SLOW_FALLING).duration(400).build()};
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.SHULKER, 100).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(true, true)).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 300).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, creeperEffects), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, creeperEffects), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 300).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 300).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_END_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 300).build()).effectsToApply(LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).build(), LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).build(), LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.SLOW_FALLING).build()).build();
    }

    public static LooniumStructureConfiguration getConfigFortress(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.BLAZE, 300).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumMobSpawnData.entityWeight(EntityType.WITHER_SKELETON, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 400).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build()).build();
    }

    public static LooniumStructureConfiguration getConfigJungleTemple(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 300).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 300).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanMonument(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.GUARDIAN, 200).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 320).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanRuinCold(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 40).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 360).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanRuinWarm(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 40).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 360).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigPillagerOutpost(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).boundingBoxType(StructureSpawnOverride.BoundingBoxType.STRUCTURE).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.PILLAGER, 900).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(), LooniumMobSpawnData.entityWeight(EntityType.VINDICATOR, 175).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(), LooniumMobSpawnData.entityWeight(EntityType.EVOKER, 25).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 200).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 200).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 200).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalDesert(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 50).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 360).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalJungle(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 250).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 50).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalMountain(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 529).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SILVERFISH, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalNether(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 125).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(500, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, false), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 200).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 10).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 90).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalOcean(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, true, true), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 360).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalStandard(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 59).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 106).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalSwamp(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ZOGLIN, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIFIED_PIGLIN, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 400).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 100).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 50).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 250).build()).build();
    }

    public static LooniumStructureConfiguration getConfigShipwreck(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 320).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigStronghold(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 80).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 50).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 400).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 400).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.SILVERFISH, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 400).build()).build();
    }

    public static LooniumStructureConfiguration getConfigTrailRuins(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 59).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 106).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 49).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 49).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 509).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageDesert(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE_VILLAGER, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillagePlains(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE_VILLAGER, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageSavanna(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 30).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.HUSK, 30).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE_VILLAGER, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageSnowy(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE_VILLAGER, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 529).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageTaiga(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.DROWNED, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE_VILLAGER, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.STRAY, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigWoodlandMansion(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.ENDERMAN, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.VINDICATOR, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(), LooniumMobSpawnData.entityWeight(EntityType.PILLAGER, 200).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(), LooniumMobSpawnData.entityWeight(EntityType.EVOKER, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 150).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.ZOMBIE, 50).spawnAsBaby().equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.BOGGED, 20).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.SKELETON, 180).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.CAVE_SPIDER, 30).build(), LooniumMobSpawnData.entityWeight(EntityType.SPIDER, 270).build()).build();
    }

    public static LooniumMobEffectToApply[] getStandardEffects(boolean withWaterBreathing, boolean withFireResistance) {
        LooniumMobEffectToApply[] looniumMobEffectToApplyArray;
        if (withFireResistance) {
            if (withWaterBreathing) {
                LooniumMobEffectToApply[] looniumMobEffectToApplyArray2 = new LooniumMobEffectToApply[3];
                looniumMobEffectToApplyArray2[0] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).build();
                looniumMobEffectToApplyArray2[1] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).build();
                looniumMobEffectToApplyArray = looniumMobEffectToApplyArray2;
                looniumMobEffectToApplyArray2[2] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.WATER_BREATHING).build();
            } else {
                LooniumMobEffectToApply[] looniumMobEffectToApplyArray3 = new LooniumMobEffectToApply[2];
                looniumMobEffectToApplyArray3[0] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).build();
                looniumMobEffectToApplyArray = looniumMobEffectToApplyArray3;
                looniumMobEffectToApplyArray3[1] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).build();
            }
        } else if (withWaterBreathing) {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray4 = new LooniumMobEffectToApply[2];
            looniumMobEffectToApplyArray4[0] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray4;
            looniumMobEffectToApplyArray4[1] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.WATER_BREATHING).build();
        } else {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray5 = new LooniumMobEffectToApply[1];
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray5;
            looniumMobEffectToApplyArray5[0] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).build();
        }
        return looniumMobEffectToApplyArray;
    }

    public static LooniumMobEffectToApply[] getCreeperEffects(boolean withWaterBreathing) {
        LooniumMobEffectToApply[] looniumMobEffectToApplyArray;
        if (withWaterBreathing) {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray2 = new LooniumMobEffectToApply[3];
            looniumMobEffectToApplyArray2[0] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).duration(100).build();
            looniumMobEffectToApplyArray2[1] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).duration(100).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray2;
            looniumMobEffectToApplyArray2[2] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.WATER_BREATHING).build();
        } else {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray3 = new LooniumMobEffectToApply[2];
            looniumMobEffectToApplyArray3[0] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).duration(100).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray3;
            looniumMobEffectToApplyArray3[1] = LooniumMobEffectToApply.effect((Holder<MobEffect>)MobEffects.REGENERATION).duration(100).build();
        }
        return looniumMobEffectToApplyArray;
    }

    public static LooniumMobSpawnData getCreeperSpawnData(int weight, boolean charged, LooniumMobEffectToApply ... creeperEffects) {
        CompoundTag chargedCreeperNbt;
        if (charged) {
            chargedCreeperNbt = new CompoundTag();
            chargedCreeperNbt.putBoolean("powered", true);
        } else {
            chargedCreeperNbt = null;
        }
        return LooniumMobSpawnData.entityWeight(EntityType.CREEPER, weight).nbt(chargedCreeperNbt).effectsToApply(creeperEffects).build();
    }

    public static LooniumMobSpawnData getPiglinSpawnData(int weight, ResourceKey<LootTable> equipmentTable, boolean needWaterBreathing, boolean zombificationImmune) {
        CompoundTag piglinNbt = new CompoundTag();
        if (zombificationImmune) {
            piglinNbt.putBoolean("IsImmuneToZombification", true);
        }
        Brain piglinBrain = Brain.provider(List.of(MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.ADMIRING_DISABLED, MemoryModuleType.ATE_RECENTLY), List.of()).makeBrain(new Dynamic((DynamicOps)NbtOps.INSTANCE));
        piglinBrain.setMemory(MemoryModuleType.UNIVERSAL_ANGER, (Object)true);
        piglinBrain.setMemory(MemoryModuleType.ADMIRING_DISABLED, (Object)true);
        piglinBrain.setMemory(MemoryModuleType.ATE_RECENTLY, (Object)true);
        DataResult dataResult = piglinBrain.serializeStart((DynamicOps)NbtOps.INSTANCE);
        dataResult.resultOrPartial(arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0)).ifPresent(tag -> piglinNbt.put("Brain", tag));
        return LooniumMobSpawnData.entityWeight(EntityType.PIGLIN, weight).spawnAsAdult().nbt(piglinNbt).equipmentTable(equipmentTable).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(needWaterBreathing, true)).build();
    }

    @NotNull
    public String getName() {
        return "Loonium structure configuration";
    }
}

