/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;

public class ItemTagProvider
extends ItemTagsProvider {
    public ItemTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider) {
        super(packOutput, lookupProvider, blockTagProvider);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(ItemTags.AXES).add((Object[])new Item[]{BotaniaItems.manasteelAxe, BotaniaItems.elementiumAxe, BotaniaItems.terraAxe});
        this.tag(ItemTags.HOES).add((Object[])new Item[]{BotaniaItems.manasteelHoe, BotaniaItems.elementiumHoe});
        this.tag(ItemTags.PICKAXES).add((Object[])new Item[]{BotaniaItems.manasteelPick, BotaniaItems.elementiumPick, BotaniaItems.terraPick, BotaniaItems.glassPick});
        this.tag(ItemTags.SHOVELS).add((Object[])new Item[]{BotaniaItems.manasteelShovel, BotaniaItems.elementiumShovel});
        this.tag(ItemTags.SWORDS).add((Object[])new Item[]{BotaniaItems.manasteelSword, BotaniaItems.elementiumSword, BotaniaItems.terraSword, BotaniaItems.thunderSword, BotaniaItems.starSword});
        this.tag(ItemTags.HEAD_ARMOR).add((Object[])new Item[]{BotaniaItems.manasteelHelm, BotaniaItems.manaweaveHelm, BotaniaItems.elementiumHelm, BotaniaItems.terrasteelHelm});
        this.tag(ItemTags.CHEST_ARMOR).add((Object[])new Item[]{BotaniaItems.manasteelChest, BotaniaItems.manaweaveChest, BotaniaItems.elementiumChest, BotaniaItems.terrasteelChest});
        this.tag(ItemTags.LEG_ARMOR).add((Object[])new Item[]{BotaniaItems.manasteelLegs, BotaniaItems.manaweaveLegs, BotaniaItems.elementiumLegs, BotaniaItems.terrasteelLegs});
        this.tag(ItemTags.FOOT_ARMOR).add((Object[])new Item[]{BotaniaItems.manasteelBoots, BotaniaItems.manaweaveBoots, BotaniaItems.elementiumBoots, BotaniaItems.terrasteelBoots});
        this.copy(BlockTags.RAILS, ItemTags.RAILS);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
        this.copy(BlockTags.WOODEN_SLABS, ItemTags.WOODEN_SLABS);
        this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
        this.copy(BlockTags.WOODEN_STAIRS, ItemTags.WOODEN_STAIRS);
        this.copy(BlockTags.WALLS, ItemTags.WALLS);
        this.copy(BlockTags.FENCES, ItemTags.FENCES);
        this.copy(BlockTags.WOODEN_FENCES, ItemTags.WOODEN_FENCES);
        this.copy(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS, BotaniaTags.Items.MUNDANE_FLOATING_FLOWERS);
        this.copy(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS, BotaniaTags.Items.SPECIAL_FLOATING_FLOWERS);
        this.copy(BotaniaTags.Blocks.FLOATING_FLOWERS, BotaniaTags.Items.FLOATING_FLOWERS);
        this.copy(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS, BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS);
        this.copy(BotaniaTags.Blocks.MYSTICAL_FLOWERS, BotaniaTags.Items.MYSTICAL_FLOWERS);
        this.copy(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS, BotaniaTags.Items.MISC_SPECIAL_FLOWERS);
        this.copy(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS, BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS);
        this.copy(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS, BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS);
        this.copy(BotaniaTags.Blocks.SPECIAL_FLOWERS, BotaniaTags.Items.SPECIAL_FLOWERS);
        this.copy(BotaniaTags.Blocks.MINI_FLOWERS, BotaniaTags.Items.MINI_FLOWERS);
        this.tag(BotaniaTags.Items.CONTRIBUTOR_HEADFLOWERS).addTag(BotaniaTags.Items.SPECIAL_FLOWERS).add((Object[])new Item[]{BotaniaBlocks.motifDaybloom.asItem(), BotaniaBlocks.motifNightshade.asItem()});
        this.tag(ItemTags.TALL_FLOWERS).addTag(BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS);
        this.tag(ItemTags.SMALL_FLOWERS).addTag(BotaniaTags.Items.MYSTICAL_FLOWERS).addTag(BotaniaTags.Items.SPECIAL_FLOWERS).add((Object[])new Item[]{BotaniaBlocks.motifDaybloom.asItem(), BotaniaBlocks.motifNightshade.asItem(), BotaniaBlocks.motifHydroangeas.asItem()});
        this.tag(BotaniaTags.Items.BURST_VIEWERS).add((Object)BotaniaItems.monocle);
        this.tag(BotaniaTags.Items.TERRA_PICK_BLACKLIST).add((Object[])new Item[]{BotaniaItems.auraRing, BotaniaItems.auraRingGreater, BotaniaItems.terrasteelHelm, BotaniaItems.spark});
        IntrinsicHolderTagsProvider.IntrinsicTagAppender builder = this.tag(BotaniaTags.Items.LENS);
        BuiltInRegistries.ITEM.stream().filter(i -> i instanceof LensItem && BuiltInRegistries.ITEM.getKey(i).getNamespace().equals("botania")).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).sorted().forEach(arg_0 -> ItemTagProvider.lambda$addTags$1((TagsProvider.TagAppender)builder, arg_0));
        this.tag(BotaniaTags.Items.LENS_GLUE).add((Object)Items.SLIME_BALL).add((Object)Items.HONEY_BOTTLE);
        this.tag(ItemTags.PIGLIN_LOVED).add((Object[])new Item[]{BotaniaBlocks.alchemyCatalyst.asItem(), BotaniaItems.divaCharm, BotaniaBlocks.hourglass.asItem(), BotaniaBlocks.manaPylon.asItem(), BotaniaItems.monocle});
        this.tag(ItemTags.CLUSTER_MAX_HARVESTABLES).add((Object[])new Item[]{BotaniaItems.manasteelPick, BotaniaItems.elementiumPick, BotaniaItems.terraPick, BotaniaItems.glassPick});
        this.tag(ItemTags.LECTERN_BOOKS).add((Object)BotaniaItems.lexicon);
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)BotaniaItems.lexicon);
        this.tag(BotaniaTags.Items.DUSTS_MANA).add((Object)BotaniaItems.manaPowder);
        this.tag(BotaniaTags.Items.GEMS_DRAGONSTONE).add((Object)BotaniaItems.dragonstone);
        this.tag(BotaniaTags.Items.GEMS_MANA_DIAMOND).add((Object)BotaniaItems.manaDiamond);
        this.tag(BotaniaTags.Items.INGOTS_ELEMENTIUM).add((Object)BotaniaItems.elementium);
        this.tag(BotaniaTags.Items.INGOTS_MANASTEEL).add((Object)BotaniaItems.manaSteel);
        this.tag(BotaniaTags.Items.INGOTS_TERRASTEEL).add((Object)BotaniaItems.terrasteel);
        this.tag(BotaniaTags.Items.NUGGETS_ELEMENTIUM).add((Object)BotaniaItems.elementiumNugget);
        this.tag(BotaniaTags.Items.NUGGETS_MANASTEEL).add((Object)BotaniaItems.manasteelNugget);
        this.tag(BotaniaTags.Items.NUGGETS_TERRASTEEL).add((Object)BotaniaItems.terrasteelNugget);
        this.copy(BotaniaTags.Blocks.BLOCKS_ELEMENTIUM, BotaniaTags.Items.BLOCKS_ELEMENTIUM);
        this.copy(BotaniaTags.Blocks.BLOCKS_MANASTEEL, BotaniaTags.Items.BLOCKS_MANASTEEL);
        this.copy(BotaniaTags.Blocks.BLOCKS_TERRASTEEL, BotaniaTags.Items.BLOCKS_TERRASTEEL);
        this.copy(BlockTags.LOGS_THAT_BURN, ItemTags.LOGS_THAT_BURN);
        this.copy(BotaniaTags.Blocks.LIVINGWOOD_LOGS, BotaniaTags.Items.LIVINGWOOD_LOGS);
        this.copy(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, BotaniaTags.Items.LIVINGWOOD_LOGS_GLIMMERING);
        this.copy(BotaniaTags.Blocks.DREAMWOOD_LOGS, BotaniaTags.Items.DREAMWOOD_LOGS);
        this.copy(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING, BotaniaTags.Items.DREAMWOOD_LOGS_GLIMMERING);
        this.tag(ItemTags.SAND);
        this.tag(BotaniaTags.Items.DISPOSABLE).add((Object[])new Item[]{Items.DIRT, Items.GRAVEL, Items.COBBLESTONE, Items.NETHERRACK, Items.COBBLED_DEEPSLATE, Items.END_STONE}).addTag(ItemTags.SAND);
        this.tag(BotaniaTags.Items.SEMI_DISPOSABLE).add((Object[])new Item[]{Items.ANDESITE, Items.DIORITE, Items.GRANITE, Items.TUFF, Items.CALCITE, Items.STONE, Items.BASALT, Items.BLACKSTONE, Items.DEEPSLATE, Items.DRIPSTONE_BLOCK, Items.POINTED_DRIPSTONE, Items.MOSS_BLOCK, Items.SANDSTONE, Items.RED_SANDSTONE}).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"jasper")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"limestone")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"marble")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)"slate"));
        this.tag(BotaniaTags.Items.RUNES).add((Object[])new Item[]{BotaniaItems.runeWater, BotaniaItems.runeFire, BotaniaItems.runeEarth, BotaniaItems.runeAir, BotaniaItems.runeSpring, BotaniaItems.runeSummer, BotaniaItems.runeAutumn, BotaniaItems.runeWinter, BotaniaItems.runeMana, BotaniaItems.runeLust, BotaniaItems.runeGluttony, BotaniaItems.runeGreed, BotaniaItems.runeSloth, BotaniaItems.runeWrath, BotaniaItems.runeEnvy, BotaniaItems.runePride});
        IntrinsicHolderTagsProvider.IntrinsicTagAppender allPetals = this.tag(BotaniaTags.Items.PETALS);
        ColorHelper.supportedColors().forEach(arg_0 -> this.lambda$addTags$2((TagsProvider.TagAppender)allPetals, arg_0));
        Predicate<Item> jukeboxPlayablePredicate = item -> item.components().has(DataComponents.JUKEBOX_PLAYABLE);
        this.tag(BotaniaTags.Items.LOONIUM_BLACKLIST).add((Object[])new Item[]{BotaniaItems.lexicon, BotaniaItems.overgrowthSeed, BotaniaItems.blackLotus, BotaniaItems.blackerLotus}).add((Object[])ItemTagProvider.getItems(jukeboxPlayablePredicate));
        this.tag(ItemTags.ARROWS);
        this.tag(BotaniaTags.Items.LOONIUM_OFFHAND_EQUIPMENT).add((Object[])new Item[]{Items.FIREWORK_ROCKET, Items.TOTEM_OF_UNDYING}).addTag(ItemTags.ARROWS);
        this.tag(BotaniaTags.Items.MAGNET_RING_BLACKLIST);
        this.tag(BotaniaTags.Items.RODS).add((Object[])new Item[]{BotaniaItems.dirtRod, BotaniaItems.skyDirtRod, BotaniaItems.terraformRod, BotaniaItems.cobbleRod, BotaniaItems.waterRod, BotaniaItems.tornadoRod, BotaniaItems.fireRod, BotaniaItems.diviningRod, BotaniaItems.smeltRod, BotaniaItems.exchangeRod, BotaniaItems.rainbowRod, BotaniaItems.gravityRod, BotaniaItems.missileRod});
        this.tag(BotaniaTags.Items.MANA_USING_ITEMS).add((Object[])new Item[]{BotaniaItems.bloodPendant, BotaniaItems.cobbleRod, BotaniaItems.crystalBow, BotaniaItems.dirtRod, BotaniaItems.divaCharm, BotaniaItems.diviningRod, BotaniaItems.elementiumAxe, BotaniaItems.elementiumBoots, BotaniaItems.elementiumChest, BotaniaItems.elementiumHelm, BotaniaItems.elementiumHoe, BotaniaItems.elementiumLegs, BotaniaItems.elementiumPick, BotaniaItems.elementiumShears, BotaniaItems.elementiumShovel, BotaniaItems.elementiumSword, BotaniaItems.enderHand, BotaniaItems.exchangeRod, BotaniaItems.fireRod, BotaniaItems.flightTiara, BotaniaItems.flugelEye, BotaniaItems.glassPick, BotaniaItems.goddessCharm, BotaniaItems.gravityRod, BotaniaItems.infiniteFruit, BotaniaItems.invisibilityCloak, BotaniaItems.kingKey, BotaniaItems.livingwoodBow, BotaniaItems.lokiRing, BotaniaItems.manasteelAxe, BotaniaItems.manasteelBoots, BotaniaItems.manasteelChest, BotaniaItems.manasteelHelm, BotaniaItems.manasteelHoe, BotaniaItems.manasteelLegs, BotaniaItems.manasteelPick, BotaniaItems.manasteelShears, BotaniaItems.manasteelShovel, BotaniaItems.manasteelSword, BotaniaItems.manaweaveBoots, BotaniaItems.manaweaveChest, BotaniaItems.manaweaveHelm, BotaniaItems.manaweaveLegs, BotaniaItems.miningRing, BotaniaItems.missileRod, BotaniaItems.rainbowRod, BotaniaItems.skyDirtRod, BotaniaItems.smeltRod, BotaniaItems.starSword, BotaniaItems.superTravelBelt, BotaniaItems.terraAxe, BotaniaItems.terraPick, BotaniaItems.terraSword, BotaniaItems.terraformRod, BotaniaItems.terrasteelBoots, BotaniaItems.terrasteelChest, BotaniaItems.terrasteelHelm, BotaniaItems.terrasteelLegs, BotaniaItems.thirdEye, BotaniaItems.thunderSword, BotaniaItems.tornadoRod, BotaniaItems.travelBelt, BotaniaItems.waterRing, BotaniaItems.waterRod});
        this.tag(ItemTags.FREEZE_IMMUNE_WEARABLES).add((Object[])new Item[]{BotaniaItems.icePendant, BotaniaItems.manaweaveHelm, BotaniaItems.manaweaveChest, BotaniaItems.manaweaveLegs, BotaniaItems.manaweaveBoots});
        this.tag(BotaniaTags.Items.SEED_APOTHECARY_REAGENT).add((Object[])new Item[]{Items.WHEAT_SEEDS, Items.BEETROOT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS}).addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"seeds"));
    }

    @NotNull
    private static Item[] getItems(Predicate<Item> predicate) {
        Comparator<Item> itemComparator = Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
        return (Item[])BuiltInRegistries.ITEM.stream().filter(predicate).sorted(itemComparator).toArray(Item[]::new);
    }

    private /* synthetic */ void lambda$addTags$2(TagsProvider.TagAppender allPetals, DyeColor color) {
        TagKey<Item> petalTag = BotaniaTags.Items.getPetalTag(color);
        this.tag(petalTag).add((Object[])new Item[]{BotaniaItems.getPetal(color), BotaniaBlocks.getMushroom(color).asItem()});
        allPetals.addTag(petalTag);
    }

    private static /* synthetic */ void lambda$addTags$1(TagsProvider.TagAppender builder, ResourceLocation item) {
        builder.add(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)item));
    }
}

