/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FloatingFlowerModelProvider
implements DataProvider {
    private final PackOutput packOutput;

    public FloatingFlowerModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<Tuple> jsons = new ArrayList<Tuple>();
        for (Block b : BuiltInRegistries.BLOCK) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)b);
            if (!"botania".equals(id.getNamespace()) || !(b instanceof FloatingFlowerBlock)) continue;
            String name = id.getPath();
            String nonFloat = name.endsWith("_floating_flower") ? name.replace("_floating_flower", "_mystical_flower") : name.replace("floating_", "");
            JsonObject obj = new JsonObject();
            obj.addProperty("parent", "minecraft:block/block");
            obj.addProperty("loader", ClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.toString());
            JsonObject flower = new JsonObject();
            flower.addProperty("parent", "botania:block/" + nonFloat);
            obj.add("flower", (JsonElement)flower);
            jsons.add(new Tuple((Object)name, (Object)obj));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        PackOutput.PathProvider blocks = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models/block");
        PackOutput.PathProvider items = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models/item");
        for (Tuple pair : jsons) {
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)pair.getB()), (Path)blocks.json(BotaniaAPI.botaniaRL((String)pair.getA()))));
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)pair.getB()), (Path)items.json(BotaniaAPI.botaniaRL((String)pair.getA()))));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String getName() {
        return "Botania floating flower models";
    }
}

