/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.block.FloatingSpecialFlowerBlock;
import vazkii.botania.common.block.OpenCrateBlock;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.SpecialFlowerBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.mana.DrumBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.block.red_string.RedStringBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.BotaniaTags;

public class BlockTagProvider
extends IntrinsicHolderTagsProvider<Block> {
    public static final Predicate<Block> BOTANIA_BLOCK = b -> "botania".equals(BuiltInRegistries.BLOCK.getKey(b).getNamespace());

    public BlockTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Registries.BLOCK, lookupProvider, block -> block.builtInRegistryHolder().key());
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(BlockTags.RAILS).add((Object)BotaniaBlocks.ghostRail);
        this.tag(BlockTags.SLABS).add((Object[])this.getModBlocks(b -> b instanceof SlabBlock));
        this.tag(BlockTags.WOODEN_SLABS).add((Object[])new Block[]{BotaniaBlocks.livingwoodSlab, BotaniaBlocks.livingwoodStrippedSlab, BotaniaBlocks.livingwoodPlankSlab, BotaniaBlocks.dreamwoodSlab, BotaniaBlocks.dreamwoodStrippedSlab, BotaniaBlocks.dreamwoodPlankSlab, BotaniaBlocks.shimmerwoodPlankSlab});
        this.tag(BlockTags.STAIRS).add((Object[])this.getModBlocks(b -> b instanceof StairBlock));
        this.tag(BlockTags.WOODEN_STAIRS).add((Object[])new Block[]{BotaniaBlocks.livingwoodStairs, BotaniaBlocks.livingwoodStrippedStairs, BotaniaBlocks.livingwoodPlankStairs, BotaniaBlocks.dreamwoodStairs, BotaniaBlocks.dreamwoodStrippedStairs, BotaniaBlocks.dreamwoodPlankStairs, BotaniaBlocks.shimmerwoodPlankStairs});
        this.tag(BlockTags.WALLS).add((Object[])this.getModBlocks(b -> b instanceof WallBlock));
        this.tag(BlockTags.FENCES).add((Object[])this.getModBlocks(b -> b instanceof FenceBlock));
        this.tag(BlockTags.WOODEN_FENCES).add((Object[])new Block[]{BotaniaBlocks.livingwoodFence, BotaniaBlocks.dreamwoodFence});
        this.tag(BlockTags.FENCE_GATES).add((Object[])this.getModBlocks(b -> b instanceof FenceGateBlock));
        this.tag(BlockTags.DRAGON_IMMUNE).add((Object)BotaniaBlocks.infrangiblePlatform);
        this.tag(BlockTags.WITHER_IMMUNE).add((Object)BotaniaBlocks.infrangiblePlatform);
        this.tag(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getFloatingFlower).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new)));
        this.tag(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS).add((Object[])((Block[])BuiltInRegistries.BLOCK.stream().filter(BOTANIA_BLOCK).filter(b -> b instanceof FloatingSpecialFlowerBlock).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new)));
        this.tag(BotaniaTags.Blocks.FLOATING_FLOWERS).addTag(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS).addTag(BotaniaTags.Blocks.SPECIAL_FLOATING_FLOWERS);
        this.tag(BotaniaTags.Blocks.MYSTICAL_FLOWERS).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getFlower).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new)));
        this.tag(BotaniaTags.Blocks.SHINY_FLOWERS).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getShinyFlower).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new)));
        this.tag(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getDoubleFlower).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new)));
        this.tag(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS).add((Object[])new Block[]{BotaniaFlowerBlocks.manastar, BotaniaFlowerBlocks.pureDaisy, BotaniaFlowerBlocks.bergamute});
        this.tag(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS).add((Object[])new Block[]{BotaniaFlowerBlocks.dandelifeon, BotaniaFlowerBlocks.endoflame, BotaniaFlowerBlocks.entropinnyum, BotaniaFlowerBlocks.gourmaryllis, BotaniaFlowerBlocks.hydroangeas, BotaniaFlowerBlocks.kekimurus, BotaniaFlowerBlocks.munchdew, BotaniaFlowerBlocks.narslimmus, BotaniaFlowerBlocks.rafflowsia, BotaniaFlowerBlocks.rosaArcana, BotaniaFlowerBlocks.shulkMeNot, BotaniaFlowerBlocks.spectrolus, BotaniaFlowerBlocks.thermalily});
        this.tag(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS).add((Object[])new Block[]{BotaniaFlowerBlocks.agricarnation, BotaniaFlowerBlocks.agricarnationChibi, BotaniaFlowerBlocks.bellethorn, BotaniaFlowerBlocks.bellethornChibi, BotaniaFlowerBlocks.bubbell, BotaniaFlowerBlocks.bubbellChibi, BotaniaFlowerBlocks.clayconia, BotaniaFlowerBlocks.clayconiaChibi, BotaniaFlowerBlocks.daffomill, BotaniaFlowerBlocks.dreadthorn, BotaniaFlowerBlocks.exoflame, BotaniaFlowerBlocks.fallenKanade, BotaniaFlowerBlocks.heiseiDream, BotaniaFlowerBlocks.hopperhock, BotaniaFlowerBlocks.hopperhockChibi, BotaniaFlowerBlocks.hyacidus, BotaniaFlowerBlocks.jadedAmaranthus, BotaniaFlowerBlocks.jiyuulia, BotaniaFlowerBlocks.jiyuuliaChibi, BotaniaFlowerBlocks.labellia, BotaniaFlowerBlocks.loonium, BotaniaFlowerBlocks.marimorphosis, BotaniaFlowerBlocks.marimorphosisChibi, BotaniaFlowerBlocks.medumone, BotaniaFlowerBlocks.orechid, BotaniaFlowerBlocks.orechidIgnem, BotaniaFlowerBlocks.pollidisiac, BotaniaFlowerBlocks.rannuncarpus, BotaniaFlowerBlocks.rannuncarpusChibi, BotaniaFlowerBlocks.solegnolia, BotaniaFlowerBlocks.solegnoliaChibi, BotaniaFlowerBlocks.spectranthemum, BotaniaFlowerBlocks.tangleberrie, BotaniaFlowerBlocks.tangleberrieChibi, BotaniaFlowerBlocks.tigerseye, BotaniaFlowerBlocks.vinculotus});
        this.tag(BotaniaTags.Blocks.SPECIAL_FLOWERS).addTag(BotaniaTags.Blocks.MISC_SPECIAL_FLOWERS).addTag(BotaniaTags.Blocks.GENERATING_SPECIAL_FLOWERS).addTag(BotaniaTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS);
        this.tag(BotaniaTags.Blocks.MINI_FLOWERS).add((Object[])this.getModBlocks(b -> b instanceof SpecialFlowerBlock && BuiltInRegistries.BLOCK.getKey(b).getPath().endsWith("_chibi")));
        this.tag(BotaniaTags.Blocks.ENCHANTER_FLOWERS).addTag(BotaniaTags.Blocks.MYSTICAL_FLOWERS).addTag(BotaniaTags.Blocks.SHINY_FLOWERS).addTag(BotaniaTags.Blocks.MUNDANE_FLOATING_FLOWERS);
        this.tag(BlockTags.TALL_FLOWERS).addTag(BotaniaTags.Blocks.DOUBLE_MYSTICAL_FLOWERS);
        this.tag(BlockTags.SMALL_FLOWERS).addTag(BotaniaTags.Blocks.MYSTICAL_FLOWERS);
        this.tag(BlockTags.IMPERMEABLE).add((Object[])new Block[]{BotaniaBlocks.elfGlass, BotaniaBlocks.manaGlass, BotaniaBlocks.bifrost, BotaniaBlocks.bifrostPerm});
        this.tag(BlockTags.BEACON_BASE_BLOCKS).add((Object[])new Block[]{BotaniaBlocks.manasteelBlock, BotaniaBlocks.terrasteelBlock, BotaniaBlocks.elementiumBlock, BotaniaBlocks.manaDiamondBlock, BotaniaBlocks.dragonstoneBlock});
        @NotNull Object[] grassBlockVariants = this.getModBlocks(b -> b instanceof BotaniaGrassBlock);
        this.tag(BlockTags.DIRT).add(grassBlockVariants);
        this.tag(BlockTags.SNIFFER_DIGGABLE_BLOCK).add(grassBlockVariants);
        this.tag(BotaniaTags.Blocks.BLOCKS_ELEMENTIUM).add((Object)BotaniaBlocks.elementiumBlock);
        this.tag(BotaniaTags.Blocks.BLOCKS_MANASTEEL).add((Object)BotaniaBlocks.manasteelBlock);
        this.tag(BotaniaTags.Blocks.BLOCKS_TERRASTEEL).add((Object)BotaniaBlocks.terrasteelBlock);
        this.tag(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE).add((Object[])new Block[]{BotaniaBlocks.corporeaBlock, BotaniaBlocks.corporeaBrick, BotaniaBlocks.corporeaBrickSlab, BotaniaBlocks.corporeaBrickStairs, BotaniaBlocks.corporeaBrickWall, BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaIndex, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaSlab, BotaniaBlocks.corporeaStairs});
        this.tag(BlockTags.SAND);
        this.tag(BotaniaTags.Blocks.TERRAFORMABLE).add((Object[])new Block[]{Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.INFESTED_STONE, Blocks.STONE, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE}).add((Object[])new Block[]{Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.COARSE_DIRT, Blocks.PODZOL, Blocks.MYCELIUM}).add((Object[])new Block[]{Blocks.GRASS_BLOCK, Blocks.GRAVEL, Blocks.SNOW}).addTag(BlockTags.SAND);
        this.tag(BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST).add((Object[])new Block[]{Blocks.BEACON, BotaniaBlocks.manaPylon, BotaniaBlocks.naturaPylon, BotaniaBlocks.gaiaPylon});
        this.tag(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST).add((Object[])new Block[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool, BotaniaBlocks.terraPlate, BotaniaBlocks.runeAltar});
        this.tag(BotaniaTags.Blocks.LAPUTA_IMMOBILE);
        this.tag(BotaniaTags.Blocks.LAPUTA_NO_DOUBLE_BLOCK);
        this.tag(BotaniaTags.Blocks.TERRA_PLATE_BASE).add((Object[])new Block[]{BotaniaBlocks.livingrock, BotaniaBlocks.shimmerrock});
        this.tag(BlockTags.CLIMBABLE).add((Object)BotaniaBlocks.solidVines);
        this.tag(BlockTags.PLANKS).add((Object[])new Block[]{BotaniaBlocks.livingwoodPlanks, BotaniaBlocks.livingwoodPlanksMossy, BotaniaBlocks.livingwoodFramed, BotaniaBlocks.livingwoodPatternFramed, BotaniaBlocks.dreamwoodPlanks, BotaniaBlocks.dreamwoodPlanksMossy, BotaniaBlocks.dreamwoodFramed, BotaniaBlocks.dreamwoodPatternFramed, BotaniaBlocks.shimmerwoodPlanks});
        this.tag(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING).add((Object[])new Block[]{BotaniaBlocks.livingwoodGlimmering, BotaniaBlocks.livingwoodLogGlimmering, BotaniaBlocks.livingwoodStrippedGlimmering, BotaniaBlocks.livingwoodLogStrippedGlimmering});
        this.tag(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING).add((Object[])new Block[]{BotaniaBlocks.dreamwoodGlimmering, BotaniaBlocks.dreamwoodLogGlimmering, BotaniaBlocks.dreamwoodStrippedGlimmering, BotaniaBlocks.dreamwoodLogStrippedGlimmering});
        this.tag(BotaniaTags.Blocks.LIVINGWOOD_LOGS).add((Object[])new Block[]{BotaniaBlocks.livingwoodLog, BotaniaBlocks.livingwood, BotaniaBlocks.livingwoodLogStripped, BotaniaBlocks.livingwoodStripped}).addTag(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING);
        this.tag(BotaniaTags.Blocks.DREAMWOOD_LOGS).add((Object[])new Block[]{BotaniaBlocks.dreamwoodLog, BotaniaBlocks.dreamwood, BotaniaBlocks.dreamwoodLogStripped, BotaniaBlocks.dreamwoodStripped}).addTag(BotaniaTags.Blocks.DREAMWOOD_LOGS_GLIMMERING);
        this.tag(BlockTags.LOGS_THAT_BURN).addTag(BotaniaTags.Blocks.LIVINGWOOD_LOGS).addTag(BotaniaTags.Blocks.DREAMWOOD_LOGS);
        this.tag(BotaniaTags.Blocks.GHOST_RAIL_BARRIER).addTag(BotaniaTags.Blocks.DREAMWOOD_LOGS);
        this.tag(BotaniaTags.Blocks.ENDER_AIR_CONVERTABLE).add((Object[])new Block[]{Blocks.STONE, Blocks.DEEPSLATE, Blocks.GRANITE, Blocks.DIORITE, Blocks.ANDESITE});
        this.tag(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE).add((Object[])new Block[]{Blocks.STONE, Blocks.DEEPSLATE, Blocks.GRANITE, Blocks.DIORITE, Blocks.ANDESITE, Blocks.TUFF});
        this.tag(BotaniaTags.Blocks.WEIGHT_LENS_WHITELIST);
        this.tag(BlockTags.MUSHROOM_GROW_BLOCK).add((Object[])new Block[]{BotaniaBlocks.biomeStoneFungal, BotaniaBlocks.biomeStoneFungalSlab, BotaniaBlocks.biomeStoneFungalStairs, BotaniaBlocks.biomeStoneFungalWall, BotaniaBlocks.biomeBrickFungal, BotaniaBlocks.biomeBrickFungalSlab, BotaniaBlocks.biomeBrickFungalStairs, BotaniaBlocks.biomeBrickFungalWall, BotaniaBlocks.biomeCobblestoneFungal, BotaniaBlocks.biomeCobblestoneFungalSlab, BotaniaBlocks.biomeCobblestoneFungalStairs, BotaniaBlocks.biomeCobblestoneFungalWall, BotaniaBlocks.biomeChiseledBrickFungal, BotaniaBlocks.fungalAltar});
        this.tag(BotaniaTags.Blocks.HORN_OF_THE_WILD_BREAKABLE).add((Object)Blocks.MOSS_CARPET);
        this.tag(BlockTags.LEAVES);
        this.tag(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE).addTag(BlockTags.LEAVES);
        this.tag(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE).add((Object)Blocks.SNOW);
        this.tag(BlockTags.FIRE);
        this.tag(BotaniaTags.Blocks.UNWANDABLE).addTag(BlockTags.FIRE).add((Object[])new Block[]{Blocks.CHORUS_PLANT, Blocks.SCULK_VEIN, Blocks.VINE, Blocks.REDSTONE_WIRE, Blocks.NETHER_PORTAL, BotaniaBlocks.solidVines});
        this.tag(BotaniaTags.Blocks.PASTURE_SEED_REPLACEABLE).add((Object[])new Block[]{Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.MYCELIUM});
        this.tag(BotaniaTags.Blocks.UNETHICAL_TNT_CHECK).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"tiny_tnt"));
        this.tag(BlockTags.FLOWER_POTS).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getPottedFlower).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new))).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getPottedShinyFlower).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new))).add((Object[])((Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getPottedMushroom).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new))).add((Object[])new Block[]{BotaniaFlowerBlocks.manastarPotted, BotaniaFlowerBlocks.pureDaisyPotted, BotaniaFlowerBlocks.bergamutePotted, BotaniaFlowerBlocks.dandelifeonPotted, BotaniaFlowerBlocks.endoflamePotted, BotaniaFlowerBlocks.entropinnyumPotted, BotaniaFlowerBlocks.gourmaryllisPotted, BotaniaFlowerBlocks.hydroangeasPotted, BotaniaFlowerBlocks.kekimurusPotted, BotaniaFlowerBlocks.munchdewPotted, BotaniaFlowerBlocks.narslimmusPotted, BotaniaFlowerBlocks.rafflowsiaPotted, BotaniaFlowerBlocks.rosaArcanaPotted, BotaniaFlowerBlocks.shulkMeNotPotted, BotaniaFlowerBlocks.spectrolusPotted, BotaniaFlowerBlocks.thermalilyPotted, BotaniaFlowerBlocks.agricarnationPotted, BotaniaFlowerBlocks.agricarnationChibiPotted, BotaniaFlowerBlocks.bellethornPotted, BotaniaFlowerBlocks.bellethornChibiPotted, BotaniaFlowerBlocks.bubbellPotted, BotaniaFlowerBlocks.bubbellChibiPotted, BotaniaFlowerBlocks.clayconiaPotted, BotaniaFlowerBlocks.clayconiaChibiPotted, BotaniaFlowerBlocks.daffomillPotted, BotaniaFlowerBlocks.dreadthornPotted, BotaniaFlowerBlocks.exoflamePotted, BotaniaFlowerBlocks.fallenKanadePotted, BotaniaFlowerBlocks.heiseiDreamPotted, BotaniaFlowerBlocks.hopperhockPotted, BotaniaFlowerBlocks.hopperhockChibiPotted, BotaniaFlowerBlocks.hyacidusPotted, BotaniaFlowerBlocks.jadedAmaranthusPotted, BotaniaFlowerBlocks.jiyuuliaPotted, BotaniaFlowerBlocks.jiyuuliaChibiPotted, BotaniaFlowerBlocks.labelliaPotted, BotaniaFlowerBlocks.looniumPotted, BotaniaFlowerBlocks.marimorphosisPotted, BotaniaFlowerBlocks.marimorphosisChibiPotted, BotaniaFlowerBlocks.medumonePotted, BotaniaFlowerBlocks.orechidPotted, BotaniaFlowerBlocks.orechidIgnemPotted, BotaniaFlowerBlocks.pollidisiacPotted, BotaniaFlowerBlocks.rannuncarpusPotted, BotaniaFlowerBlocks.rannuncarpusChibiPotted, BotaniaFlowerBlocks.solegnoliaPotted, BotaniaFlowerBlocks.solegnoliaChibiPotted, BotaniaFlowerBlocks.spectranthemumPotted, BotaniaFlowerBlocks.tangleberriePotted, BotaniaFlowerBlocks.tangleberrieChibiPotted, BotaniaFlowerBlocks.tigerseyePotted, BotaniaFlowerBlocks.vinculotusPotted});
        this.tag(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL).add((Object[])new Block[]{Blocks.AZALEA, Blocks.FLOWERING_AZALEA});
        this.tag(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE).addTag(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL);
        this.tag(BotaniaTags.Blocks.AGRICARNATION_GROWTH_EXCLUDED).add((Object[])new Block[]{Blocks.RED_MUSHROOM, Blocks.BROWN_MUSHROOM, Blocks.MANGROVE_LEAVES});
        this.registerMiningTags();
    }

    private void registerMiningTags() {
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object[])this.getModBlocks(b -> b == BotaniaBlocks.cellBlock || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("_petal_block")));
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object[])this.getModBlocks(b -> b == BotaniaBlocks.enchantedSoil || b instanceof FloatingFlowerBlock || b instanceof BotaniaGrassBlock));
        Set<Block> pickaxe = Set.of(BotaniaBlocks.alchemyCatalyst, BotaniaBlocks.conjurationCatalyst, BotaniaBlocks.manasteelBlock, BotaniaBlocks.elementiumBlock, BotaniaBlocks.terrasteelBlock, BotaniaBlocks.manaDiamondBlock, BotaniaBlocks.dragonstoneBlock, BotaniaBlocks.manaGlass, BotaniaBlocks.elfGlass, BotaniaBlocks.bifrostPerm, BotaniaBlocks.managlassPane, BotaniaBlocks.alfglassPane, BotaniaBlocks.bifrostPane, BotaniaBlocks.runeAltar, BotaniaBlocks.brewery, BotaniaBlocks.terraPlate, BotaniaBlocks.distributor, BotaniaBlocks.manaVoid, BotaniaBlocks.manaDetector, BotaniaBlocks.pistonRelay, BotaniaBlocks.tinyPlanet, BotaniaBlocks.spawnerClaw, BotaniaBlocks.rfGenerator, BotaniaBlocks.prism, BotaniaBlocks.pump, BotaniaBlocks.sparkChanger, BotaniaBlocks.forestEye, BotaniaBlocks.enderEye, BotaniaBlocks.hourglass, BotaniaBlocks.starfield, BotaniaBlocks.blazeBlock);
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])this.getModBlocks(b -> pickaxe.contains(b) || b instanceof PetalApothecaryBlock || b instanceof PylonBlock || b instanceof ManaPoolBlock || b instanceof RedStringBlock || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("azulejo_") || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("corporea") || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("_pavement") || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("_quartz") || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("metamorphic_") && !(b instanceof WallBlock) || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("livingrock") && !(b instanceof WallBlock) || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("shimmerrock")));
        Set<Block> axe = Set.of(BotaniaBlocks.alfPortal, BotaniaBlocks.turntable, BotaniaBlocks.manaBomb, BotaniaBlocks.bellows, BotaniaBlocks.incensePlate, BotaniaBlocks.cacophonium, BotaniaBlocks.avatar, BotaniaBlocks.root, BotaniaBlocks.felPumpkin);
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])this.getModBlocks(b -> axe.contains(b) || b instanceof DrumBlock || b instanceof OpenCrateBlock || b instanceof PlatformBlock || b instanceof ManaSpreaderBlock || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("livingwood") || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("dreamwood") || BuiltInRegistries.BLOCK.getKey(b).getPath().contains("shimmerwood_planks")));
    }

    @NotNull
    private Block[] getModBlocks(Predicate<Block> predicate) {
        return (Block[])BuiltInRegistries.BLOCK.stream().filter(BOTANIA_BLOCK.and(predicate)).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).toArray(Block[]::new);
    }
}

