/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.advancements.AlfheimPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfheimPortalTrigger;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.advancements.GaiaGuardianNoArmorTrigger;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.advancements.ManaBlasterTrigger;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

public class AdvancementProvider {
    public static net.minecraft.data.advancements.AdvancementProvider create(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return new net.minecraft.data.advancements.AdvancementProvider(packOutput, lookupProvider, List.of(new BotaniaStoryAdvancements(), new BotaniaChallengeAdvancements()));
    }

    private static AdvancementHolder relicBindAdvancement(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, Item relicItem, String titleKey, String criterionName) {
        String id = AdvancementProvider.challengeId(BuiltInRegistries.ITEM.getKey((Object)relicItem).getPath());
        return Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)relicItem, titleKey, AdvancementType.CHALLENGE)).parent(parent).rewards(AdvancementRewards.Builder.experience((int)50)).addCriterion(criterionName, RelicBindTrigger.Instance.bound((ItemLike)relicItem)).save(consumer, id);
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> onPickup(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> onPickup(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{AdvancementProvider.matchItems(items)});
    }

    protected static ItemPredicate matchItems(ItemLike ... items) {
        return ItemPredicate.Builder.item().of(items).build();
    }

    protected static DisplayInfo simple(ItemLike icon, String name, AdvancementType AdvancementType2) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)expandedName), (Component)Component.translatable((String)(expandedName + ".desc")), Optional.empty(), AdvancementType2, true, true, false);
    }

    protected static DisplayInfo hidden(ItemLike icon, String name, AdvancementType AdvancementType2) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)expandedName), (Component)Component.translatable((String)(expandedName + ".desc")), Optional.empty(), AdvancementType2, true, true, true);
    }

    protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
        return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), Optional.of(background), AdvancementType.TASK, false, false, false);
    }

    private static String mainId(String name) {
        return BotaniaAPI.botaniaRL("main/" + name).toString();
    }

    private static String challengeId(String name) {
        return BotaniaAPI.botaniaRL("challenge/" + name).toString();
    }

    public static class BotaniaStoryAdvancements
    implements AdvancementSubProvider {
        public void generate(HolderLookup.Provider lookup, Consumer<AdvancementHolder> consumer) {
            Criterion elvenLexicon = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.lexicon}).build()});
            AdvancementHolder root = Advancement.Builder.advancement().display(AdvancementProvider.rootDisplay((ItemLike)BotaniaItems.lexicon, "itemGroup.botania", "botania.desc", BotaniaAPI.botaniaRL("textures/block/livingwood_log.png"))).addCriterion("flower", AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).save(consumer, AdvancementProvider.mainId("root"));
            AdvancementHolder flowerPickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.pinkFlower, "flowerPickup", AdvancementType.TASK)).parent(root).addCriterion("flower", AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).addCriterion("double_flower", AdvancementProvider.onPickup(BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS)).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("flower_pickup"));
            AdvancementHolder manaPoolPickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.manaPool, "manaPoolPickup", AdvancementType.TASK)).parent(flowerPickup).addCriterion("pickup", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool})).save(consumer, AdvancementProvider.mainId("mana_pool_pickup"));
            AdvancementHolder runePickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.runeAltar, "runePickup", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("rune", AdvancementProvider.onPickup(BotaniaTags.Items.RUNES)).save(consumer, AdvancementProvider.mainId("rune_pickup"));
            AdvancementHolder terrasteelPickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.terrasteel, "terrasteelPickup", AdvancementType.TASK)).parent(runePickup).addCriterion("terrasteel", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terrasteel})).save(consumer, AdvancementProvider.mainId("terrasteel_pickup"));
            AdvancementHolder elfPortalOpen = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.alfPortal, "elfPortalOpen", AdvancementType.TASK)).parent(terrasteelPickup).addCriterion("portal", AlfheimPortalTrigger.Instance.activatedPortal()).save(consumer, AdvancementProvider.mainId("elf_portal_open"));
            AdvancementHolder gaiaGuardianKill = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.gaiaHead, "gaiaGuardianKill", AdvancementType.TASK)).parent(elfPortalOpen).addCriterion("guardian", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(BotaniaEntities.DOPPLEGANGER))).save(consumer, AdvancementProvider.mainId("gaia_guardian_kill"));
            AdvancementHolder enderAirMake = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.enderAirBottle, "enderAirMake", AdvancementType.TASK)).parent(elfPortalOpen).addCriterion("air", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.enderAirBottle})).save(consumer, AdvancementProvider.mainId("ender_air_make"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.lexicon, "lexiconUse", AdvancementType.TASK)).parent(root).addCriterion("use_lexicon", UseItemSuccessTrigger.Instance.used(new ItemLike[]{BotaniaItems.lexicon})).save(consumer, AdvancementProvider.mainId("lexicon_use"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.cacophonium, "cacophoniumCraft", AdvancementType.TASK)).parent(root).addCriterion("cacophonium", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.cacophonium})).save(consumer, AdvancementProvider.mainId("cacophonium_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.endoflame, "generatingFlower", AdvancementType.TASK)).parent(flowerPickup).addCriterion("flower", AdvancementProvider.onPickup(BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS)).save(consumer, AdvancementProvider.mainId("generating_flower"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.enchanter, "enchanterMake", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("code_triggered", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, AdvancementProvider.mainId("enchanter_make"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.bellethorn, "functionalFlower", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("flower", AdvancementProvider.onPickup(BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS)).save(consumer, AdvancementProvider.mainId("functional_flower"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.poolMinecart, "manaCartCraft", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("poolcart", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.poolMinecart})).save(consumer, AdvancementProvider.mainId("mana_cart_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaweaveCloth, "manaweaveArmorCraft", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("head", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.manaweaveHelm, BotaniaItems.manaweaveChest, BotaniaItems.manaweaveLegs, BotaniaItems.manaweaveBoots})).save(consumer, AdvancementProvider.mainId("manaweave_armor_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.spark, "sparkCraft", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("spark", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.spark})).save(consumer, AdvancementProvider.mainId("spark_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaCookie, "manaCookieEat", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("cookie", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)BotaniaItems.manaCookie)).save(consumer, AdvancementProvider.mainId("mana_cookie_eat"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.craftingHalo, "craftingHaloCraft", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("pool", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.craftingHalo})).save(consumer, AdvancementProvider.mainId("crafting_halo_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaRing, "baubleWear", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("code_triggered", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, AdvancementProvider.mainId("bauble_wear"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.tinyPotato, "tinyPotatoPet", AdvancementType.TASK)).parent(manaPoolPickup).addCriterion("code_triggered", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, AdvancementProvider.mainId("tiny_potato_pet"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaGun, "manaBlasterShoot", AdvancementType.TASK)).parent(runePickup).addCriterion("shoot", ManaBlasterTrigger.Instance.shoot()).save(consumer, AdvancementProvider.mainId("mana_blaster_shoot"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.pollidisiac, "pollidisiacPickup", AdvancementType.TASK)).parent(runePickup).addCriterion("pollidisiac", AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.pollidisiac})).save(consumer, AdvancementProvider.mainId("pollidisiac_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.dirtRod, "dirtRodCraft", AdvancementType.TASK)).parent(runePickup).addCriterion("dirtrod", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.dirtRod})).save(consumer, AdvancementProvider.mainId("dirt_rod_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.brewery, "brewPickup", AdvancementType.TASK)).parent(runePickup).addCriterion("pickup", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.brewFlask, BotaniaItems.brewVial})).save(consumer, AdvancementProvider.mainId("brew_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.terraSword, "terrasteelWeaponCraft", AdvancementType.TASK)).parent(terrasteelPickup).addCriterion("terrablade", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terraSword, BotaniaItems.thornChakram})).save(consumer, AdvancementProvider.mainId("terrasteel_weapon_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.heiseiDream, "heiseiDreamPickup", AdvancementType.TASK)).parent(elfPortalOpen).addCriterion("heisei_dream", AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.heiseiDream})).save(consumer, AdvancementProvider.mainId("heisei_dream_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.kekimurus, "kekimurusPickup", AdvancementType.TASK)).parent(elfPortalOpen).addCriterion("kekimurus", AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.kekimurus})).save(consumer, AdvancementProvider.mainId("kekimurus_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.bubbell, "bubbellPickup", AdvancementType.TASK)).parent(elfPortalOpen).addCriterion("bubbell", AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.bubbell})).save(consumer, AdvancementProvider.mainId("bubbell_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.spawnerMover, "spawnerMoverUse", AdvancementType.TASK)).parent(gaiaGuardianKill).addCriterion("use_spawner_mover", UseItemSuccessTrigger.Instance.used(new ItemLike[]{BotaniaItems.spawnerMover})).save(consumer, AdvancementProvider.mainId("spawner_mover_use"));
            DisplayInfo tiaraWings = AdvancementProvider.simple((ItemLike)BotaniaItems.flightTiara, "tiaraWings", AdvancementType.TASK);
            Criterion[] variants = (Criterion[])IntStream.range(1, 9).mapToObj(i -> {
                CompoundTag tag = new CompoundTag();
                tag.putInt("variant", i);
                return tag;
            }).map(nbt -> ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.flightTiara}).build()).map(xva$0 -> InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{xva$0})).toArray(Criterion[]::new);
            Advancement.Builder builder = Advancement.Builder.advancement().display(tiaraWings).parent(gaiaGuardianKill).requirements(AdvancementRequirements.Strategy.OR);
            for (int i2 = 0; i2 < variants.length; ++i2) {
                Criterion variant = variants[i2];
                builder.addCriterion("tiara_" + (i2 + 1), variant);
            }
            builder.save(consumer, AdvancementProvider.mainId("tiara_wings"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.dandelifeon, "dandelifeonPickup", AdvancementType.TASK)).parent(gaiaGuardianKill).addCriterion("dandelifeon", AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.dandelifeon})).save(consumer, AdvancementProvider.mainId("dandelifeon_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.manaBomb, "manaBombIgnite", AdvancementType.TASK)).parent(gaiaGuardianKill).addCriterion("bomb", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaBomb})).save(consumer, AdvancementProvider.mainId("mana_bomb_ignite"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.lightRelayDefault, "luminizerRide", AdvancementType.TASK)).parent(enderAirMake).addCriterion("code_triggered", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, AdvancementProvider.mainId("luminizer_ride"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.corporeaCrystalCube, "corporeaCraft", AdvancementType.TASK)).parent(enderAirMake).addCriterion("pickup", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaIndex, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaRetainer})).save(consumer, AdvancementProvider.mainId("corporea_craft"));
            Advancement.Builder.advancement().parent(root).addCriterion("flower", AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).addCriterion("elven_lexicon", elvenLexicon).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("flower_pickup_lexicon"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("apothecary", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.defaultAltar})).addCriterion("elven_lexicon", elvenLexicon).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("apothecary_pickup"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("daisy", AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.pureDaisy})).addCriterion("elven_lexicon", elvenLexicon).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("pure_daisy_pickup"));
            Advancement.Builder.advancement().parent(root).addCriterion("pickup", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool})).addCriterion("elven_lexicon", elvenLexicon).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("mana_pool_pickup_lexicon"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("altar", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.runeAltar})).addCriterion("rune", AdvancementProvider.onPickup(BotaniaTags.Items.RUNES)).addCriterion("elven_lexicon", elvenLexicon).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("runic_altar_pickup"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("terrasteel", AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terrasteel})).addCriterion("elven_lexicon", elvenLexicon).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.mainId("terrasteel_pickup_lexicon"));
            Advancement.Builder.advancement().parent(elfPortalOpen).addCriterion("lexicon", elvenLexicon).save(consumer, AdvancementProvider.mainId("elf_lexicon_pickup"));
        }
    }

    public static class BotaniaChallengeAdvancements
    implements AdvancementSubProvider {
        private static final EntityType<?>[] LOONIUM_MOBS_TO_KILL = new EntityType[]{EntityType.BLAZE, EntityType.CAVE_SPIDER, EntityType.CREEPER, EntityType.DROWNED, EntityType.ENDERMAN, EntityType.EVOKER, EntityType.GUARDIAN, EntityType.HOGLIN, EntityType.HUSK, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.PILLAGER, EntityType.SHULKER, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.STRAY, EntityType.VINDICATOR, EntityType.WITHER_SKELETON, EntityType.ZOGLIN, EntityType.ZOMBIE_VILLAGER, EntityType.ZOMBIE, EntityType.ZOMBIFIED_PIGLIN};

        public void generate(HolderLookup.Provider lookup, Consumer<AdvancementHolder> consumer) {
            AdvancementHolder root = Advancement.Builder.advancement().display(AdvancementProvider.rootDisplay((ItemLike)BotaniaItems.dice, "advancement.botania_challenge", "advancement.botania_challenge.desc", BotaniaAPI.botaniaRL("textures/block/livingrock_bricks.png"))).addCriterion("flower", AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).save(consumer, AdvancementProvider.challengeId("root"));
            CompoundTag hardmodeNbt = new CompoundTag();
            hardmodeNbt.putBoolean("hardMode", true);
            AdvancementHolder hardMode = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.lifeEssence, "gaiaGuardianHardmode", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("guardian", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(BotaniaEntities.DOPPLEGANGER).nbt(new NbtPredicate(hardmodeNbt)))).save(consumer, AdvancementProvider.challengeId("gaia_guardian_hardmode"));
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.infiniteFruit, "infiniteFruit", "fruit");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.kingKey, "kingKey", "key");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.flugelEye, "flugelEye", "eye");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.thorRing, "thorRing", "ring");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.odinRing, "odinRing", "ring");
            AdvancementHolder lokiRing = AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.lokiRing, "lokiRing", "ring");
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.lokiRing, "lokiRingMany", AdvancementType.CHALLENGE)).parent(lokiRing).rewards(AdvancementRewards.Builder.experience((int)85)).addCriterion("place_blocks", LokiPlaceTrigger.Instance.blocksPlaced(MinMaxBounds.Ints.atLeast((int)255))).save(consumer, AdvancementProvider.challengeId("loki_ring_many"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.pinkinator, "pinkinator", AdvancementType.CHALLENGE)).parent(hardMode).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("use_pinkinator", UseItemSuccessTrigger.Instance.used(new ItemLike[]{BotaniaItems.pinkinator})).save(consumer, AdvancementProvider.challengeId("pinkinator"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)Blocks.PLAYER_HEAD, "gaiaGuardianNoArmor", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)1000)).addCriterion("no_armor", GaiaGuardianNoArmorTrigger.Instance.unarmoredKill()).save(consumer, AdvancementProvider.challengeId("gaia_guardian_no_armor"));
            Advancement.Builder.advancement().display(AdvancementProvider.hidden((ItemLike)BotaniaBlocks.motifDaybloom, "old_flower_pickup", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("flower", AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.motifDaybloom, BotaniaBlocks.motifNightshade})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, AdvancementProvider.challengeId("old_flower_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.corporeaIndex, "superCorporeaRequest", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)85)).addCriterion("big_request", CorporeaRequestTrigger.Instance.numExtracted(MinMaxBounds.Ints.atLeast((int)65536))).save(consumer, AdvancementProvider.challengeId("super_corporea_request"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.terraPick, "rankSSPick", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)500)).addCriterion("code_triggered", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, AdvancementProvider.challengeId("rank_ss_pick"));
            CompoundTag level20Shard = new CompoundTag();
            level20Shard.putInt("level", 19);
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.laputaShard, "l20ShardUse", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)65)).addCriterion("use_l20_shard", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.laputaShard}).build()})).save(consumer, AdvancementProvider.challengeId("l20_shard_use"));
            Advancement.Builder.advancement().display(AdvancementProvider.hidden((ItemLike)Items.BREAD, "alfPortalBread", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("bread", AlfheimPortalBreadTrigger.Instance.sentBread()).save(consumer, AdvancementProvider.challengeId("alf_portal_bread"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.tinyPotato, "tinyPotatoBirthday", AdvancementType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("code_triggered", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, AdvancementProvider.challengeId("tiny_potato_birthday"));
            BotaniaChallengeAdvancements.addLooniumMobsToKill(Advancement.Builder.advancement()).display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.loonium, "allLooniumMobs", AdvancementType.CHALLENGE)).parent(root).requirements(AdvancementRequirements.Strategy.AND).save(consumer, AdvancementProvider.challengeId("all_loonium_mobs"));
        }

        private static Advancement.Builder addLooniumMobsToKill(Advancement.Builder builder) {
            for (EntityType<?> entityType : LOONIUM_MOBS_TO_KILL) {
                builder.addCriterion(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString(), KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType).team("Loonium Monsters")));
            }
            return builder;
        }
    }
}

