/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;
import vazkii.botania.network.clientbound.GogWorldPacket;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class SkyblockWorldEvents {
    private static final TagKey<Block> PEBBLE_SOURCES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gardenofglass", (String)"pebble_sources"));
    private static final ResourceKey<LootTable> PEBBLES_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gardenofglass", (String)"pebbles"));

    private SkyblockWorldEvents() {
    }

    public static void syncGogStatus(ServerPlayer e) {
        boolean isGog = SkyblockChunkGenerator.isWorldSkyblock(e.level());
        if (isGog) {
            XplatAbstractions.INSTANCE.sendToPlayer((Player)e, GogWorldPacket.INSTANCE);
        }
    }

    public static void onPlayerJoin(ServerPlayer player) {
        ServerLevel world = player.serverLevel();
        if (SkyblockChunkGenerator.isWorldSkyblock((Level)world)) {
            SkyblockSavedData data = SkyblockSavedData.get(world);
            if (!data.skyblocks.containsValue((Object)Util.NIL_UUID)) {
                IslandPos islandPos = data.getSpawn();
                world.setDefaultSpawnPos(islandPos.getCenter(), 0.0f);
                SkyblockWorldEvents.spawnPlayer((Player)player, islandPos);
                BotaniaAPI.LOGGER.info("Created the spawn GoG island");
            }
        }
    }

    public static InteractionResult onPlayerInteract(Player player, Level world, InteractionHand hand, BlockHitResult hit) {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            BlockPos pos;
            BlockHitResult rtr;
            ItemStack equipped = player.getItemInHand(hand);
            if (equipped.isEmpty() && player.isShiftKeyDown()) {
                BlockState state = world.getBlockState(hit.getBlockPos());
                if (state.is(PEBBLE_SOURCES)) {
                    SoundType st = state.getSoundType();
                    SoundEvent sound = st.getBreakSound();
                    player.playSound(sound, st.getVolume() * 0.4f, st.getPitch() + (float)(Math.random() * 0.2 - 0.1));
                    if (world.isClientSide) {
                        player.swing(hand);
                    } else if (world instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)world;
                        LootTable table = level.getServer().reloadableRegistries().getLootTable(PEBBLES_TABLE);
                        LootParams context = new LootParams.Builder(level).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)hit.getBlockPos())).withParameter(LootContextParams.TOOL, (Object)equipped).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(hit.getBlockPos())).create(LootContextParamSets.BLOCK);
                        table.getRandomItems(context, s -> player.drop(s, false));
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (!equipped.isEmpty() && equipped.is(Items.BOWL) && (rtr = ToolCommons.raytraceFromEntity((Entity)player, 4.5, true)).getType() == HitResult.Type.BLOCK && world.getBlockState(pos = rtr.getBlockPos()).is(Blocks.WATER)) {
                if (!world.isClientSide) {
                    equipped.shrink(1);
                    if (equipped.isEmpty()) {
                        player.setItemInHand(hand, new ItemStack((ItemLike)BotaniaItems.waterBowl));
                    } else {
                        player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)BotaniaItems.waterBowl));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void spawnPlayer(Player player, IslandPos islandPos) {
        BlockPos pos = islandPos.getCenter();
        if (player instanceof ServerPlayer) {
            ServerPlayer pmp = (ServerPlayer)player;
            SkyblockWorldEvents.createSkyblock(pmp.serverLevel(), pos);
            pmp.teleportTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.6, (double)pos.getZ() + 0.5);
            pmp.setRespawnPosition(pmp.level().dimension(), pos, 0.0f, true, false);
            if (BotaniaConfig.common().gogSpawnWithLexicon()) {
                player.getInventory().add(new ItemStack((ItemLike)BotaniaItems.lexicon));
            }
        }
    }

    public static void createSkyblock(ServerLevel level, BlockPos pos) {
        BlockPos offset;
        StructureTemplateManager manager = level.getStructureManager();
        StructureTemplate template = (StructureTemplate)manager.get(BotaniaAPI.botaniaRL("gog_island")).orElseThrow();
        ObjectArrayList structureBlockInfos = template.filterBlocks(pos, new StructurePlaceSettings(), Blocks.STRUCTURE_BLOCK, false);
        structureBlockInfos.removeIf(info -> info.nbt() == null);
        Optional<StructureTemplate.StructureBlockInfo> infoOptional = structureBlockInfos.stream().filter(info -> "spawn_point".equals(info.nbt().getString("metadata"))).findFirst();
        if (infoOptional.isPresent()) {
            offset = infoOptional.get().pos();
        } else {
            BotaniaAPI.LOGGER.error("Structure botania:gog_island has no spawn_point data marker block, trying to offset it somewhat in the center");
            Vec3i size = template.getSize();
            offset = new BlockPos(size.getX() / 2, size.getY(), size.getZ() / 2);
        }
        BlockPos startPoint = pos.subtract((Vec3i)offset);
        template.placeInWorld((ServerLevelAccessor)level, startPoint, startPoint, new StructurePlaceSettings().addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK), level.random, 3);
        for (StructureTemplate.StructureBlockInfo info2 : structureBlockInfos) {
            BlockPos lightPos;
            if (!"light".equals(info2.nbt().getString("metadata")) || !level.setBlockAndUpdate(lightPos = startPoint.offset((Vec3i)info2.pos()), BotaniaBlocks.manaFlame.defaultBlockState())) continue;
            int r = 70 + level.random.nextInt(185);
            int g = 70 + level.random.nextInt(185);
            int b = 70 + level.random.nextInt(185);
            int color = r << 16 | g << 8 | b;
            ((ManaFlameBlockEntity)level.getBlockEntity(lightPos)).setColor(color);
        }
    }
}

