/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;

public class SkyblockChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(gen -> gen.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings)).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));

    public static void submitRegistration(BiConsumer<MapCodec<? extends ChunkGenerator>, ResourceLocation> consumer) {
        consumer.accept(CODEC, BotaniaAPI.botaniaRL("skyblock"));
    }

    public static boolean isWorldSkyblock(Level world) {
        ServerChunkCache chunkCache;
        ChunkSource chunkSource = world.getChunkSource();
        return chunkSource instanceof ServerChunkCache && (chunkCache = (ServerChunkCache)chunkSource).getGenerator() instanceof SkyblockChunkGenerator;
    }

    private SkyblockChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    @NotNull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void buildSurface(@NotNull ChunkAccess chunkAccess, @NotNull WorldGenerationContext context, @NotNull RandomState randomState, @NotNull StructureManager structureManager, @NotNull BiomeManager biomeManager, @NotNull Registry<Biome> biomes, @NotNull Blender blender) {
    }

    public void applyCarvers(@NotNull WorldGenRegion worldGenRegion, long seed, @NotNull RandomState randomState, @NotNull BiomeManager biomeManager, @NotNull StructureManager structureManager, @NotNull ChunkAccess chunkAccess, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Carving carving) {
    }

    @NotNull
    public CompletableFuture<ChunkAccess> fillFromNoise(@NotNull Blender blender, @NotNull RandomState randomState, @NotNull StructureManager structureManager, @NotNull ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void spawnOriginalMobs(@NotNull WorldGenRegion region) {
    }

    public void applyBiomeDecoration(@NotNull WorldGenLevel level, @NotNull ChunkAccess chunkAccess, @NotNull StructureManager structureManager) {
    }

    public int getBaseHeightInEquivalentNoiseWorld(int x, int z, Heightmap.Types heightmap, WorldGenLevel level) {
        RandomState randomState = RandomState.create((NoiseGeneratorSettings)((NoiseGeneratorSettings)this.generatorSettings().value()), (HolderGetter)level.registryAccess().registryOrThrow(Registries.NOISE).asLookup(), (long)level.getSeed());
        return super.getBaseHeight(x, z, heightmap, (LevelHeightAccessor)level, randomState);
    }
}

