/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.loot.BotaniaLootModifiers;

public class TrueGuardianKiller
implements LootItemCondition {
    public static final TrueGuardianKiller INSTANCE = new TrueGuardianKiller();
    public static final MapCodec<TrueGuardianKiller> CODEC = MapCodec.unit((Object)INSTANCE);

    private TrueGuardianKiller() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(@NotNull LootContext context) {
        Entity victim = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (!(victim instanceof GaiaGuardianEntity)) return false;
        GaiaGuardianEntity gg = (GaiaGuardianEntity)victim;
        if (context.getParamOrNull(LootContextParams.ATTACKING_ENTITY) != gg.trueKiller) return false;
        return true;
    }

    public LootItemConditionType getType() {
        return BotaniaLootModifiers.TRUE_GUARDIAN_KILLER;
    }
}

