/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.xplat.XplatAbstractions;

public final class LootHandler {
    public static final ResourceLocation GOG_SEEDS_TABLE = ResourceLocation.fromNamespaceAndPath((String)"gardenofglass", (String)"extra_seeds");

    public static void lootLoad(ResourceLocation id, Consumer<LootPool.Builder> addPool) {
        String prefix = "minecraft:chests/";
        String name = id.toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": {
                    addPool.accept(LootHandler.getInjectPool(file));
                    break;
                }
                case "village/village_temple": 
                case "village/village_toolsmith": 
                case "village/village_weaponsmith": {
                    addPool.accept(LootHandler.getInjectPool("village_chest"));
                    break;
                }
            }
        } else if (XplatAbstractions.INSTANCE.gogLoaded() && (Blocks.SHORT_GRASS.getLootTable().equals(id) || Blocks.TALL_GRASS.getLootTable().equals(id))) {
            ResourceKey gogSeedsKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)GOG_SEEDS_TABLE);
            addPool.accept(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)gogSeedsKey)));
        }
    }

    private static LootPool.Builder getInjectPool(String entryName) {
        return LootPool.lootPool().add(LootHandler.getInjectEntry(entryName, 1)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f));
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(String name, int weight) {
        ResourceLocation table = BotaniaAPI.botaniaRL("inject/" + name);
        ResourceKey tableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)table);
        return NestedLootTable.lootTableReference((ResourceKey)tableKey).setWeight(weight);
    }
}

