/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import vazkii.botania.api.BotaniaAPI;

public class BotaniaLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceKey<LootTable> BEHEADING_LOOT_TABLE = BotaniaLootTables.register("elementium_axe_beheading");
    public static final List<ResourceKey<LootTable>> DICE_ROLL_LOOT_TABLES = IntStream.rangeClosed(1, 6).mapToObj(i -> BotaniaLootTables.register("dice/roll_" + i)).toList();
    public static final ResourceKey<LootTable> GHAST_LOOT_TABLE = BotaniaLootTables.register("ghast_ender_air_crying");
    public static final ResourceKey<LootTable> LOONIUM_DEFAULT_LOOT = BotaniaLootTables.register("loonium/default");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COAST_CHAIN = BotaniaLootTables.register("equipment/loonium/armorset/coast_chain");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COAST_IRON = BotaniaLootTables.register("equipment/loonium/armorset/coast_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COAST_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/coast_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_DUNE_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/dune_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_DUNE_IRON = BotaniaLootTables.register("equipment/loonium/armorset/dune_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_DUNE_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/dune_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_EYE_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/eye_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_EYE_IRON = BotaniaLootTables.register("equipment/loonium/armorset/eye_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_EYE_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/eye_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_HOST_CHAIN = BotaniaLootTables.register("equipment/loonium/armorset/host_chain");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_HOST_IRON = BotaniaLootTables.register("equipment/loonium/armorset/host_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_RAISER_IRON = BotaniaLootTables.register("equipment/loonium/armorset/raiser_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_RAISER_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/raiser_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_RIB_IRON = BotaniaLootTables.register("equipment/loonium/armorset/rib_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_RIB_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/rib_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_RIB_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/rib_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SENTRY_CHAIN = BotaniaLootTables.register("equipment/loonium/armorset/sentry_chain");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SENTRY_IRON = BotaniaLootTables.register("equipment/loonium/armorset/sentry_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SENTRY_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/sentry_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SHAPER_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/shaper_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SHAPER_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/shaper_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SILENCE_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/silence_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SILENCE_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/silence_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SNOUT_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/snout_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SNOUT_NETHERITE = BotaniaLootTables.register("equipment/loonium/armorset/snout_netherite");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SPIRE_IRON = BotaniaLootTables.register("equipment/loonium/armorset/spire_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SPIRE_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/spire_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_SPIRE_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/spire_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_TIDE_LEATHER = BotaniaLootTables.register("equipment/loonium/armorset/tide_leather");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_TIDE_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/tide_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_TIDE_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/tide_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WARD_IRON = BotaniaLootTables.register("equipment/loonium/armorset/ward_iron");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WARD_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/ward_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WAYFINDER_CHAIN = BotaniaLootTables.register("equipment/loonium/armorset/wayfinder_chain");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WAYFINDER_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/wayfinder_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WILD_CHAIN = BotaniaLootTables.register("equipment/loonium/armorset/wild_chain");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WILD_GOLD = BotaniaLootTables.register("equipment/loonium/armorset/wild_gold");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_WILD_DIAMOND = BotaniaLootTables.register("equipment/loonium/armorset/wild_diamond");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COSTUME_ENDERMAN = BotaniaLootTables.register("equipment/loonium/armorset/costume_enderman");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COSTUME_EVOKER = BotaniaLootTables.register("equipment/loonium/armorset/costume_evoker");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COSTUME_VINDICATOR = BotaniaLootTables.register("equipment/loonium/armorset/costume_vindicator");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COSTUME_ILLUSIONER = BotaniaLootTables.register("equipment/loonium/armorset/costume_illusioner");
    public static final ResourceKey<LootTable> LOONIUM_ARMORSET_COSTUME_VEX = BotaniaLootTables.register("equipment/loonium/armorset/costume_vex");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_AXE = BotaniaLootTables.register("equipment/loonium/weapon_axe");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_AXE_GOLD = BotaniaLootTables.register("equipment/loonium/weapon_axe_gold");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_BOW = BotaniaLootTables.register("equipment/loonium/weapon_bow");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_CROSSBOW = BotaniaLootTables.register("equipment/loonium/weapon_crossbow");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_SWORD = BotaniaLootTables.register("equipment/loonium/weapon_sword");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_SWORD_GOLD = BotaniaLootTables.register("equipment/loonium/weapon_sword_gold");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_TRIDENT = BotaniaLootTables.register("equipment/loonium/weapon_trident");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_BY_PROFESSION = BotaniaLootTables.register("equipment/loonium/weapon_by_profession");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_FOR_PIGLIN = BotaniaLootTables.register("equipment/loonium/weapon_for_piglin");
    public static final ResourceKey<LootTable> LOONIUM_WEAPON_FOR_WITHER_SKELETON = BotaniaLootTables.register("equipment/loonium/weapon_for_wither_skeleton");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_ANCIENT_CITY = BotaniaLootTables.register("equipment/loonium/armor_ancient_city");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_BASTION_REMNANT = BotaniaLootTables.register("equipment/loonium/armor_bastion_remnant");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_DESERT_PYRAMID = BotaniaLootTables.register("equipment/loonium/armor_desert_pyramid");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_END_CITY = BotaniaLootTables.register("equipment/loonium/armor_end_city");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_FORTRESS = BotaniaLootTables.register("equipment/loonium/armor_fortress");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_JUNGLE_TEMPLE = BotaniaLootTables.register("equipment/loonium/armor_jungle_temple");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_MANSION = BotaniaLootTables.register("equipment/loonium/armor_mansion");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_MONUMENT = BotaniaLootTables.register("equipment/loonium/armor_monument");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_OUTPOST = BotaniaLootTables.register("equipment/loonium/armor_outpost");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_PORTAL = BotaniaLootTables.register("equipment/loonium/armor_portal");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_SHIPWRECK = BotaniaLootTables.register("equipment/loonium/armor_shipwreck");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_STRONGHOLD = BotaniaLootTables.register("equipment/loonium/armor_stronghold");
    public static final ResourceKey<LootTable> LOONIUM_ARMOR_TRAIL_RUINS = BotaniaLootTables.register("equipment/loonium/armor_trail_ruins");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_ANCIENT_CITY = BotaniaLootTables.register("equipment/loonium/drowned_ancient_city");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_JUNGLE_TEMPLE = BotaniaLootTables.register("equipment/loonium/drowned_jungle_temple");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_MONUMENT = BotaniaLootTables.register("equipment/loonium/drowned_monument");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_PORTAL = BotaniaLootTables.register("equipment/loonium/drowned_portal");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_SHIPWRECK = BotaniaLootTables.register("equipment/loonium/drowned_shipwreck");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_STRONGHOLD = BotaniaLootTables.register("equipment/loonium/drowned_stronghold");
    public static final ResourceKey<LootTable> LOONIUM_DROWNED_TRAIL_RUINS = BotaniaLootTables.register("equipment/loonium/drowned_trail_ruins");
    public static final ResourceKey<LootTable> LOONIUM_PIGLIN_BASTION_REMNANT = BotaniaLootTables.register("equipment/loonium/piglin_bastion_remnant");
    public static final ResourceKey<LootTable> LOONIUM_PIGLIN_PORTAL = BotaniaLootTables.register("equipment/loonium/piglin_ruined_portal");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_ANCIENT_CITY = BotaniaLootTables.register("equipment/loonium/skeleton_ancient_city");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_DESERT_PYRAMID = BotaniaLootTables.register("equipment/loonium/skeleton_desert_pyramid");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_JUNGLE_TEMPLE = BotaniaLootTables.register("equipment/loonium/skeleton_jungle_temple");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_END_CITY = BotaniaLootTables.register("equipment/loonium/skeleton_end_city");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_FORTRESS = BotaniaLootTables.register("equipment/loonium/skeleton_fortress");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_MONUMENT = BotaniaLootTables.register("equipment/loonium/skeleton_monument");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_OUTPOST = BotaniaLootTables.register("equipment/loonium/skeleton_outpost");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_PORTAL = BotaniaLootTables.register("equipment/loonium/skeleton_portal");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_SHIPWRECK = BotaniaLootTables.register("equipment/loonium/skeleton_shipwreck");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_STRONGHOLD = BotaniaLootTables.register("equipment/loonium/skeleton_stronghold");
    public static final ResourceKey<LootTable> LOONIUM_SKELETON_TRAIL_RUINS = BotaniaLootTables.register("equipment/loonium/skeleton_trail_ruins");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_ANCIENT_CITY = BotaniaLootTables.register("equipment/loonium/zombie_ancient_city");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_DESERT_PYRAMID = BotaniaLootTables.register("equipment/loonium/zombie_desert_pyramid");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_END_CITY = BotaniaLootTables.register("equipment/loonium/zombie_end_city");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_FORTRESS = BotaniaLootTables.register("equipment/loonium/zombie_fortress");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_JUNGLE_TEMPLE = BotaniaLootTables.register("equipment/loonium/zombie_jungle_temple");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_MONUMENT = BotaniaLootTables.register("equipment/loonium/zombie_monument");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_OUTPOST = BotaniaLootTables.register("equipment/loonium/zombie_outpost");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_PORTAL = BotaniaLootTables.register("equipment/loonium/zombie_portal");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_SHIPWRECK = BotaniaLootTables.register("equipment/loonium/zombie_shipwreck");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_STRONGHOLD = BotaniaLootTables.register("equipment/loonium/zombie_stronghold");
    public static final ResourceKey<LootTable> LOONIUM_ZOMBIE_TRAIL_RUINS = BotaniaLootTables.register("equipment/loonium/zombie_trail_ruins");

    private static ResourceKey<LootTable> register(String path) {
        return BotaniaLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BotaniaAPI.botaniaRL(path)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> location) {
        if (LOCATIONS.add(location)) {
            return location;
        }
        throw new IllegalArgumentException(String.valueOf(location) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> all() {
        return IMMUTABLE_LOCATIONS;
    }

    public static ResourceKey<LootTable> getDiceRollTable(int roll) {
        return DICE_ROLL_LOOT_TABLES.get(roll - 1);
    }
}

