/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.loot.BotaniaLootModifiers;
import vazkii.botania.xplat.XplatAbstractions;

public class BindUuid
extends LootItemConditionalFunction {
    public static final MapCodec<BindUuid> CODEC = RecordCodecBuilder.mapCodec(instance -> BindUuid.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BindUuid::new));

    public BindUuid(List<LootItemCondition> predicates) {
        super(predicates);
    }

    @NotNull
    public ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.bindToUUID(player.getUUID());
            }
        }
        return stack;
    }

    public LootItemFunctionType<? extends BindUuid> getType() {
        return BotaniaLootModifiers.BIND_UUID;
    }
}

