/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;

public class TerraFirmaRodItem
extends Item {
    private static final int COST_PER = 55;

    public TerraFirmaRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int count) {
        if (count != this.getUseDuration(stack, living) && count % 10 == 0 && living instanceof Player) {
            Player player = (Player)living;
            this.terraform(stack, world, player);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    private void terraform(ItemStack stack, Level world, Player player) {
        int range = ManaItemHandler.instance().hasProficiency(player, stack) ? 22 : 16;
        BlockPos startCenter = player.blockPosition().below();
        if (startCenter.getY() < world.getSeaLevel()) {
            return;
        }
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        for (Object pos : BlockPos.betweenClosed((BlockPos)startCenter.offset(-range, -range, -range), (BlockPos)startCenter.offset(range, range, range))) {
            BlockState state = world.getBlockState((BlockPos)pos);
            if (state.isAir() || !state.is(BotaniaTags.Blocks.TERRAFORMABLE)) continue;
            ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos pos_ = pos.relative(dir);
                BlockState state_ = world.getBlockState(pos_);
                Block block_ = state_.getBlock();
                if (!state_.isAir() && !state_.canBeReplaced() && (!(block_ instanceof FlowerBlock) || state_.is(BotaniaTags.Blocks.SPECIAL_FLOWERS)) && !(block_ instanceof DoublePlantBlock)) continue;
                airBlocks.add(pos_);
            }
            if (airBlocks.isEmpty()) continue;
            if (pos.getY() > startCenter.getY()) {
                blocks.add(new CoordsWithBlock((BlockPos)pos, Blocks.AIR));
                continue;
            }
            for (BlockPos coords : airBlocks) {
                if (world.isEmptyBlock(coords.below())) continue;
                blocks.add(new CoordsWithBlock(coords, Blocks.DIRT));
            }
        }
        int cost = 55 * blocks.size();
        if (world.isClientSide || ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true)) {
            if (!world.isClientSide) {
                for (CoordsWithBlock block : blocks) {
                    world.setBlockAndUpdate((BlockPos)block, block.block.defaultBlockState());
                }
            }
            if (!blocks.isEmpty()) {
                world.playSound(player, player.getX(), player.getY(), player.getZ(), BotaniaSounds.terraformRod, SoundSource.BLOCKS, 1.0f, 1.0f);
                SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 0.35f, 0.2f, 0.05f, 5);
                for (int i = 0; i < 120; ++i) {
                    world.addParticle((ParticleOptions)data, (double)(startCenter.getX() - range) + (double)(range * 2) * Math.random(), (double)(startCenter.getY() + 2) + (Math.random() - 0.5) * 2.0, (double)(startCenter.getZ() - range) + (double)(range * 2) * Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static class CoordsWithBlock
    extends BlockPos {
        private final Block block;

        private CoordsWithBlock(BlockPos pos, Block block) {
            super((Vec3i)pos);
            this.block = block;
        }
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            if (block == Blocks.DIRT) {
                return doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, true) || !doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, false);
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            if (block == Blocks.DIRT) {
                return ManaItemHandler.instance().getInvocationCountForTool(requestor, player, 75);
            }
            return 0;
        }
    }
}

