/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.entity.ThrownItemEntity;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

public class ShadedMesaRodItem
extends Item {
    private static final TagKey<EntityType<?>> BLACKLIST = BotaniaTags.Entities.SHADED_MESA_BLACKLIST;
    private static final float RANGE = 3.0f;
    private static final int COST = 2;
    private static final Predicate<Entity> CAN_TARGET = e -> !e.isSpectator() && e.isAlive() && !e.getType().is(BLACKLIST);
    private static final String TAG_TICKS_TILL_EXPIRE = "ticksTillExpire";
    private static final String TAG_TARGET = "target";
    private static final String TAG_DIST = "dist";

    public ShadedMesaRodItem(Item.Properties props) {
        super(props);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !after.is((Item)this);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        if (!(entity instanceof Player)) {
            return;
        }
        int ticksTillExpire = ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0);
        if (ticksTillExpire == 0) {
            ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
        }
        if (ticksTillExpire >= 0) {
            --ticksTillExpire;
        }
        ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, ticksTillExpire);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ShadedMesaRodItem.leftClick(player);
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0) != 0;
    }

    public static InteractionResult onAttack(Player player, Level level, InteractionHand hand, Entity target, @Nullable EntityHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(BotaniaItems.gravityRod) && ((ShadedMesaRodItem)stack.getItem()).onLeftClickEntity(stack, player, target)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
        double length = ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            Entity target = null;
            if (targetID != -1 && player.level().getEntity(targetID) != null) {
                Entity taritem = player.level().getEntity(targetID);
                boolean found = false;
                Vec3 targetVec = VecHelper.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.add(player.getLookAngle().scale((double)distance)).add(0.0, 0.5, 0.0);
                    entities = player.level().getEntities((Entity)player, VecHelper.boxForRange(targetVec, 3.0), CAN_TARGET);
                    if (!entities.contains(taritem)) continue;
                    found = true;
                }
                if (found) {
                    target = player.level().getEntity(targetID);
                }
            }
            if (target == null) {
                Vec3 targetVec = VecHelper.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.add(player.getLookAngle().scale((double)distance)).add(0.0, 0.5, 0.0);
                    entities = player.level().getEntities((Entity)player, VecHelper.boxForRange(targetVec, 3.0), CAN_TARGET);
                }
                if (entities.size() > 0) {
                    target = (Entity)entities.get(0);
                    length = 5.5;
                    if (target instanceof ItemEntity) {
                        length = 2.0;
                    }
                }
            }
            if (target != null) {
                if (target.getType().is(BLACKLIST)) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                if (ManaItemHandler.instance().requestManaExactForTool(stack, player, 2, true)) {
                    boolean targetIsPlayer = target instanceof Player;
                    if (target instanceof ItemEntity) {
                        ItemEntity item = (ItemEntity)target;
                        item.setPickUpDelay(5);
                    }
                    if (target instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)target;
                        living.fallDistance = 0.0f;
                        if (living.getEffect(MobEffects.MOVEMENT_SLOWDOWN) == null) {
                            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, targetIsPlayer ? 20 : 2, targetIsPlayer ? 1 : 3, true, true));
                        }
                    }
                    Vec3 target3 = VecHelper.fromEntityCenter((Entity)player).add(player.getLookAngle().scale(length)).add(0.0, 0.5, 0.0);
                    if (target instanceof ItemEntity) {
                        target3 = target3.add(0.0, 0.25, 0.0);
                    }
                    for (int i = 0; i < 4; ++i) {
                        float r = 0.5f + (float)Math.random() * 0.5f;
                        float b = 0.5f + (float)Math.random() * 0.5f;
                        float s = 0.2f + (float)Math.random() * 0.1f;
                        float m = 0.1f;
                        float xm = ((float)Math.random() - 0.5f) * m;
                        float ym = ((float)Math.random() - 0.5f) * m;
                        float zm = ((float)Math.random() - 0.5f) * m;
                        WispParticleData data = WispParticleData.wisp(s, r, 0.0f, b);
                        world.addParticle((ParticleOptions)data, target.getX() + (double)(target.getBbWidth() / 2.0f), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ() + (double)(target.getBbWidth() / 2.0f), (double)xm, (double)ym, (double)zm);
                    }
                    MathHelper.setEntityMotionFromVector(target, target3, 0.3333333f);
                    if (targetIsPlayer && target instanceof ServerPlayer) {
                        ServerPlayer p = (ServerPlayer)target;
                        p.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)p));
                    }
                    ItemNBTHelper.setInt(stack, TAG_TARGET, target.getId());
                    ItemNBTHelper.setDouble(stack, TAG_DIST, length);
                }
                ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, 5);
                return InteractionResultHolder.consume((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private static void leftClick(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (!stack.isEmpty() && stack.is(BotaniaItems.gravityRod)) {
            int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
            if (targetID != -1 && player.level().getEntity(targetID) != null) {
                Entity target = player.level().getEntity(targetID);
                boolean found = false;
                Vec3 vec = VecHelper.fromEntityCenter((Entity)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    vec = vec.add(player.getLookAngle().scale((double)distance)).add(0.0, 0.5, 0.0);
                    entities = player.level().getEntities((Entity)player, new AABB(vec.subtract(3.0, 3.0, 3.0), vec.add(3.0, 3.0, 3.0)), CAN_TARGET);
                    if (!entities.contains(target)) continue;
                    found = true;
                }
                if (found) {
                    ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
                    ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
                    Vec3 moveVector = player.getLookAngle().normalize();
                    if (target instanceof ItemEntity) {
                        ItemEntity item = (ItemEntity)target;
                        item.setPickUpDelay(20);
                        float mot = ManaItemHandler.instance().hasProficiency(player, stack) ? 2.25f : 1.5f;
                        item.setDeltaMovement(moveVector.x * (double)mot, moveVector.y, moveVector.z * (double)mot);
                        if (!player.level().isClientSide) {
                            ThrownItemEntity thrown = new ThrownItemEntity(item.level(), item.getX(), item.getY(), item.getZ(), item);
                            item.level().addFreshEntity((Entity)thrown);
                        }
                        item.discard();
                    } else {
                        if (target instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)target;
                            living.setLastHurtByMob((LivingEntity)player);
                            living.setLastHurtByPlayer(player);
                        }
                        target.setDeltaMovement(moveVector.multiply(3.0, 1.5, 3.0));
                    }
                    player.getCooldowns().addCooldown(stack.getItem(), 10);
                }
            }
        }
    }
}

