/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.rod.LandsRodItem;

public class HighlandsRodItem
extends LandsRodItem {
    public HighlandsRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && ManaItemHandler.instance().requestManaExactForTool(stack, player, 150, false)) {
            BlockHitResult hit;
            InteractionResult result;
            int z;
            int y;
            Vec3 playerVec = VecHelper.fromEntityCenter((Entity)player);
            Vec3 lookVec = player.getLookAngle().scale(3.0);
            Vec3 placeVec = playerVec.add(lookVec);
            int x = Mth.floor((double)placeVec.x);
            int entities = world.getEntitiesOfClass(LivingEntity.class, new AABB((double)x, (double)(y = Mth.floor((double)placeVec.y) + 1), (double)(z = Mth.floor((double)placeVec.z)), (double)(x + 1), (double)(y + 1), (double)(z + 1))).size();
            if (entities == 0 && (result = PlayerHelper.substituteUse(new UseOnContext(player, hand, hit = new BlockHitResult(Vec3.ZERO, Direction.DOWN, new BlockPos(x, y, z), false)), new ItemStack((ItemLike)Blocks.DIRT))).consumesAction()) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 150, true);
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 0.35f, 0.2f, 0.05f, 5);
                for (int i = 0; i < 6; ++i) {
                    world.addParticle((ParticleOptions)data, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
    }
}

