/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.FlameRingEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class HellsRodItem
extends Item {
    private static final ResourceLocation avatarOverlay = ResourceLocation.parse((String)"botania:textures/model/avatar_fire.png");
    private static final int COST = 900;
    private static final int COOLDOWN = 1200;

    public HellsRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        BlockPos pos = ctx.getClickedPos();
        if (player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, false) && !world.isClientSide()) {
            FlameRingEntity entity = (FlameRingEntity)BotaniaEntities.FLAME_RING.create(world);
            entity.setPos((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
            world.addFreshEntity((Entity)entity);
            if (!player.isCreative()) {
                player.getCooldowns().addCooldown((Item)this, ManaItemHandler.instance().hasProficiency(player, stack) ? 600 : 1200);
            }
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, true);
            world.gameEvent((Entity)player, (Holder)GameEvent.PROJECTILE_SHOOT, pos);
            ctx.getLevel().playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), BotaniaSounds.fireRod, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide());
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.getLevel();
            BlockPos pos = te.getBlockPos();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, pos, te.getBlockState(), te, null);
            if (!world.isClientSide && receiver.getCurrentMana() >= 900 && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
                FlameRingEntity entity = (FlameRingEntity)BotaniaEntities.FLAME_RING.create(world);
                entity.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)entity);
                receiver.receiveMana(-900);
                world.gameEvent(null, (Holder)GameEvent.PROJECTILE_SHOOT, pos);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }
}

