/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RelicBaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.lib.BotaniaTags;

public class RingOfOdinItem
extends RelicBaubleItem {
    public RingOfOdinItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void onValidPlayerWornTick(Player player) {
        if (player.isOnFire()) {
            player.clearFire();
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(BotaniaAPI.botaniaRL("odin_ring"), 20.0, AttributeModifier.Operation.ADD_VALUE));
        return attributes;
    }

    public static boolean onPlayerAttacked(Player player, DamageSource src) {
        return src.is(BotaniaTags.DamageTypes.RING_OF_ODIN_IMMUNE) && !EquipmentHandler.findOrEmpty(BotaniaItems.odinRing, (LivingEntity)player).isEmpty();
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, BotaniaAPI.botaniaRL("challenge/odin_ring"));
    }
}

