/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.BotaniaDamageTypes;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class RelicImpl
implements Relic {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";
    private final ItemStack stack;
    @Nullable
    private final ResourceLocation advancementId;

    public RelicImpl(ItemStack stack, @Nullable ResourceLocation advancementId) {
        this.stack = stack;
        this.advancementId = advancementId;
    }

    @Override
    public void bindToUUID(UUID uuid) {
        ItemNBTHelper.setString(this.stack, TAG_SOULBIND_UUID, uuid.toString());
    }

    @Override
    @Nullable
    public UUID getSoulbindUUID() {
        if (ItemNBTHelper.verifyExistance(this.stack, TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString(this.stack, TAG_SOULBIND_UUID, ""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry(this.stack, TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ResourceLocation getAdvancement() {
        return this.advancementId;
    }

    @Override
    public void tickBinding(Player player) {
        if (this.stack.isEmpty()) {
            return;
        }
        if (this.getSoulbindUUID() == null) {
            this.bindToUUID(player.getUUID());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RelicBindTrigger.INSTANCE.trigger(serverPlayer, this.stack);
            }
        } else if (!this.isRightPlayer(player) && player.tickCount % 10 == 0 && this.shouldDamageWrongPlayer()) {
            player.hurt(RelicImpl.damageSource(player.level().registryAccess()), 2.0f);
        }
    }

    @Override
    public boolean isRightPlayer(Player player) {
        return player.getUUID().equals(this.getSoulbindUUID());
    }

    private static DamageSource damageSource(RegistryAccess registryAccess) {
        return BotaniaDamageTypes.Sources.relicDamage(registryAccess);
    }

    public static void addDefaultTooltip(ItemStack stack, List<Component> tooltip) {
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null) {
            return;
        }
        if (relic.getSoulbindUUID() == null) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.relicUnbound"));
        } else {
            Player player = ClientProxy.INSTANCE.getClientPlayer();
            if (player == null || !relic.isRightPlayer(player)) {
                tooltip.add((Component)Component.translatable((String)"botaniamisc.notYourSagittarius"));
            } else {
                tooltip.add((Component)Component.translatable((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{player.getName()}));
            }
        }
    }
}

